#include <net/datapath_proc_api.h>  /*for proc api */

/*an examle to create a proc file: /proc/demo:
         /proc/demo/dbg : which is a single callback example 
         /proc/demo/port: which is a multiple callback example

Usage: just call demo_proc_install(void) API to create the demo proc
*/

#define DEMO_PROC_NAME       "demo"
#define DEMO_PROC_BASE       "/proc/"DEMO_PROC_NAME"/"
#define DEMO_PROC_PARENT     ""


#define DEMO_PROC_FILE_DBG   "dbg"
#define DEMO_PROC_FILE_PORT   "port"


#define  MAX_PORT_NUM 10

static void proc_dbg_dump(struct seq_file *s);
static int proc_port_start(void);
static int proc_port_dump(struct seq_file *s, int pos);
static ssize_t proc_dbg_write(struct file *file, const char *buf, size_t count, loff_t *ppos);

static struct ltq_proc_entry demo_proc_entries[] = {
	/* name             single_callback_t    multi_callback_t    multi_callback_start    write_callback_t  */
	{DEMO_PROC_FILE_DBG,	proc_dbg_dump,     NULL,               NULL,                   proc_dbg_write},
	{DEMO_PROC_FILE_PORT, NULL,                proc_port_dump,     proc_port_start,        NULL}

};

void proc_dbg_dump(struct seq_file *s)
{
	
	seq_printf(s, "proc_dbg_dump demo");		
}


int proc_port_dump(struct seq_file *s, int pos)
{
	seq_printf(s, "pos=%d\n", pos);
	
	pos ++;
	if( pos  >= MAX_PORT_NUM )
		pos = -1; //end of the loop
	return pos;
}


int proc_port_start(void)
{
	
	return 0;
}


ssize_t proc_dbg_write(struct file *file, const char *buf, size_t count, loff_t *ppos)
{
	int len;
	char str[64];	

	len = (sizeof(str)>count)?count:sizeof(str)-1 ;
	len -= copy_from_user(str, buf, len);
	str[len] = 0;

	/*handle buffer str accordignly */
	
	return count;
}


int demo_proc_install(void)
{
	struct proc_dir_entry *proc_node;

	proc_node = proc_mkdir(DEMO_PROC_PARENT DEMO_PROC_NAME, NULL);
	if (proc_node != NULL) {
		int i;
		for (i = 0; i < ARRAY_SIZE(demo_proc_entries); i++)
			ltq_proc_entry_create(proc_node, &demo_proc_entries[i]);
	} else {
		printk("cannot create proc entry");
		return -1;
	}
	return 0;
}

