#include "memmgrm.h"
#include "tasklib.h"
#include "string.h"
#include "stdio.h"

void t1(int blockSize, int taskno);

void MemMgrTest(void)
{
	
	MMM_CFG cfg[10];

	memset( cfg, 0, sizeof(cfg) );
	
    cfg[0].nBlockSize = 8;   cfg[0].nBlockNum = 3; cfg[0].bfFixed = TRUE;
	cfg[1].nBlockSize = 15;  cfg[1].nBlockNum = 5; cfg[1].bfFixed = TRUE;
	cfg[2].nBlockSize = 31;  cfg[2].nBlockNum = 2; cfg[2].bfFixed = TRUE;
	cfg[3].nBlockSize = 53;  cfg[3].nBlockNum = 4; cfg[3].bfFixed = TRUE;
	cfg[4].nBlockSize = 65;  cfg[4].nBlockNum = 3; cfg[4].bfFixed = FALSE;
	cfg[5].nBlockSize = 100;  cfg[5].nBlockNum = 3; cfg[5].bfFixed = FALSE;
	cfg[6].nBlockSize = 0;   cfg[6].nBlockNum = 0; cfg[6].bfFixed = FALSE;

	mmm_init(cfg);

	taskSpawn("t1", 100, 0, 100, (FUNCPTR )t1, 7,1,3,4,5,6,7,8,9,10);
	taskSpawn("t2", 100, 0, 100, (FUNCPTR )t1, 10,2,3,4,5,6,7,8,9,10);
	taskSpawn("t3", 100, 0, 100, (FUNCPTR )t1, 30,3,3,4,5,6,7,8,9,10);
	taskSpawn("t4", 100, 0, 100, (FUNCPTR )t1, 50,4,3,4,5,6,7,8,9,10);


	while(1)
	{
		char buf[100];

		do
		{
			gets(buf);

			if( strlen(buf) > 0 )
			{
				mmm_ShowFreeMem(1);
				//mmm_ShowFreeMem(2);

				mmm_ShowUsedMem(1);
				mmm_ShowUsedMem(2);
					
			}
			
		} while( 1);
		
	}	 
}


void t1(int blockSize, int taskno)
{
	char *p[10]={0};
	int operation=1;
	int n,i;
	char name[10];


	printf("blockSize = %d\r\n", blockSize );
	sprintf(name, "t%d", taskno );

	while(1)
	{
		n = (rand() % 10);
		n++;
		
		//printf("n = %d\r\n", n);
			
		if( operation == 1 ) 
		{
			for( i=0; i<10; i++) 
			{
				if( p[i] == NULL ) 
				{
					p[i] = mmm_malloc(blockSize, name);
					n--;

					if( n == 0 ) break;
				}
			}
			
			operation = 2;
		}
		else if( operation == 2 ) 
		{
			//printf("want to free %d\r\n", n);
			for( i=0; i<10; i++) 
			{
				if( p[i] != NULL ) 
				{	
					mmm_free(p[i], name);
					p[i] = NULL;

					n--;

					if( n == 0 ) break;
				}
			}
		
			operation = 1;
		}

		taskDelay(10);
	}

	
}

