#!/usr/bin/python
import time
#
#  The backup repository should be created via below methods
#  Note: This script is used to backup local svn repo via file://xxxx to remote svn repo via svn:// url link
#  The method to create remote svn initial repo via below method
#  svnadmin create backup-repos
#  chmod a+x backup-repos/hooks/pre-revprop-change
#  The  backup-repos/hooks/pre-revprop-change contents should just includes below one line is enough:
#  #!/bin/sh

import os
import datetime
#repositorys is a 2D array, first parameter is source repository and 2nd is destination repository
#                Source Repo via svn:// URL Link            Destination local repo path via file://
repositorys=[ ["svn://10.64.44.136/ppa",                     "file:///mnt/data/svn_backup/repo/ppa"],
              ["svn://10.64.44.136/svn_cfg",                 "file:////mnt/data/svn_backup/repo/svn_cfg"],
              ["svn://10.64.44.136/www",                     "file:///mnt/data/svn_backup/repo/www"],
              ["svn://10.64.44.136/template_repos_svnsync",  "file:///mnt/data/svn_backup/repo/template_repos_svnsync"],
           ];

dst_svn_repo_path="/mnt/data/svn_backup/template_repos_svnsync"
svn_log_param=" 2>@1 "
print len(repositorys);

num= len(repositorys);
need_copy=0
debug_loop_mode=0;


now = datetime.datetime.now()

print
print "Current svn syn at :"
print str(now)



for i in range(0,num ):
  # print each number
  #print repositorys[i][0];
  #print repositorys[i][1];
  #first check whether a mirroring svn folder exist or not. If not, create first

  print ""
  print "" 
  print "-------From " + repositorys[i][0] + " to " + repositorys[i][1] + "-------------"
  print i
  dest_folder=repositorys[i][1][7:]; #remove file://
  print dest_folder

  if os.path.exists( dest_folder ):  #check whether file or directory exist
    if os.path.isdir( dest_folder ):  #check whether it is a folder
      print "exist already"
      pass
    else: #it is a file, not folder, so delete it first
      os.remove( dest_folder );
      need_copy=1
      print "need_copy"
  else:
    need_copy=1
    print "need_copy"
           
  if need_copy == 1:
    cmd_str='cp ' + dst_svn_repo_path + ' ' + dest_folder + " -a"
    print cmd_str
    output = os.popen(cmd_str).read()
    print output


  cmd_str="svnsync init " + repositorys[i][1] + " " + repositorys[i][0] + svn_log_param;
  print cmd_str
  if debug_loop_mode == 1:
    pass
  else:
    output = os.popen(cmd_str).read()
    print output
  
  cmd_str="svnsync synchronize " + repositorys[i][1] + svn_log_param;
  print cmd_str

  if debug_loop_mode == 1:
    pass
  else:
    output = os.popen(cmd_str).read()
    print output

  print "current svnsync done--------------"
 
  now = time.strftime("%c")
  ## date and time representation
  print "Current date & time " + time.strftime("%c") 
