/*                         							
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                        SOFTWARE FILE/MODULE HEADER                      |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *                                San Diego, CA                            |
 *=========================================================================+
 *
 * Module:  mac.h - Header file for unicast, multicast and broadcast MAC 
 *                  address handling
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/EMAC/MAC.H,v 1.1.1.1 2004/04/01 09:10:05 shao-gh Exp $
 *
 * Description:  Defines, structures & prototypes associated with MAC 
 *               addresses
 * 
 * Author:  Steve Muller
 *
 * Modifications:
 *
 * $Log: MAC.H,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:35  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:50  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:24  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.2   Apr 17 2001 19:39:24   dinhtm
 * BootBSP support
 * 
 * 
 *    Rev 1.1   03 Nov 2000 16:28:26   dinhtm
 *  
 * 
 *    Rev 1.0   29 Sep 2000 19:39:28   sneedgc
 *  
 * Revision 1.12  1999/11/15 04:32:53Z  smithdl
 * VSS - Baseline_from_VSS
 * 
 * 3     9/28/99 6:10p Pennjj
 * EWI 3386 - Mcast Filtering Off
 * 
 * 5     9/27/99 10:02p Smuller
 * EWI 3386 - Mcast Filtering Off
 * 
 * 2     9/25/99 9:39a Pennjj
 * Integrating 3218
 * 
 * Lint.  Coding Standards.
 * 
 * 3     9/23/99 7:04p Smuller
 * Lint.  Coding Standards.
 * 
 * 1     9/20/99 9:47p Pennjj
 * Adding for EWI_3177
 * 
 * 1     9/16/99 3:50p Smuller
 * Multicast filtering that uses bsearch & qsort.
 * 
 * 
 *=========================================================================+
 */


/*##################################################################*/
#ifndef __MAC_H
#define __MAC_H
/****************************************************************************
 * Include Files
 ****************************************************************************/

#include <vxWorks.h>
#include <string.h>


/****************************************************************************
 * Defines
 ****************************************************************************/

/* length of MAC address (in bytes) */
#define MAC_ADDR_LEN          ( 6 ) 
           
/* return value for MAC_cmp */
#define MAC_GREATER           ( 1 )    
#define MAC_EQUAL             ( 0 )
#define MAC_LESS              ( -1 )

/* size of multicast address and hash tables */
#define MULTI_TABLE_SIZE      ( 256 )
#define HASH_TABLE_SIZE       ( 32 )

/* bit which defines whether a MAC Address is multi or uni cast */
#define MULTICAST_MSK         ( 0x01 )

/* hash table initialization values */
#define FILTER_ALL            ( 0x00 )
#define PASS_ALL              ( 0xFF )


/****************************************************************************
 * Structures
 ****************************************************************************/

/* MAC Address */
typedef UINT8 MAC_ADDR[MAC_ADDR_LEN];

/* aligned MAC address */
typedef struct aligned_mac_addr
{
   UINT16      usLSW;      /* least significant word */
   UINT16      usCSW;      /* middle word */
   UINT16      usMSW;      /* most significant word */
} ALIGNED_MAC_ADDR;


/****************************************************************************
 * Prototypes
 ****************************************************************************/

int   MAC_cmp(const void *, const void *);
void  MAC_SetupHashTable(MAC_ADDR *, UINT16 , UINT8 *);
#endif /*  End of __MAC_H  */
/*###################################################*/

