/****************************************************************************
*
*	Name:			IpCfg.h
*
*	Description:	Ip Configuration declarations.
*
*	Copyright:		(c) 2002 Conexant Systems Inc.
*
*	Revision:	Date:		Author: 			Description:
*
*	00.00.0000	07/29/02	George G. Vlasov	Created.
*
*****************************************************************************
*	$Author: shao-gh $
*	$Revision: 1.1.1.1 $
*	$Modtime:   Apr 16 2003 14:09:12  $
****************************************************************************/

#ifndef IPCFG_H
#define IPCFG_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"

#include "JxCfgMgr.h"

#include "IpDnsS.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

#define DBG_IP_CFG_GATEWAY_IP_ADRESS_ENABLED		(1)
#define DBG_IP_CFG_DNS_SERVER_LIST_ENABLED			(1)

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef 
enum IP_CFG_GATEWAY_MODE_T
{
	IP_CFG_GATEWAY_MODE_NONE,
	IP_CFG_GATEWAY_MODE_AUTO,
	IP_CFG_GATEWAY_MODE_NETIF,
	IP_CFG_GATEWAY_MODE_IPADDRESS,

	IP_CFG_LISTENER_MODE_MAX
} IP_CFG_GATEWAY_MODE_T;

typedef
struct IP_CFG_GATEWAY_DATA_T
{
	IP_CFG_GATEWAY_MODE_T	Mode;
	NET_IF_ALIAS_T			NetIfAlias;
#if (DBG_IP_CFG_GATEWAY_IP_ADRESS_ENABLED)
	IP_ADDRESS_STRING_T		IpAddress;
#endif /* (DBG_IP_CFG_GATEWAY_IP_ADRESS_ENABLED) */ 
} IP_CFG_GATEWAY_DATA_T;

typedef
struct IP_CFG_ROUTE_DATA_T
{
    IP_ADDRESS_STRING_T		Destination;
    IP_ADDRESS_STRING_T		SubnetMask;
	BOOL					UserGatewayEnabled;
    IP_ADDRESS_STRING_T		Gateway;
	NET_IF_ALIAS_T			NetIfAlias;
} IP_CFG_ROUTE_DATA_T;

/****************************************************************************
*  Function prototypes
****************************************************************************/

/****************************************************************************
*
*	Name:			IpCfgCfgGatewaySet
*	
*	Description:	Sets Gateway parameters.
*	
*	Parameters: 	pData	-	pointer to Gateway configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgGatewaySet
(
	IP_CFG_GATEWAY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgCfgGatewayGet
*	
*	Description:	Gets Gateway parameters.
*	
*	Parameters: 	pData	-	pointer to Gateway configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgGatewayGet
(
	IP_CFG_GATEWAY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgCfgRouteAdd
*	
*	Description:	Adds/sets route entry.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgRouteAdd
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgCfgRouteDelete
*	
*	Description:	Deletes route entry.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*								Destination value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgRouteDelete
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgCfgRouteGet
*	
*	Description:	Gets route entry.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*								Destination value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgRouteGet
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgCfgRouteEnumerate
*	
*	Description:	Enumerates route entry.
*	
*	Parameters: 	Index	-	index of route entry.
*	
*					pData	-	pointer to route entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgCfgRouteEnumerate
(
	ULONG					Index, 
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgGatewayGet
*	
*	Description:	Gets IP parameters from active configuration.
*	
*	Parameters: 	pData	-	pointer to IP configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgGatewayGet
(
	IP_CFG_GATEWAY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgRouteGet
*	
*	Description:	Gets route entry from active configuration.
*					For internal use only.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*								Destination value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgRouteGet
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgRouteEnumerate
*	
*	Description:	Enumerates route entry from active configuration.
*					For internal use only.
*	
*	Parameters: 	Index	-	index of route entry.
*	
*					pData	-	pointer to route entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgRouteEnumerate
(
	ULONG					Index, 
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgRouteAdd
*	
*	Description:	Adds/sets route entry and update routing table.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgRouteAdd
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgRouteDelete
*	
*	Description:	Deletes route entry and update routing table.
*	
*	Parameters: 	pData	-	pointer to route entry configuration structure.
*								Destination value must be specified.
*
****************************************************************************/

BOOL
IpCfgRouteDelete
(
	IP_CFG_ROUTE_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgDnsServerAdd
*	
*	Description:	Adds/sets DNS Server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgDnsServerAdd
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgDnsServerDelete
*	
*	Description:	Deletes DNS server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgDnsServerDelete
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgDnsServerFind
*	
*	Description:	Gets DNS server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgDnsServerFind
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCfgDnsServerEnumerate
*	
*	Description:	Enumerates DNS server entry.
*					For internal use only.
*	
*	Parameters: 	Index	-	index of DNS server entry.
*	
*					pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCfgDnsServerEnumerate
(
	ULONG					Index, 
	IP_DNS_SERVER_DATA_T*	pData
);

void IpAutoConnStart(BOOL bSequenced);

#endif /* IPCFG_H */ 
