/****************************************************************************
*
*   Name:           IpDnsS.h
*
*   Description:    Ip Dns Server list.
*
*   Copyright:      (c) 2002 Conexant Systems Inc.
*
*   Revision:   Date:       Author:             Description:
*
*   00.00.0000  10/24/02    George G. Vlasov    Created.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Oct 25 2002 14:41:26  $
****************************************************************************/

#ifndef IPDNSS_H
#define IPDNSS_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"
#include "bsptypes.h"

#include "JxArrSrv.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef 
IP_ADDRESS_T IP_DNS_SERVER_DATA_T;

typedef
IP_DNS_SERVER_DATA_T IP_DNS_SERVER_LIST_ITEM_T;

typedef
JX_ARRAY_SIZE_T IP_DNS_SERVER_LIST_INDEX_T;

typedef
struct IP_DNS_SERVER_LIST_T
{
	JX_ARRAY_T*	pList;
    SEM_ID		Lock;
} IP_DNS_SERVER_LIST_T;

/****************************************************************************
*  Object declarations
****************************************************************************/

/****************************************************************************
*  Function prototypes
****************************************************************************/

BOOL 
IpDnsServerDataGet
(
	IP_DNS_SERVER_DATA_T*	pThis, 
	IP_DNS_SERVER_DATA_T*	pData 
);

BOOL 
IpDnsServerDataSet
(
	IP_DNS_SERVER_DATA_T*	pThis, 
	IP_DNS_SERVER_DATA_T*	pData 
);

IP_DNS_SERVER_LIST_T*
IpDnsServerListCreate
(
);

void 
IpDnsServerListDestroy
(
	IP_DNS_SERVER_LIST_T*	pThis
);

BOOL 
IpDnsServerListLock
(
	IP_DNS_SERVER_LIST_T*	pThis
);

BOOL 
IpDnsServerListUnlock
(
	IP_DNS_SERVER_LIST_T*	pThis
);

BOOL
IpDnsServerListCopy
(
	IP_DNS_SERVER_LIST_T*	pThis, 
	IP_DNS_SERVER_LIST_T*	pList
);

BOOL
IpDnsServerListFind
(
	IP_DNS_SERVER_LIST_T*		pThis, 
	IP_DNS_SERVER_DATA_T*		pData, 
	IP_DNS_SERVER_LIST_INDEX_T*	pIndex
);

BOOL 
IpDnsServerListGet
(
	IP_DNS_SERVER_LIST_T*		pThis, 
	IP_DNS_SERVER_LIST_INDEX_T	Index, 
	IP_DNS_SERVER_LIST_ITEM_T*	pItem
);

BOOL
IpDnsServerListRemove
(
	IP_DNS_SERVER_LIST_T*		pThis, 
	IP_DNS_SERVER_LIST_INDEX_T	Index
);

BOOL
IpDnsServerListAdd
(
	IP_DNS_SERVER_LIST_T*	pThis, 
	IP_DNS_SERVER_DATA_T*	pData
);

BOOL
IpDnsServerListRead
(
	IP_DNS_SERVER_LIST_T*	pThis, 
	char*					pRegPath
);

BOOL
IpDnsServerListWrite
(
	IP_DNS_SERVER_LIST_T*	pThis, 
	char*					pRegPath
);

BOOL
IpCtxDnsServerAdd
(
	IP_DNS_SERVER_DATA_T*	pData
);

BOOL
IpCtxDnsServerDelete
(
	IP_DNS_SERVER_DATA_T*	pData
);

BOOL
IpCtxDnsServerFind
(
	IP_DNS_SERVER_DATA_T*	pData
);

BOOL
IpCtxDnsServerEnumerate
(
	ULONG					Index, 
	IP_DNS_SERVER_DATA_T*	pData
);

#endif /* IPDNSS_H */ 
