/* Copyright 2000 PDS, All Rights Reserved */
/* 
 *    CVS Log:
 *
 *    $Log: NaptControl.h,v $
 *    Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 *    no message
 *
 *    Revision 1.1.1.1  2004/01/16 09:32:41  SHAO-GH
 *    no message
 *
 *    Revision 1.1  2004/01/16 07:05:36  SHAO-GH
 *    no message
 *
 *    Revision 1.1.1.1  2003/12/23 10:28:55  SHAO-GH
 *    no message
 *
 *    Revision 1.1.1.1  2003/11/21 08:29:42  SHAO-GH
 *    2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 *    Revision 1.10  2002/08/19 09:49:56  .WU-JING.SOFTWARE.R&D
 *    wujing modify for pptp
 *
 * 
 *    Revision 1.9   Apr 08 2002 18:17:36   Administrator
 * No change.
 * 
 *    Revision 1.8   Apr 08 2002 17:47:42   Administrator
 * No change.
 * 
 *    Revision 1.7   11 Dec 2001 12:24:28   TTY
 * Added prototype for nat_set_dmz_entry().
 * 
 *    Revision 1.6   03 Oct 2001 17:07:52   TTY
 * Changed prototype nat_set_direct_entry(), added nat_direct_remove_alias() and
 * nat_direct_restore_alias().
 * 
 *    Revision 1.5   13 Sep 2001 19:15:54   TTY
 * Added prototypes for nat_set_direct_entry() and nat_direct_delete_alias().
 * 
 *    Revision 1.4   18 Jun 2001 13:13:04   TTY
 * Added prototypes to get rid of compiler warnings.
 * 
 *    Revision 1.3   01 Mar 2001 17:49:50   TTY
 * Added NAT_PBE_SERVER_TYPE_LEN
 * 
 *    Revision 1.2   28 Feb 2001 17:34:46   TTY
 * Changed maximum number of ip and port based entries to 20.
 * Modified NAT_PORT_BASED_ENTRY structure to support port range
 * 
 *    Revision 1.1   28 Feb 2000 12:07:48   TTY
 * Initial revision.
 * 
 */

#ifndef INCnatcontrolh
#define INCnatcontrolh

#include <lstLib.h>

/*****************************************************************
 *
 *  Defines
 *
******************************************************************/

#define MAX_NAT_PORT_ENTRIES_O  10  /* old values */
#define MAX_NAT_IP_ENTRIES_O    10

#define MAX_NAT_PORT_ENTRIES    30
#define MAX_NAT_IP_ENTRIES      30

#define NAT_PORT_ENTRY_TCP      0
#define NAT_PORT_ENTRY_UDP      1

#define NAT_PBE_SERVER_TYPE_LEN 16

/*****************************************************************
 *
 *  Structures
 *
******************************************************************/

/* old structure */
typedef struct {
    unsigned long   local_ip_address;
    USHORT          protocol;
    USHORT          port_number;
    char            server_type[16];
} NAT_PORT_BASED_ENTRY_O, *pNAT_PORT_BASED_ENTRY_O;


/* old structure */
typedef struct {
    unsigned long   local_ip_address;
    unsigned long   global_ip_address;
} NAT_IP_BASED_ENTRY_O, *pNAT_IP_BASED_ENTRY_O;

typedef struct {
    unsigned long   local_ip_address;
    USHORT          protocol;
    USHORT          port_number_from;
    USHORT          port_number_to;
    char            server_type[NAT_PBE_SERVER_TYPE_LEN];
} NAT_PORT_BASED_ENTRY, *pNAT_PORT_BASED_ENTRY;


typedef struct {
    unsigned long   local_ip_address;
    unsigned long   global_ip_address;
} NAT_IP_BASED_ENTRY, *pNAT_IP_BASED_ENTRY;


#define PORT_FORWARD_LEN_ENABLED    4 
#define PORT_FORWARD_LEN_IPADDR     20 
#define PORT_FORWARD_LEN_PORT       8 
#define PORT_FORWARD_LEN_PROTOCOL   4
#define PORT_FORWARD_LEN_DESC       32

typedef struct port_forward_entry
{
    NODE node; /* We are contained in a linked list. */
    char server_port[PORT_FORWARD_LEN_PORT];
    char protocol[PORT_FORWARD_LEN_PROTOCOL];
    char local_port[PORT_FORWARD_LEN_PORT];
    char local_ip_address[PORT_FORWARD_LEN_IPADDR];
    char enabled[PORT_FORWARD_LEN_ENABLED];
    char description[PORT_FORWARD_LEN_DESC];
    char server_port_to[PORT_FORWARD_LEN_PORT];
} PORT_FORWARD_ENTRY;

/*****************************************************************
 *
 *  Prototypes
 *
******************************************************************/
int nat_init_port_entries (void);
int nat_init_ip_entries (void);
int nat_set_state (int state);
int nat_add_port_entry (unsigned long ip_address, USHORT protocol, USHORT port_number_from, USHORT port_number_to, char *server_type);
int nat_delete_port_entry (int entry);
int nat_add_ip_entry (unsigned long local_ip_address, unsigned long global_ip_address);
int nat_delete_ip_entry (int entry);
int nat_set_direct_entry (unsigned long * ip_address, unsigned long * mask);
int nat_direct_delete_alias(void);
int nat_direct_remove_alias(unsigned long ip_address);
int nat_direct_restore_alias(unsigned long ip_address);
int nat_set_dmz_entry(unsigned long dmzIp);

#endif
