/*
 * $Log: nat_ip_interface.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:43  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:17:28  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:47:20  TTY
 * Initial revision
 *
 * 
 * 4     11/06/98 5:47p Nishit
 * Fixed type incompatibility issues
 * 
 * 3     9/23/98 5:47p Nishit
 * the translation for packet received on local side is now done on local rx as against global tx
 * for NATS (NATG will follow); modified local rx filters,  changes for making code work on SENS
 * (VxWorks); added functionality for dial on demand global port; Upon rx, the first forking is
 * based on global/local rx port (used to be packet type) and then according to packet type; added
 * support for IP fragments
 * 
 * 2     9/08/98 5:04p Nishit
 * Updated copyright notice
 * 
*/
/************************************************************************/
/*	Copyright (C) 1997 - 1998 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#if !defined (_IPNAT_H_)
#define _IPNAT_H_

typedef struct NAT_FILTER_INTERFACE
{
	enum TEST				(*fptr_nat_tx) (UNION_IP_PACKET *uptr_tx_packet, USHORT tx_port_number,
								   enum SNAP_PROTOCOL_ID protocol_type, USHORT *number_of_bytes);
	enum TEST				(*fptr_nat_rx) (UNION_IP_PACKET *uptr_tx_packet, USHORT rx_port_number,
									enum SNAP_PROTOCOL_ID protocol_type, USHORT *size_of_packet);

	void						(*fptr_nat_get_global_port_ip_address_mask) (USHORT port_number, ULONG address, ULONG mask);

	enum IP_SEND_CONFIRMATION (*fptr_ip_determine_next_hop_and_send_packet) (IP_PARAMETERS *sptr_ip_parameters,
									UNION_IP_PACKET *sptr_ip_packet,
									USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *p_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
									enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
									void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet), ULONG type_of_service,
									IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);

	ULONG						ip_stack_id;
} NAT_FILTER_INTERFACE;


#endif
