/*
 * $Log: nat_structures.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.2  2004/01/26 10:02:04  SHAO-GH
 * add some system head file
 *
 * Revision 1.16  2003/12/22 10:30:33  TTY
 * Added member to TCP_TRANSLATION_ENTRY and UDP_TRANSLATION_ENTRY
 * structures
 *
 * Revision 1.15  2003/12/18 07:24:38  TTY
 * Added prototypes from nat_icq.c
 *
 * Revision 1.14  2003/07/01 01:15:12  TTY
 * support mapping of external port to different internal port, for Messenger
 * to work.
 *
 * Revision 1.13  2001/12/11 10:03:32  TTY
 * Added various fields to NAT_CLASS for DMZ support.
 * Added prototypes from nat_net2phone.c
 *
 * 
 *    Revision 1.12   13 Sep 2001 18:32:10   TTY
 * Structure NAT_CLASS modified, p_do_not_translate_list is now an array. 
 * 
 *    Revision 1.11   13 Sep 2001 14:01:44   TTY
 * Added field compare_source_ip_address to structure NAT_DO_NOT_TRANSLATE_PAIR.
 * 
 *    Revision 1.10   28 Jun 2001 09:16:04   TTY
 * Added translation entry structures for ESP and ISAKMP.
 * Added prototypes from nat_ipsec.c.
 * 
 *    Revision 1.9   12 Jun 2001 10:27:28   TTY
 * Added prototypes for match_sa_ports_with_tcp_entry() & match_sa_ports_with_udp_entry().
 * 
 *    Revision 1.8   21 Mar 2001 09:49:22   TTY
 * Added prototypes to get rid of compiler warnings
 * 
 *    Revision 1.7   01 Mar 2001 17:57:30   TTY
 * Modified NAT_PORT_STATIC_ENTRY to support Port Range.
 * 
 *    Revision 1.6   09 Oct 2000 14:10:48   TTY
 * Changed UDP & TCP static port translation entries' defines, to support
 * special purpose port translation entries
 * 
 *    Revision 1.5   15 Sep 2000 11:43:38   TTY
 * For structure IP_TRANSLATION_HEADER, changed fields type TRANSLATION_ENTRY to
 * IP_TRANSLATION_ENTRY
 * 
 *    Revision 1.4   05 Sep 2000 18:37:40   TTY
 * Added prototypes from nat_irc.c
 * 
 *    Revision 1.3   31 Jul 2000 10:48:36   TTY
 * Added PPTP translation structures
 * Added fields to NAT_CLASS, e.g. tcp_max_segment_size, global_is_ppp etc
 * 
 *    Revision 1.2   21 Feb 2000 14:16:16   TTY
 * Updated to Routerware's NAT release dated 29-Nov-1999
 * 
 *    Revision 1.1   23 Nov 1999 12:47:18   TTY
 * Initial revision.
 * 
 * 10    11/29/99 2:53p Rob
 * Fix for Alexander.Volinsky@ecitele.com:
 * fragment_info_iterator is no longer dynamically allocated in nat_check_fragment_agent_timer(). It
 * is now created (one for each port) in initialize_nat() and freed in
 * nat_clean_up_fragment_agent_list().
 * 
 * 9     2/03/99 7:56a Nishit
 * The members of fragment list (per interface) were never aged out until shut-down.  This used to
 * result in loss of resources.  Now the structure NAT_FRAGMENT_INFO has a timer member, which is
 * initialized to the TTL of the IP packet which generates this fragment info.  The timer is
 * decremented every second, and when it reaches zero, the fragment info is removed.
 * 
 * 8     12/10/98 9:49a Nishit
 * Configurable booleans now use set_enum_enable
 * 
 * 7     11/06/98 5:47p Nishit
 * Fixed type incompatibility issues
 * 
 * 6     10/02/98 9:34a Nishit
 * Setting default value is done now while configuration, instead of setting a boolean while
 * configuration and then while initialization
 * 
 * 5     9/23/98 5:47p Nishit
 * the translation for packet received on local side is now done on local rx as against global tx
 * for NATS (NATG will follow); modified local rx filters,  changes for making code work on SENS
 * (VxWorks); added functionality for dial on demand global port; Upon rx, the first forking is
 * based on global/local rx port (used to be packet type) and then according to packet type; added
 * support for IP fragments
 * 
 * 4     9/08/98 5:04p Nishit
 * Updated copyright notice
 * 
*/
/************************************************************************/
/*  Copyright (C) 1997 - 1998 RouterWare, Inc.                                 */
/*  Unpublished - rights reserved under the Copyright Laws of the           */
/*  United States.  Use, duplication, or disclosure by the                  */
/*  Government is subject to restrictions as set forth in                   */
/*  subparagraph (c)(1)(ii) of the Rights in Technical Data and             */
/*  Computer Software clause at 252.227-7013.                                       */
/*  RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
typedef struct  SA_DA_IP_ADDRESSES
{
    IP_ADDRESS  source_ip_address;
    IP_ADDRESS  destination_ip_address;
} SA_DA_IP_ADDRESSES;

typedef struct  ICMP_PACKET_DATA
{
    SA_DA_IP_ADDRESSES  addresses;
    USHORT                  ip_checksum;
} ICMP_PACKET_DATA;

typedef struct ICMP_DATA
{
    ICMP_PACKET_DATA        ip_data;
    USHORT                  icmp_checksum;
} ICMP_DATA;

typedef struct  NAT_CUSEEME_PACKET
{
    USHORT      destination_packet_id;
    USHORT      destination_udp_port;
    IP_ADDRESS  destination_ip_address;
    USHORT      source_packet_id;
    USHORT      source_udp_port;
    IP_ADDRESS  source_ip_address;
} NAT_CUSEEME_PACKET;

typedef struct  SEQUENCE_HEADER
{
    struct SEQUENCE_ENTRY   *sptr_forward_link;
    struct SEQUENCE_ENTRY   *sptr_backward_link;
} SEQUENCE_HEADER;

typedef struct  SEQUENCE_ENTRY
{
    SEQUENCE_HEADER         link;
    ULONG                       sequence_number_base;
    int                     sequence_number_delta;
    ULONG                       sequence_number_base_adjust;
    ULONG                       entry_timer;
    BYTE_ENUM (BOOLEAN) timer_enable;
} SEQUENCE_ENTRY;

typedef struct  TCP_TRANSLATION_HEADER
{
    struct TCP_TRANSLATION_ENTRY    *sptr_forward_link;
    struct TCP_TRANSLATION_ENTRY    *sptr_backward_link;
} TCP_TRANSLATION_HEADER;

typedef struct  TCP_TRANSLATION_ENTRY
{
    TCP_TRANSLATION_HEADER                  link;
    USHORT                                  local_tcp_port;
    USHORT                                  global_tcp_port;
    USHORT                                  spoofed_local_tcp_port;
    USHORT                                  unique_spoofed_port;
    IP_ADDRESS                              local_ip_address;
    IP_ADDRESS                              destination_global_ip_address;
    SEQUENCE_HEADER                         local_sequence_delta_list;
    SEQUENCE_HEADER                         global_sequence_delta_list;
    ULONG                                   global_sequence_number;
    ULONG                                   local_sequence_number;
    ULONG                                   local_connection_timer;
    ULONG                                   global_connection_timer;
    BYTE_ENUM (NAT_TCP_PORT_STATE)          local_state;
    BYTE_ENUM (NAT_TCP_PORT_STATE)          global_state;
} TCP_TRANSLATION_ENTRY;

typedef struct  NAT_IP_ADDRESS_ENTRY
{
    IP_ADDRESS              ip_address;
    BYTE_ENUM (BOOLEAN) address_in_use;
} NAT_IP_ADDRESS_ENTRY;

typedef struct  IP_TRANSLATION_HEADER
{
    struct IP_TRANSLATION_ENTRY *sptr_forward_link;
    struct IP_TRANSLATION_ENTRY *sptr_backward_link;
} IP_TRANSLATION_HEADER;


typedef struct  IP_TRANSLATION_ENTRY
{
    IP_TRANSLATION_HEADER       link;
    IP_ADDRESS                      sa_local_ip_address;
    IP_ADDRESS                      sa_global_ip_address;
    ULONG                               time_stamp;
    NAT_IP_ADDRESS_ENTRY            *sptr_local_address_use_entry;  
    TCP_TRANSLATION_HEADER      tcp_translation_list;
    BYTE_ENUM (BOOLEAN)         static_entry;
} IP_TRANSLATION_ENTRY;

typedef struct  UDP_TRANSLATION_HEADER
{
    struct  UDP_TRANSLATION_ENTRY   *sptr_forward_link;
    struct  UDP_TRANSLATION_ENTRY   *sptr_backward_link;
} UDP_TRANSLATION_HEADER;

typedef struct  UDP_TRANSLATION_ENTRY
{
    UDP_TRANSLATION_HEADER  link;
    USHORT                      local_udp_port;
    USHORT                      global_udp_port;
    USHORT                      spoofed_local_udp_port;
    USHORT                      unique_spoofed_port;
    IP_ADDRESS                  local_ip_address;
    IP_ADDRESS                  destination_global_ip_address;
    ULONG                       udp_translation_entry_timer;
} UDP_TRANSLATION_ENTRY;

typedef struct  ICMP_TRANSLATION_HEADER
{
    struct ICMP_TRANSLATION_ENTRY   *sptr_forward_link;
    struct ICMP_TRANSLATION_ENTRY   *sptr_backward_link;
} ICMP_TRANSLATION_HEADER;

typedef struct ICMP_TRANSLATION_ENTRY
{
    ICMP_TRANSLATION_HEADER link;
    USHORT                      icmp_identifier;
    USHORT                      spoofed_icmp_identifier;
    IP_ADDRESS                  local_ip_address;
    ULONG                           icmp_translation_entry_timer;
} ICMP_TRANSLATION_ENTRY;   

typedef struct  PPTP_TRANSLATION_HEADER
{
    struct PPTP_TRANSLATION_ENTRY   *sptr_forward_link;
    struct PPTP_TRANSLATION_ENTRY   *sptr_backward_link;
} PPTP_TRANSLATION_HEADER;

typedef struct PPTP_TRANSLATION_ENTRY
{
    PPTP_TRANSLATION_HEADER     link;
    IP_ADDRESS                  local_ip_address;
    IP_ADDRESS                  peer_ip_address;
    ULONG                       pptp_translation_entry_timer;
    USHORT                      call_id;
    USHORT                      spoofed_call_id;
    USHORT                      peer_call_id;
} PPTP_TRANSLATION_ENTRY;   


typedef struct  ESP_TRANSLATION_HEADER
{
    struct ESP_TRANSLATION_ENTRY    *sptr_forward_link;
    struct ESP_TRANSLATION_ENTRY    *sptr_backward_link;
} ESP_TRANSLATION_HEADER;

typedef struct ESP_TRANSLATION_ENTRY
{
    ESP_TRANSLATION_HEADER  link;
    IP_ADDRESS              local_ip_address;
    IP_ADDRESS              peer_ip_address;
    ULONG                   outgoing_spi;
    ULONG                   incoming_spi;
    ULONG                   esp_timer;
    int                     blocking;
    int                     outgoing_count;
    int                     squelched;
} ESP_TRANSLATION_ENTRY;


typedef struct  ISAKMP_TRANSLATION_HEADER
{
    struct ISAKMP_TRANSLATION_ENTRY    *sptr_forward_link;
    struct ISAKMP_TRANSLATION_ENTRY    *sptr_backward_link;
} ISAKMP_TRANSLATION_HEADER;

typedef struct ISAKMP_TRANSLATION_ENTRY
{
    ISAKMP_TRANSLATION_HEADER   link;
    IP_ADDRESS              local_ip_address;
    IP_ADDRESS              peer_ip_address;
    ULONG                   isakmp_timer;
    unsigned long long      icookie;        /* initiator cookie */
    unsigned long long      rcookie;        /* responder cookie */
} ISAKMP_TRANSLATION_ENTRY;


typedef struct NAT_FRAGMENT_INFO
{
    IP_ADDRESS                  address_to_change;
    IP_ADDRESS                  modified_ip_adderss;
    USHORT                      identifier;
    UINT                        time_to_live;
} NAT_FRAGMENT_INFO;

typedef struct  NAT_IP_PORT_CLASS
{
    BYTE_ENUM (BOOLEAN)         enable;
    BYTE_ENUM (BOOLEAN)         default_translate_enable;
    BYTE_ENUM (NAT_PORT_TYPE)   type;
    IP_ADDRESS                      ip_address;
    IP_ADDRESS                      mask;
    char                                type_string[20];    /*this shouldn't be necessary - used only for nvram config */
    RW_CONTAINER                    *p_fragment_agent;
    RW_CONTAINER_ITERATOR       fragment_info_iterator;
#if defined (__VXWORKS_SENS_SUPPORT__)
    NAT_VXWORKS_MUX_BIND_PARAMETERS         vxw_parameters;
#endif /* __VXWORKS_SENS_SUPPORT__ */
} NAT_IP_PORT_CLASS;

typedef struct NAT_IP_STATIC_ENTRY
{
    IP_ADDRESS      local_ip_address;
    IP_ADDRESS      global_ip_address;
} NAT_IP_STATIC_ENTRY;

typedef struct NAT_PORT_STATIC_ENTRY
{
    USHORT      server_port_number_from;
    USHORT      server_port_number_to;
    USHORT      mapped_server_port_number_from;
    IP_ADDRESS  local_ip_address;
} NAT_PORT_STATIC_ENTRY;

/* the following contains all members necessary for RFC NAT */
typedef struct NATG_CLASS
{
    IP_TRANSLATION_HEADER               ip_translation_list;
    NAT_IP_ADDRESS_ENTRY                    local_address_use_table[NUMBER_OF_IP_PORTS][SIZEOF_CLASS_C_ADDRESS_RANGE];
} NATG_CLASS;

/* the following contains all members necessary for single address NAT */
typedef struct NATS_CLASS
{
    TCP_TRANSLATION_HEADER          tcp_translation_list;
    UDP_TRANSLATION_HEADER          udp_translation_list;
    ICMP_TRANSLATION_HEADER         icmp_translation_list;
    ICMP_TRANSLATION_ENTRY          icmp_default_entry;
    PPTP_TRANSLATION_HEADER         pptp_translation_list;
    ESP_TRANSLATION_HEADER          esp_translation_list;
    ISAKMP_TRANSLATION_HEADER       isakmp_translation_list;
} NATS_CLASS;

typedef struct NAT_DIAL_ON_DEMAND
{
    enum BOOLEAN                        port_being_opened;
    enum BOOLEAN                        inactivity_timeout_enabled;
    UINT                                    port_deactivation_timeout_value;
    UINT                                    port_deactivation_timer;
    RW_CONTAINER                        *p_tx_queue;
    NAT_IP_PORT_CLASS                   *p_global_port;
    USHORT                              global_port_number;
    enum IP_SEND_CONFIRMATION       (*fptr_ip_determine_next_hop_and_send_packet) (IP_PARAMETERS *sptr_ip_parameters,
                                                UNION_IP_PACKET *sptr_ip_packet,
                                                USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *p_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
                                                enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
                                                void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet), ULONG type_of_service,
                                                IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
} NAT_DIAL_ON_DEMAND;

typedef struct NAT_DO_NOT_TRANSLATE_PAIRS
{
    IP_ADDRESS                          ip_address;
    IP_ADDRESS                          mask;
    enum BOOLEAN                        compare_source_ip_address;
} NAT_DO_NOT_TRANSLATE_PAIR;

typedef struct  NAT_CLASS
{
    ULONG                                   application_id;

    struct NAT_TCP_STATE_TABLE      *tcp_state_table;

    ULONG                                   tick_count;
    ULONG                                   clock_ticks_per_second;
    ULONG                                   ip_translation_entry_timer;
    ULONG                                   udp_translation_entry_timer;
    ULONG                                   icmp_translation_entry_timer;
    ULONG                                   pptp_translation_entry_timer;
    ULONG                                   tcp_connecting_timer;
    ULONG                                   tcp_disconnected_timer;
    ULONG                                   tcp_connected_timer;
    ULONG                                   tcp_closing_timer;
    ULONG                                   sequence_entry_timer;                                   
    USHORT                              current_port_spoofing_number;

    NAT_IP_PORT_CLASS                   port[NUMBER_OF_IP_PORTS];
    IP_ADDRESS                          local_class_a_address[NUMBER_OF_CORPORATE_NETWORK_ADDRESSES];
    IP_ADDRESS                          local_class_a_address_mask[NUMBER_OF_CORPORATE_NETWORK_ADDRESSES];
    enum BOOLEAN                        filter_non_corporate_addresses;

    enum BOOLEAN                        static_entries_enabled;
    NAT_IP_STATIC_ENTRY             static_entries[MAXIMUM_NUMBER_OF_STATIC_ENTRIES];
    NAT_PORT_STATIC_ENTRY           tcp_static_entries[TOTAL_NUMBER_OF_TCP_STATIC_ENTRIES];
    NAT_PORT_STATIC_ENTRY           udp_static_entries[TOTAL_NUMBER_OF_UDP_STATIC_ENTRIES];
    IP_ADDRESS                      dmz_ip_address;
    

    NATG_CLASS                          natg;
    NATS_CLASS                          nats;

    enum BOOLEAN                        enabled;
    enum BOOLEAN                        single_global_address_enabled;
    enum BOOLEAN                        set_default_values;
    enum BOOLEAN                        cuseeme_handling_enabled;

    IP_ADDRESS                          global_ip_address;
    IP_ADDRESS                          global_ip_address_mask;
    ULONG                               global_max_packet_size;
    enum BOOLEAN                        global_is_ppp;
    ULONG                               tcp_max_segment_size;

    NAT_DIAL_ON_DEMAND              dial_on_demand;

    RW_CONTAINER                        *p_do_not_translate_list[NUMBER_OF_IP_PORTS];

    ULONG                                   ip_stack_id;
    
    /* List of identifiers in ICMP echo reply packets that require no translation */
    int                                 icmp_ident_no_translate_num;
    USHORT                              icmp_ident_no_translate[NUMBER_OF_ICMP_IDENT_NO_TRANSLATE];

    /* List of TCP ports that require no translation */
    int                                 tcp_port_no_translate_num;
    struct {
            USHORT port;
            USHORT is_source;
           }                            tcp_port_no_translate[NUMBER_OF_TCP_PORT_NO_TRANSLATE];

    /* List of UDP ports that require no translation */
    int                                 udp_port_no_translate_num;
    struct {
            USHORT port;
            USHORT is_source;
           }                            udp_port_no_translate[NUMBER_OF_UDP_PORT_NO_TRANSLATE];

    enum BOOLEAN                        printing_enabled;
    enum BOOLEAN                        initialization_printing_enabled;
    enum BOOLEAN                        trace_printing_enabled;
    enum BOOLEAN                        data_printing_enabled;
    enum BOOLEAN                        error_printing_enabled;
    
#if defined (__NAT_BREAKPOINT__)
    enum BOOLEAN                        initialization_breakpoint;
    enum BOOLEAN                        shutdown_breakpoint;
    enum BOOLEAN                        configuration_breakpoint;
    enum BOOLEAN                        runtime_breakpoint;
#endif
#if defined (__VXWORKS_SENS_SUPPORT__)
    UINT                                    number_of_ports;
    BOOL                                    initialized;
    BOOL                                    processing_timer;
#endif /* __VXWORKS_SENS_SUPPORT__ */
} NAT_CLASS;

/* nat_control.c */
enum TEST nat_application_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
void terminate_nat (void);
void delete_tcp_connection_entry_list (TCP_TRANSLATION_HEADER *sptr_tcp_translation_list);
void delete_sequence_entry_list (SEQUENCE_HEADER *sptr_sequence_list);

/* nat_timer.c */
void nat_timer (void);

/* nat_debug.c */
void check_for_nat_initialization_breakpoint (void);
void check_for_nat_shutdown_breakpoint (void);
void check_for_nat_configuration_breakpoint (void);
void check_for_nat_runtime_breakpoint (void);

/* nat_initialize.c */
void nat_printf (enum NAT_PRINTF_GROUPS printf_group, const char *cptr_format, ...);
enum TEST nat_setup_static_entries (NAT_IP_STATIC_ENTRY *sptr_static_entry, 
    NAT_IP_ADDRESS_ENTRY* sptr_address_entry, IP_TRANSLATION_HEADER *sptr_ip_translation_list);

/* nat_configure.c */
ULONG nat_get_configuration_table_address (void);
ULONG nat_special_configuration_function_processing (ULONG parameter[]);

/* nat_tcp_state.c */
void tcp_state_transistion_global_rx (BYTE_ENUM (NAT_TCP_STATE_INPUT) state_input,
    TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
void tcp_state_transistion_local_rx (BYTE_ENUM (NAT_TCP_STATE_INPUT) state_input,
    TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
void tcp_syn_state_handler (BYTE_ENUM (NAT_TCP_STATE_INPUT) state_input,
        BYTE_ENUM (NAT_TCP_PORT_STATE) current_state, BYTE_ENUM (NAT_PACKET_DIRECTION) packet_direction,
        TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
void tcp_reset_state_handler (BYTE_ENUM (NAT_TCP_STATE_INPUT) state_input,
        BYTE_ENUM (NAT_TCP_PORT_STATE) current_state, BYTE_ENUM (NAT_PACKET_DIRECTION) packet_direction,
        TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);


/* nat_rx.c */
enum TEST nat_rx (USHORT port_number, IP_PACKET *sptr_ip_packet);
void nat_check_for_queued_packets_to_tx_on_global_port (void);

/* nat_tx.c */
enum TEST nat_tx (USHORT port_number, IP_PACKET *sptr_ip_packet);

/* nat_udp.c */
enum TEST handle_udp_translation_global_rx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_udp_translation_global_rx_natg (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_udp_translation_local_rx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_udp_translation_global_tx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_udp_translation_local_tx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_udp_translation_local_rx_nats (UDP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_udp_translation_local_rx_static (UDP_PACKET *sptr_udp_packet, USHORT port_number);
UDP_TRANSLATION_ENTRY *new_udp_translation_entry (UDP_PACKET *sptr_tcp_packet,
    UDP_TRANSLATION_HEADER *sptr_udp_translation_list, USHORT local_port, USHORT global_port);

/* nat_filter.c */
enum NAT_FILTER nat_filter_tx (IP_PACKET *sptr_ip_packet, USHORT port_number, enum NAT_PORT_TYPE nat_port_type);
enum NAT_FILTER nat_filter_rx (IP_PACKET *sptr_ip_packet, USHORT port_number, enum NAT_PORT_TYPE nat_port_type);

/* nat_tcp.c */
enum TEST handle_tcp_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_tcp_translation_local_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_tcp_translation_local_tx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_tcp_translation_global_tx_natg (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_tcp_translation_local_rx_nats (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_tcp_translation_global_tx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
void tcp_sequence_number_fixup_global_rx (TCP_HEADER *sptr_tcp_header, 
    TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
void tcp_sequence_number_fixup_local_rx (TCP_HEADER *sptr_tcp_header, 
        TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
TCP_TRANSLATION_ENTRY *new_tcp_translation_entry (TCP_PACKET *sptr_tcp_packet,
    TCP_TRANSLATION_HEADER *sptr_tcp_translation_list, USHORT local_port, USHORT global_port, IP_ADDRESS destination_global_ip_address);
enum TEST handle_tcp_translation_local_rx_static (TCP_PACKET *sptr_tcp_packet, USHORT port_number);


/* nat_util.c */
enum NAT_PORT_TYPE get_nat_port_type (USHORT port_number);
ULONG_ENUM (NAT_PACKET_TYPES) nat_packet_discriminator (IP_PACKET *sptr_ip_packet);
IP_TRANSLATION_ENTRY *match_sa_with_global_ip_address (IP_ADDRESS global_ip_address, IP_TRANSLATION_HEADER *sptr_ip_translation_list);
IP_TRANSLATION_ENTRY *match_sa_with_local_ip_address (IP_ADDRESS source_ip_address, IP_TRANSLATION_HEADER *sptr_ip_translation_list);
TCP_TRANSLATION_ENTRY *match_ports_with_tcp_entry (USHORT global_tcp_port, USHORT local_tcp_port, IP_ADDRESS destination_global_ip_address, TCP_TRANSLATION_HEADER *sptr_tcp_translation_list);
TCP_TRANSLATION_ENTRY *match_sa_ports_with_tcp_entry (USHORT global_tcp_port, USHORT local_tcp_port, IP_ADDRESS destination_global_ip_address, IP_ADDRESS source_ip_address, TCP_TRANSLATION_HEADER *sptr_tcp_translation_list);
TCP_TRANSLATION_ENTRY *match_spoofed_port_with_tcp_entry (USHORT spoofed_tcp_port, TCP_TRANSLATION_HEADER *sptr_tcp_translation_list);
UDP_TRANSLATION_ENTRY *match_ports_with_udp_entry (USHORT global_tcp_port, USHORT local_tcp_port, IP_ADDRESS destination_global_ip_address, UDP_TRANSLATION_HEADER *sptr_udp_translation_list);
UDP_TRANSLATION_ENTRY *match_sa_ports_with_udp_entry (USHORT global_udp_port, USHORT local_udp_port, IP_ADDRESS destination_ip_address, IP_ADDRESS source_ip_address, UDP_TRANSLATION_HEADER *sptr_udp_translation_list);
UDP_TRANSLATION_ENTRY *match_spoofed_port_with_udp_entry (USHORT spoofed_udp_port, UDP_TRANSLATION_HEADER *sptr_udp_translation_list);
ICMP_TRANSLATION_ENTRY *match_identifier_with_icmp_entry (USHORT spoofed_icmp_port, ICMP_TRANSLATION_HEADER *sptr_icmp_translation_list);
ICMP_TRANSLATION_ENTRY *match_spoofed_identifier_with_icmp_entry (USHORT spoofed_icmp_identifier, ICMP_TRANSLATION_HEADER *sptr_icmp_translation_list);
IP_TRANSLATION_ENTRY *new_ip_translation_entry (IP_ADDRESS source_ip_address, IP_TRANSLATION_HEADER *sptr_ip_translation_list, USHORT port_number);
void checksum_fixup (BYTE *bptr_checksum, BYTE *bptr_old_data,
        USHORT old_data_length, BYTE *bptr_new_data, USHORT new_data_length);
enum TEST increment_nat_port_spoofing_number (USHORT *usptr_spoofing_number);
IP_TRANSLATION_ENTRY *allocate_and_initialize_ip_translation_entry (NAT_IP_ADDRESS_ENTRY *sptr_address_entry,
        IP_ADDRESS local_ip_address, IP_ADDRESS global_ip_address,
        BYTE_ENUM (BOOLEAN) static_entry);
NAT_PORT_STATIC_ENTRY *match_tcp_port_with_static_entry (USHORT port_number);
NAT_PORT_STATIC_ENTRY *match_udp_port_with_static_entry (USHORT port_number);
void nat_tx_queued_packet_completion (USHORT port_number, IP_PACKET *p_packet);
void checksum_tcp (TCP_PACKET *sptr_tcp_packet);
void checksum_udp (UDP_PACKET *sptr_udp_packet);
USHORT get_static_entry_mapped_port (NAT_PORT_STATIC_ENTRY *sptr_port_static_entry, USHORT server_port);
USHORT get_static_entry_server_port (NAT_PORT_STATIC_ENTRY *sptr_port_static_entry, USHORT mapped_server_port);
NAT_PORT_STATIC_ENTRY *match_sa_udp_port_with_static_entry (USHORT port_number);

/* nat_icmp_datagram.c */
enum TEST handle_icmp_translation_global_rx_datagram (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_local_rx_datagram (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_global_tx_datagram (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_local_tx_datagram (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);

/* nat_icmp_transaction.c */
enum TEST handle_icmp_translation_global_rx_transaction (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_local_rx_transaction (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_global_tx_transaction (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);
enum TEST handle_icmp_translation_local_tx_transaction (ICMP_PACKET *sptr_icmp_packet, USHORT port_number);

/* nat_ftp.c */
enum TEST handle_ftp_translation_local_tx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_ftp_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_ftp_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_ftp_translation_global_tx (TCP_PACKET *sptr_ip_packet, USHORT port_number);

/* nat_irc.c */
enum TEST handle_irc_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_irc_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);

/* nat_icq.c */
enum TEST handle_icq_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_icq_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
#ifndef NO_ICQ2001B  /* ICQ2001b support */
int packet_is_icq_direct (TCP_PACKET *sptr_tcp_packet);
enum TEST handle_icq_direct_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_icq_direct_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
#endif

/* nat_pptp.c */
enum TEST handle_pptp_translation_global_rx (PPTP_TCP_PACKET *sptr_pptp_packet, USHORT port_number);
enum TEST handle_pptp_translation_local_rx (PPTP_TCP_PACKET *sptr_pptp_packet, USHORT port_number);
enum TEST handle_gre_translation_global_rx (PPTP_GRE_PACKET *sptr_pptp_packet, USHORT port_number);
enum TEST handle_gre_translation_local_rx (PPTP_GRE_PACKET *sptr_pptp_packet, USHORT port_number);

/* nat_ipsec.c */
enum TEST handle_esp_translation_global_rx (ESP_PACKET *sptr_esp_packet, USHORT port_number);
enum TEST handle_esp_translation_local_rx (ESP_PACKET *sptr_esp_packet, USHORT port_number);
enum TEST handle_isakmp_translation_global_rx (ISAKMP_PACKET *sptr_isakmp_packet, USHORT port_number);
enum TEST handle_isakmp_translation_local_rx (ISAKMP_PACKET *sptr_isakmp_packet, USHORT port_number);

/* nat_net2phone.c */
int packet_is_net2phone_control_tcp (TCP_PACKET *sptr_tcp_packet);
int packet_is_net2phone_control_udp (UDP_PACKET *sptr_udp_packet);
enum TEST handle_net2phone_translation_local_rx_tcp (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_net2phone_translation_global_rx_tcp(TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_net2phone_translation_local_rx_udp (UDP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_net2phone_translation_global_rx_udp(UDP_PACKET *sptr_tcp_packet, USHORT port_number);

/* nat_netmeeting.c */
int packet_is_h323_control (TCP_PACKET *sptr_tcp_packet);
int nat_netmeeting_check_h323_control (TCP_TRANSLATION_ENTRY *sptr_tcp_translation_entry);
enum TEST handle_rsvp_translation_global_rx (IP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_rsvp_translation_local_rx (IP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_h323setup_translation_global_rx (TCP_PACKET *sptr_tcp_packet, USHORT port_number);
enum TEST handle_h323setup_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_h323control_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_ldap_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);
enum TEST handle_msnp_translation_local_rx (TCP_PACKET *sptr_ip_packet, USHORT port_number);


/* nat_ip.c */
IP_TRANSLATION_ENTRY *handle_ip_translation_global_rx (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_local_rx (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_global_tx (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_local_tx (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_global_tx_natg (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_global_rx_natg (IP_PACKET *sptr_ip_packet, USHORT port_number);
IP_TRANSLATION_ENTRY *handle_ip_translation_local_rx_static (IP_PACKET *sptr_ip_packet, USHORT port_number);

/* nat_cuseeme.c */
enum TEST handle_cuseeme_translation_local_rx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_cuseeme_translation_local_tx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_cuseeme_translation_global_rx (UDP_PACKET *sptr_udp_packet, USHORT port_number);
enum TEST handle_cuseeme_translation_global_tx (UDP_PACKET *sptr_udp_packet, USHORT port_number);

/* nat_ip_interface.c */
enum TEST ip_nat_tx (UNION_IP_PACKET *uptr_ip_packet, USHORT tx_port_number, enum SNAP_PROTOCOL_ID protocol_type, USHORT *number_of_bytes);
enum TEST ip_nat_rx (UNION_IP_PACKET *uptr_ip_packet, USHORT rx_port_number, enum SNAP_PROTOCOL_ID protocol_type, USHORT *size_of_packet);
void nat_get_global_port_ip_address_mask (USHORT port_number, ULONG address, ULONG mask);
enum TEST nat_tx_queued_packet (IP_PACKET *p_packet);

/* nat_fragment.c */

NAT_FRAGMENT_INFO *nat_add_entry_in_fragmentation_agent (USHORT port_number, IP_PACKET *sptr_ip_packet);
enum TEST nat_handle_translation_for_fragment (USHORT port_number, IP_PACKET *sptr_ip_packet);

/* nat_local_port_forward.c */
enum TEST handle_local_port_forwarding(IP_PACKET *sptr_ip_packet);

