/*
 * $Log: rwarebuf.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:44  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:16:07  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:51:34  TTY
 * Initial revision
 *
 * 
 * 7     10/13/98 12:07p Alex
 * Add the __EXPORT_APIS__ preprocessor definition for exporting functions.
 * 
 * Add the __WINROUTER_VPRINTF__ preprocessor definition to redirecting output to the WinRouter.
 * 
 * 6     5/20/98 9:53a Alex
 * 
 * 5     4/30/98 1:16p Rajive
 * Overwrote with INCLUDE v4.2.1
 * 
 * 3     4/27/98 11:42a Release Engineer
 * Additions into include for L2TP and RTM modules.
 * INCLUDE v4.2.1
 * 
 * code cleanup, code style changes, linted, system level test
 * INCLUDE v4.2.0
 * 
 * 4     4/11/96 6:45p Ross
 * critical section removed for MSC version.
 * 
 * 3     3/27/96 7:08p Ross
 * Initial check-in with source safe.
*/

/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc										*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca  	*/
/************************************************************************/

/* These are memory allocation, printing, and any other target, CPU, or 
   compiler specific variances and enhancements and redirections */

#if !defined (_RWAREBUF_H_)
#define _RWAREBUF_H_		

#define buffer_malloc malloc
#define buffer_free free

#define table_malloc calloc
#define table_free free

#define message_malloc malloc
#define message_free free

#define vprintf vprintf

/*********************************************************************************************/
/* RouterWare directives                                                                     */
/*********************************************************************************************/
 
#if defined (__WINROUTER__) 

	#define ENTER_CRITICAL_SECTION
	#define LEAVE_CRITICAL_SECTION
	
	#define BREAKPOINT _asm int 3

#if defined (__EXPORT_APIS__)
	#include "dll_impr.h"  
#endif

#else
   /*********************************************************************************************/
/* OEM directives                                                                            */
/*********************************************************************************************/
	
	#define ENTER_CRITICAL_SECTION
	#define LEAVE_CRITICAL_SECTION

	#define BREAKPOINT ;

#endif 

/*********************************************************************************************/
/* Global Printf function                                                                    */
/*********************************************************************************************/
#if defined (__WINROUTER_VPRINTF__)

#undef vprintf

#define vprintf(format,argptr) lsl_control (VPRINTF,format,argptr)

#endif

/*********************************************************************************************/
/* Global Timers                                                                              */
/*********************************************************************************************/
#define bridge_timer lsl_control (GET_BRIDGE_TIMER)
#define router_timer lsl_control (GET_ROUTER_TIMER)
#define timer_ulong lsl_control (GET_SYSTEM_TIMER)


/* Reset packing pragmas and/or MACROs that were set in KSTART.H */
#define _struct struct 
#define _union union
#define	_enum  enum		
#define _pack __attribute__((__packed__))


#endif /* RWAREBUF.H*/

 