/*
 * $Log: Vnvram.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:46  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:13:44  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:51:14  TTY
 * Initial revision
 *
 * 
 * 15    1/15/99 3:01p Nishit
 * Support for BOOTP Client and Relay Agent
 * 
 * 14    12/22/98 9:45a Nishit
 * POET changed to PPPOE_AC
 * 
 * 13    12/07/98 11:37a Release Engineer
 * 
 * 1     12/04/98 2:43p Release Engineer
 * code cleanup, bug fixes, code style changes, linted, system level test
 * NVRAM v4.3.0
*/


/*	$Modname: vnvram.h$  $version: 1.14$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 03/09/94 ross new release.
1.1 03/09/94 ross added copyright.
1.2 06/15/94 ross
1.3 06/20/94 ross added snmp configuration table
1.4 08/18/94 ross added vj,tcp, cipx tables.
1.5 09/29/94 ross added sockets.
1.6 11/21/94 ross added consoles.
1.7 12/11/94 ross added sca and odi.
1.8 01/12/95 ross added netbios gateway.
1.9 01/26/95 ross changes for rwutils
1.10 02/01/95 ross dynamic configuration
1.11 02/27/95 ross dynamic load changes including lsl_control.
1.12 04/20/95 ross added ram file parsing addition
1.13 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
1.14 10/25/95 ross dynamic load changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1998 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/

GLOBAL NVRAM_CLASS nvram;

#if defined (__APPLETALK__)
	extern CONFIGURATION_TABLE appletalk_configuration_table;
#endif
#if defined (__ASYNC__)
	extern CONFIGURATION_TABLE async_configuration_table;
#endif
#if defined (__BACP__)
	extern CONFIGURATION_TABLE bacp_configuration_table;
#endif
#if defined (__BGP__)
	extern CONFIGURATION_TABLE bgp_configuration_table;
#endif
#if defined (__BOOTP_CLIENT__)
	extern CONFIGURATION_TABLE bootp_configuration_table;
#endif
#if defined (__BOOTP_RELAY_AGENT__)
	extern CONFIGURATION_TABLE bootpra_configuration_table;
#endif
#if defined (__CCP__)
	extern CONFIGURATION_TABLE ccp_configuration_table;
#endif
#if defined (__CIPX__)
	extern CONFIGURATION_TABLE cipx_configuration_table;
#endif
#if defined (__CONSOLE_DRIVER__)
	extern CONFIGURATION_TABLE console_driver_configuration_table;
#endif
#if defined (__DHCP_CLIENT__)
	extern CONFIGURATION_TABLE dhcp_client_configuration_table;
#endif
#if defined (__DHCP_SERVER__)
	extern CONFIGURATION_TABLE dhcp_server_configuration_table;
#endif
#if defined (__DLSW__)
	extern CONFIGURATION_TABLE dlsw_configuration_table;
#endif
#if defined (__FAST_PATH_IP_ADDITIONS__)
	extern CONFIGURATION_TABLE fast_path_ip_configuration_table;
#endif
#if defined (__FRAME_RELAY__)
	extern CONFIGURATION_TABLE frame_relay_configuration_table;
#endif
#if defined (__INTERNAL_NETWORK__)
	extern CONFIGURATION_TABLE inet_configuration_table;
#endif
#if defined (__IP__)
	extern CONFIGURATION_TABLE ip_configuration_table;
#endif
#if defined (__IPX__)
	extern CONFIGURATION_TABLE ipx_configuration_table;
#endif
#if defined (__LAC__)
	extern CONFIGURATION_TABLE l2tp_ppp_configuration_table;
	extern CONFIGURATION_TABLE l2tp_configuration_table;
	extern CONFIGURATION_TABLE l2tp_transport_configuration_table;
#endif
#if defined (__LNS__)
	extern CONFIGURATION_TABLE lns_sdd_configuration_table;
	extern CONFIGURATION_TABLE l2tp_configuration_table;
	extern CONFIGURATION_TABLE l2tp_transport_configuration_table;
#endif
#if defined (__LSL__)
	extern CONFIGURATION_TABLE lsl_configuration_table;
#endif
#if defined (__MP__)
	extern CONFIGURATION_TABLE mp_configuration_table;
#endif
#if defined (__NAT__)
	extern CONFIGURATION_TABLE nat_configuration_table;
#endif
#if defined (__NBGW__)
	extern CONFIGURATION_TABLE netbios_gateway_configuration_table;
#endif
#if defined (__NDIS_DRIVER__)
	extern CONFIGURATION_TABLE ndis_configuration_table;
#endif
#if defined (__NLSP__)
	extern CONFIGURATION_TABLE nlsp_configuration_table;
#endif
#if defined (__ODI__)
	extern CONFIGURATION_TABLE odi_configuration_table;
#endif
#if defined (__OSPF__)
	extern CONFIGURATION_TABLE ospf_configuration_table;
#endif
#if defined (__PPP__)
	extern CONFIGURATION_TABLE ppp_configuration_table;
#endif
#if defined (__PPPoE__)
	extern CONFIGURATION_TABLE pppoe_ac_configuration_table;
#endif
#if defined (__PPP_TUNNEL_ENDPOINT__)
	extern CONFIGURATION_TABLE ppp_tunnel_ep_configuration_table;
#endif
#if defined (__RADIUS_CLIENT__)
	extern CONFIGURATION_TABLE radius_configuration_table;
#endif
#if defined (__RCONSOLE__)
	extern CONFIGURATION_TABLE remote_console_configuration_table;
#endif
#if defined (__RTM__)
	extern CONFIGURATION_TABLE rtm_configuration_table;
#endif
#if defined (__SCA__)
	extern CONFIGURATION_TABLE sca_configuration_table;
#endif
#if defined (__SCONSOLE__)
	extern CONFIGURATION_TABLE server_console_configuration_table;
#endif
#if defined (__SNMP_AGENT__)
	extern CONFIGURATION_TABLE snmp_configuration_table;
#endif
#if defined (__SOCKET__)
	extern CONFIGURATION_TABLE socket_configuration_table;
#endif
#if defined (__SPX__)
	extern CONFIGURATION_TABLE spx_configuration_table;
#endif
#if defined (__SRB__)
	extern CONFIGURATION_TABLE source_routing_configuration_table;
#endif
#if defined (__STP__)
	extern CONFIGURATION_TABLE stp_configuration_table;
#endif
#if defined (__TCP__)
	extern CONFIGURATION_TABLE tcp_configuration_table;
#endif
#if defined (__TELNET__)
	extern CONFIGURATION_TABLE telnet_configuration_table;
#endif
#if defined (__TFTP__)
	extern CONFIGURATION_TABLE tftp_configuration_table;
#endif
#if defined (__TR__)
	extern CONFIGURATION_TABLE token_mac_configuration_table;
#endif
#if defined (__VJC__)
	extern CONFIGURATION_TABLE vjc_configuration_table;
#endif

/* NVRAM File Section Header Phrases */

	char *section_name_array[] =
		{
		#if defined (__APPLETALK__)
			"AppleTalk Routing",
		#endif
		#if defined (__ASYNC__)
			"ASYNC Serial Device Driver",
		#endif
		#if defined (__BACP__)
			"BACP Device Driver",
		#endif
		#if defined (__BGP__)
			"BGP Routing",
		#endif
		#if defined (__BOOTP_CLIENT__)
			"BOOTP Client",
		#endif
		#if defined (__BOOTP_RELAY_AGENT__)
			"BOOTP Relay Agent",
		#endif
		#if defined (__CCP__)
			"CCP Compression",
		#endif
		#if defined (__CIPX__)
			"CIPX Compression",
		#endif
		#if defined (__CONSOLE_DRIVER__)
			"Console Driver",
		#endif
		#if defined (__DHCP_CLIENT__)
			"DHCP Client",
		#endif
		#if defined (__DHCP_SERVER__)
			"DHCP Server",
		#endif
		#if defined (__DLSW__)
			"DLSW Routing",
		#endif
		#if defined (__FAST_PATH_IP_ADDITIONS__)
			"Fast_Path_IP Module",
		#endif
		#if defined (__FRAME_RELAY__)
			"Frame Relay Device Driver",
		#endif
		#if defined (__INTERNAL_NETWORK__)
			"InternalNet Device Driver",
		#endif
		#if defined (__IP__)
			"IP Routing",
		#endif
		#if defined (__IPX__)
			"IPX Routing",
		#endif
		#if defined (__LAC__)
			"L2TP_PPP Data Tunnel",
			"L2TP_CORE Application",
			"L2TP_TRANSPORT Application",
		#endif
		#if defined (__LNS__)
			"LNS_SERIAL_DRIVER Application",
			"L2TP_CORE Application",
			"L2TP_TRANSPORT Application",
		#endif
		#if defined (__LSL__)
			"LSL Multiplex Layer",
		#endif
		#if defined (__MP__)
			"MP Device Driver",
		#endif
		#if defined (__NAT__)
			"NAT Application",
		#endif
		#if defined (__NBGW__)
			"NetBIOS Gateway",
		#endif
		#if defined (__NDIS_DRIVER__)
			"NDIS Device Driver",
		#endif
		#if defined (__NLSP__)
			"NLSP Routing",
		#endif
		#if defined (__ODI__)
			"ODI Driver",
		#endif
		#if defined (__OSPF__)
			"OSPF Routing",
		#endif
		#if defined (__PPP__)
			"PPP Device Driver",
		#endif
		#if defined (__PPPoE__)
			"PPPOE_AC Virtual Protocol Stack",
		#endif
		#if defined (__PPP_TUNNEL_ENDPOINT__)
			"PPP_Tunnel_Endpoint Virtual Protocol Stack",
		#endif
		#if defined (__RADIUS_CLIENT__)
			"RADIUS_CLIENT Application",
		#endif
		#if defined (__RCONSOLE__)
			"Remote Console",
		#endif 
		#if defined (__RTM__)
			"RTM Routing",
		#endif
		#if defined (__SCA__)
			"SCA Driver",
		#endif
		#if defined (__SCONSOLE__)
			"Server Console",
		#endif
		#if defined (__SNMP_AGENT__)
			"SNMP Management",
		#endif
		#if defined (__SOCKET__)
			"SOCKET Interface",
		#endif
		#if defined (__SPX__)
			"SPX Transport",
		#endif
		#if defined (__SRB__)
			"Source Routing",
		#endif
		#if defined (__STP__)
			"Spanning Tree",
		#endif
		#if defined (__TCP__)
			"TCP Transport",
		#endif
		#if defined (__TELNET__)
			"TELNET Server",
		#endif
		#if defined (__TFTP__)
			"TFTP",
		#endif
		#if defined (__TR__)
			"Token MAC",
		#endif
		#if defined (__VJC__)
			"VJC Compression",
		#endif
	      ""
   };

/* Master NVRAM configuration table which is composed of */
/* concatenated tables, one from each module to be used */

	CONFIGURATION_TABLE *sptr_configuration_table[] =
	   {
		#if defined (__APPLETALK__)
			&appletalk_configuration_table,
		#endif
		#if defined (__ASYNC__)
			&async_configuration_table,
		#endif
		#if defined (__BACP__)
			&bacp_configuration_table,
		#endif
		#if defined (__BGP__)
			&bgp_configuration_table,
		#endif
		#if defined (__BOOTP_CLIENT__)
			&bootp_configuration_table,
		#endif
		#if defined (__BOOTP_RELAY_AGENT__)
			&bootpra_configuration_table,
		#endif
		#if defined (__CCP__)
			&ccp_configuration_table,
		#endif
		#if defined (__CIPX__)
			&cipx_configuration_table,
		#endif
		#if defined (__CONSOLE_DRIVER__)
			&console_driver_configuration_table,
		#endif
		#if defined (__DHCP_CLIENT__)
			&dhcp_client_configuration_table,
		#endif
		#if defined (__DHCP_SERVER__)
			&dhcp_server_configuration_table,
		#endif
		#if defined (__DLSW__)
			&dlsw_configuration_table,
		#endif
		#if defined (__FAST_PATH_IP_ADDITIONS__)
			&fast_path_ip_configuration_table,
		#endif
		#if defined (__FRAME_RELAY__)
			&frame_relay_configuration_table,
		#endif
		#if defined (__INTERNAL_NETWORK__)
			&inet_configuration_table,
		#endif
		#if defined (__IP__)
			&ip_configuration_table,
		#endif
		#if defined (__IPX__)
			&ipx_configuration_table,
		#endif
		#if defined (__LAC__)
			&l2tp_ppp_configuration_table,
			&l2tp_configuration_table,
			&l2tp_transport_configuration_table,
		#endif
		#if defined (__LNS__)
			&lns_sdd_configuration_table,
			&l2tp_configuration_table,
			&l2tp_transport_configuration_table,
		#endif
		#if defined (__LSL__)
			&lsl_configuration_table,
		#endif
		#if defined (__MP__)
			&mp_configuration_table,
		#endif
		#if defined (__NAT__)
			&nat_configuration_table,
		#endif
		#if defined (__NBGW__)
			&netbios_gateway_configuration_table,
		#endif
		#if defined (__NDIS_DRIVER__)
			&ndis_configuration_table,
		#endif
		#if defined (__NLSP__)
			&nlsp_configuration_table,
		#endif
		#if defined (__ODI__)
			&odi_configuration_table,
		#endif
		#if defined (__OSPF__)
			&ospf_configuration_table,
		#endif
		#if defined (__PPP__)
			&ppp_configuration_table,
		#endif
		#if defined (__PPPoE__)
			&pppoe_ac_configuration_table,
		#endif
		#if defined (__PPP_TUNNEL_ENDPOINT__)
			&ppp_tunnel_ep_configuration_table,
		#endif
		#if defined (__RADIUS_CLIENT__)
			&radius_configuration_table,
		#endif
		#if defined (__RCONSOLE__)
			&remote_console_configuration_table,
		#endif
		#if defined (__RTM__)
			&rtm_configuration_table,
		#endif
		#if defined (__SCA__)
			&sca_configuration_table,
		#endif
		#if defined (__SCONSOLE__)
			&server_console_configuration_table,
		#endif
		#if defined (__SNMP_AGENT__)
			&snmp_configuration_table,
		#endif
		#if defined (__SOCKET__)
			&socket_configuration_table,
		#endif
		#if defined (__SPX__)
			&spx_configuration_table,
		#endif
		#if defined (__SRC__)
			&source_routing_configuration_table,
		#endif
		#if defined (__STP__)
			&stp_configuration_table,
		#endif
		#if defined (__TCP__)
			&tcp_configuration_table,
		#endif
		#if defined (__TELNET__)
			&telnet_configuration_table,
		#endif
		#if defined (__TFTP__)
			&tftp_configuration_table,
		#endif
		#if defined (__TR__)
			&token_mac_configuration_table,
		#endif
		#if defined (__VJC__)
			&vjc_configuration_table,
		#endif
		    NULL
	   };

void nvram_printf (const char *cptr_format, ...);
