/*
 * $Log: rw_dispatcher_structures.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:47  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:19:37  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:50:48  TTY
 * Initial revision
 *
 * 
 * 4     11/13/98 9:25p Mahesh
 * improved timer functionality and some bug fixes
 * 
 * 3     10/09/98 7:19p Mahesh
 * Corrected the scheduler algorithm
 * 
 * 2     9/09/98 3:08p Mahesh
 * No Changes!
 * 
 * 1     9/03/98 7:39p Mahesh
 * Initial checkin
 */
/************************************************************************/
/*	Copyright (C) 1998 RouterWare, Inc.	 								*/
/*	Unpublished - rights reserved under the Copyright Laws of the		*/
/*	United States.  Use, duplication, or disclosure by the 				*/
/*	Government is subject to restrictions as set forth in 				*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 		*/
/*	Computer Software clause at 252.227-7013.							*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach, CA	*/
/************************************************************************/
#if !defined (__RW_DISPATCHER_STRUCTURES_H__)
#define __RW_DISPATCHER_STRUCTURES_H__

typedef enum RWOS_DISPATCHER_STATE
{
	RWOS_DISPATCHER_STATE_ACTIVE,

	RWOS_DISPATCHER_STATE_IDLE

} RWOS_DISPATCHER_STATE;

typedef struct RW_DISPATCHER
{
	RWOS_DISPATCHER_STATE state;

	RWOS_DISPATCHER_PRIORITY priority;

	void* p_user;

	FPTR_DISPATCHER_HANDLER fptr_idle_timer_handler;

	RWOS_TIME_STAMP time_stamp;

	RW_CONTAINER* p_events;

} RW_DISPATCHER;

typedef struct RW_EVENT
{
	bool signalled;

	RW_DISPATCHER* p_dispatcher;

	FPTR_DISPATCHER_HANDLER fptr_event_handler;

} RW_EVENT;

typedef struct RW_DISPATCH_QUEUE
{
	RWOS_DISPATCHER_PRIORITY priority;

	void* p_user;

	UINT sleep_duration;

	FPTR_DISPATCHER_HANDLER fptr_idle_timer_handler;

	FPTR_DISPATCH_QUEUE_ITEM_HANDLER fptr_item_handler;	

	RW_CONTAINER* p_item_queue;

} RW_DISPATCH_QUEUE;

typedef struct RW_SCHEDULER_QUEUE
{
	RWOS_DISPATCHER_PRIORITY priority;

	UINT base_priority_value;

	UINT current_priority_value;

	RW_CONTAINER* p_active_queue;

} RW_SCHEDULER_QUEUE;


typedef struct RWOS_SCHEDULER
{
	RW_SCHEDULER_QUEUE dispatcher_priority_queue[NUMBER_OF_DISPATCHER_PRIORITIES];

	RW_CONTAINER* p_idle_queue;
	
	UINT number_of_idle_objects_to_schedule;

} RWOS_SCHEDULER;

#endif /* __RW_DISPATCHER_STRUCTURES_H__ */
