/*
 * $Log: accesnmp.c,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:47  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:14:53  SHAO-GH
 * no message
 *
 * Revision 1.3  2001/12/11 09:16:42  TTY
 * Changed '\' to '/' in includes.
 *
 * 
 *    Revision 1.2   21 Feb 2000 13:12:54   TTY
 * Changed include files directory
 * 
 *    Revision 1.1   23 Nov 1999 12:49:36   TTY
 * Initial revision.
 * 
 * 2     5/01/98 3:41p Nishit
 * Checkin in released (4.2.1) code
 * 
 * 2     4/24/98 10:24a Release Engineer
 * Added MD5 and (de)serialize utility functions 
 * RWUTILS v4.2.1
 * 
 * 1     3/27/98 2:19p Release Engineer
 * check - in
 * 
 * 1     2/13/98 12:17a Release Engineer
 * SNMP changes to correspond with ULONG table indices.
 * Also code cleanup and code style changes.  
 * New serialize and deserialize utility functions where
 * added.
 * RWUTILS v4.2.0
 * 
 * 
 * 2     2/13/96 7:51p Ross
 * Adding version control header.
*/
/*	$Modname: accesnmp.c$  $version: 1.3$      $date: 01/30/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
1.2 01/26/95 ross SNMP file added
1.3 01/30/95 ross removing duplicate configuration options
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 - 1998 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "../include/kstart.h"
#include "../include/v8022str.h"
#include "../include/lslproto.h"
/**********************************************************************************/
enum TEST snmp_get_or_set_ulong (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000L;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value_obtained = *(ULONG *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (*(ULONG *) vptr_mib_value_obtained);

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(ULONG *) (_class + offset + (size * port_number)) = swap_long (value);
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_ushort (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000L;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(USHORT *) (_class + offset + (size * port_number)) = (USHORT) swap_long (value);

		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_boolean_plus_one (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000L;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(BYTE *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value + 1);

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) (value + 1);

		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_byte (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000L;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(BYTE *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) value;
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_string (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		strcpy ((char *) vptr_mib_value_obtained, (char *) (_class + offset + (size * port_number)));

		*usptr_length_of_mib_obtained = (USHORT) strlen (vptr_mib_value_obtained);

		if (*usptr_length_of_mib_obtained == 0)
			{
			*usptr_length_of_mib_obtained = 0X0001;
			}
		}
	else if (mib_operation == SET_OPERATION)
		{
		if (*usptr_length_of_mib_obtained > 0)
			{
			memcpy ((void *) (_class + offset + (size * port_number)), (void *) vptr_mib_value_obtained, *usptr_length_of_mib_obtained);
			}
		else if (strlen (vptr_mib_value_obtained) > 0)
			{
			strcpy ((char *) (_class + offset + (size * port_number)), (char *) vptr_mib_value_obtained);
			}
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_mac_address (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_mac_address;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_mac_address = (BYTE *) (_class + offset + (size * port_number));

		memcpy (vptr_mib_value_obtained, vptr_mac_address, sizeof (MAC_ADDRESS));

		*usptr_length_of_mib_obtained = sizeof (MAC_ADDRESS);
		}
	else if (mib_operation == SET_OPERATION)
		{
		vptr_mac_address = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_mac_address, vptr_mib_value_obtained, sizeof (MAC_ADDRESS));
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_8_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_mib_value, vptr_class_variable, 0x0008);

		*usptr_length_of_mib_obtained = 0x0008;
		}
	else if (mib_operation == SET_OPERATION)
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_class_variable, vptr_mib_value, 0x0008);
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_2_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memset ((BYTE *) vptr_mib_value, (int) NULL, sizeof (USHORT));

		memcpy ((BYTE *) vptr_mib_value + sizeof (USHORT), vptr_class_variable, sizeof (USHORT));

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else if (mib_operation == SET_OPERATION)
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memset ((BYTE *) vptr_class_variable, (int) NULL, sizeof (USHORT));

		memcpy (vptr_class_variable, (BYTE *) vptr_mib_value + sizeof (USHORT), sizeof (USHORT));
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_port_number (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (offset);
	PARAMETER_NOT_USED (_class);
	PARAMETER_NOT_USED (size);

	value = (ULONG) port_number + 1;

	if ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value = swap_long (value);

		*usptr_length_of_mib_obtained = sizeof (ULONG);
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
