/* dhcpsLib.h - DHCP server include file for user interface */

/* Copyright 1984 - 1997 Wind River Systems, Inc. */

/*
modification history
____________________
01e,04dec97,spm  added code review modifications
01d,06oct97,spm  moved default parameters from usrNetwork.c; added prototypes
                 for user-callable routines
01c,06aug97,spm  added definitions for C++ compilation
01b,18apr97,spm  added dhcpsInit() prototype to eliminate compiler warnings
01a,07apr97,spm  created.
*/

#ifndef __INCdhcpsLibh
#define __INCdhcpsLibh

#ifdef __cplusplus
extern "C" {
#endif

#define S_dhcpsLib_NOT_INITIALIZED           (M_dhcpsLib | 1)


#define PROTO_ICMP 1                   /* Normally found in /etc/protocols */

#if CPU_FAMILY==I960
#pragma align 1                 /* tell gcc960 not to optimize alignments */
#endif  /* CPU_FAMILY==I960 */

typedef struct leaseDesc
    {
    /* 
     * This structure defines the components of an address pool entry. 
     * The DHCP server issues leases for individual IP addresses from
     * the address pool.
     */

    char *pName;    /* base name of pool entry */
    char *pStartIp;     /* first IP address in range */
    char *pEndIp;   /* last IP address in range */
    char *pParams;  /* other lease parameters */
    } DHCPS_LEASE_DESC;

typedef struct entryDesc
    {
    /*
     * This structure defines the components of a single lease entry
     * from the address pool which will be offered to DHCP clients.
     */

    char *pName;    /* unique name of lease entry */
    char *pAddress;     /* single IP address within range */
    char *pParams;  /* associated lease parameters */
    } DHCPS_ENTRY_DESC;

typedef struct relayDesc
    {
    /*
     * This structure contains information for a relay agent used to 
     * communicate with DHCP clients or servers on other networks.
     */

    char *pAddress;     /* IP address of relay agent */
    char *pMask;    /* Subnet mask of supported network */
    } DHCPS_RELAY_DESC;

#include "dhcprLib.h"                /* Relay agent capability. */

#if CPU_FAMILY==I960
#pragma align 0                 /* turn off alignment requirement */
#endif  /* CPU_FAMILY==I960 */

IMPORT DHCPS_LEASE_DESC *      pDhcpsLeasePool;
IMPORT DHCPS_RELAY_DESC *      pDhcpsRelaySourceTbl;

/* User-callable routines */

IMPORT STATUS dhcpsInit (struct ifnet **, int, DHCPS_LEASE_DESC *, int,
                         DHCPS_RELAY_DESC *, int, DHCP_TARGET_DESC *, int);
IMPORT STATUS dhcpsLeaseEntryAdd (char *, char *, char *, char *);
IMPORT STATUS dhcpsLeaseHookAdd (FUNCPTR);
IMPORT STATUS dhcpsAddressHookAdd (FUNCPTR);

/* Internal routines */

//DZ
IMPORT int dhcpsInputHook (struct ifnet*, char*, int);


IMPORT int open_if();
IMPORT STATUS read_addrpool_file (void);
IMPORT void read_server_db (int);
IMPORT int process_entry (struct dhcp_resource *, DHCPS_ENTRY_DESC *);
IMPORT void set_default (struct dhcp_resource *);

/* Critical section semaphore. */

IMPORT SEM_ID dhcpsMutexSem;

/* Operations on database cache. */

#define DHCPS_STORAGE_START 0
#define DHCPS_STORAGE_STOP 1
#define DHCPS_STORAGE_WRITE 2
#define DHCPS_STORAGE_READ 3
#define DHCPS_STORAGE_CLEAR 4

/*
 * The following string contains host requirements defaults needed for
 * RFC compliance - DO NOT REMOVE OR MODIFY!!
 */
 
#define DHCPS_DEFAULT_ENTRY "ipfd=false:nlsr=false:mdgs=576:ditl=64:ifmt=576:asnl=false:brda=255.255.255.255:mskd=false:msks=false:rtrd=true:rtsl=255.255.255.255:trlr=false:arpt=60:encp=false:dttl=64:kain=7200:kagb=false"

#ifdef __cplusplus
}
#endif

#endif
