/* ipcp.h - IP Control Protocol header */

/* Copyright 1995 Wind River Systems, Inc. */

/*
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
modification history
--------------------
01a,16jan95,dzb  WRS-ize.
*/

#ifndef	__INCipcph
#define	__INCipcph

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * Options.
 */
#define CI_ADDRS	1	/* IP Addresses */
#define CI_COMPRESSTYPE	2	/* Compression Type */
#define	CI_ADDR		3

//panda+
#define CI_PDNSADDRS	0x81	/* CODE - Primary DNS */
#define CI_PNBNSADDRS	0x82	/* CODE - Primary NBNS */
#define CI_SDNSADDRS	0x83	/* CODE - Secondary DNS */
#define CI_SNBNSADDRS	0x84	/* CODE - Secondary NBNS */
//panda+ above

#define MAX_STATES 16		/* from ppp_slcompress.h */

#define IPCP_VJMODE_OLD 1	/* "old" mode (option # = 0x0037) */
#define IPCP_VJMODE_RFC1172 2	/* "old-rfc"mode (option # = 0x002d) */
#define IPCP_VJMODE_RFC1332 3	/* "new-rfc"mode (option # = 0x002d, */
                                /*  maxslot and slot number compression) */

#define IPCP_VJ_COMP 0x002d	/* current value for VJ compression option*/
#define IPCP_VJ_COMP_OLD 0x0037	/* "old" (i.e, broken) value for VJ */
				/* compression option*/

typedef struct ipcp_options {
    int neg_addr : 1;		/* Negotiate IP Address? */
    int old_addrs : 1;		/* Use old (IP-Addresses) option? */
    int req_addr : 1;		/* Ask peer to send IP address? */
    int default_route : 1;	/* Assign default route through interface? */
    int proxy_arp : 1;		/* Make proxy ARP entry for peer? */
    int neg_vj : 1;		/* Van Jacobson Compression? */
    int old_vj : 1;		/* use old (short) form of VJ option? */
    int accept_local : 1;       /* accept peer's value for ouraddr */
    int accept_remote : 1;      /* accept peer's value for hisaddr */
    int neg_pdns : 1;		/* Primary DNS? panda+*/
    int neg_pnbns : 1;		/* Primary NBNS? panda+*/
    int neg_sdns : 1;		/* Secondary DNS? panda+*/
    int neg_snbns : 1;		/* Secondary NBNS? panda+*/
    u_short vj_protocol;	/* protocol value to use in VJ option */
    u_char maxslotindex, cflag;	/* values for RFC1332 VJ compression neg. */
    u_long ouraddr, hisaddr, pdnsaddr, pnbnsaddr, sdnsaddr, snbnsaddr;	/* Addresses in NETWORK BYTE ORDER panda+dns&nbns*/
} ipcp_options;

extern void ipcp_init __ARGS((int));
extern void ipcp_open __ARGS((int));
extern void ipcp_close __ARGS((int));
extern void ipcp_lowerup __ARGS((int));
extern void ipcp_lowerdown __ARGS((int));
extern void ipcp_input __ARGS((int, u_char *, int));
extern void ipcp_protrej __ARGS((int));
extern int ipcp_printpkt __ARGS((u_char *, int, void (*)(), void *));
extern char *ip_ntoa __ARGS((u_long));

#ifdef  __cplusplus
}
#endif

#endif /* __INCipcph */
