#ifndef __BRDG_END_H
#define __BRDG_END_H

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 * 
 * includes 
 *
 */

#include "bspcfg.h"
#include "vxWorks.h"

#include "wdLib.h"
#include "iv.h"
#include "vme.h"
#include "net/mbuf.h"
#include "net/unixLib.h"
#include "net/protosw.h"
#include "sys/socket.h"
#include "sys/ioctl.h"
#include "errno.h"
#include "memLib.h"
#include "intLib.h"
#include "net/route.h"
#include "iosLib.h"
#include "errnoLib.h"

#include "cacheLib.h"
#include "logLib.h"
#include "netLib.h"
#include "stdio.h"
#include "stdlib.h"
#include "sysLib.h"

#include "etherLib.h"
#include "net/systm.h"
#include "sys/times.h"
#include "net/if_subr.h"

#undef    ETHER_MAP_IP_MULTICAST
#include "etherMultiLib.h"
#include "end.h"
#include "endLib.h"

#include "lstLib.h"
#include "semLib.h"

#include "netBufLib.h"  

#include "protoutils.h"

#define BRDG_DRV_NAME           "br"
#define BRDG_DRV_NAME_LEN       4
#define BRDG_DRV_DESC         	"Conexant BRDG Enhanced Network Driver"

/*******************************************************************************
 * Ethernet Standards:
 *
 * 1. Ethernet Frame fields - order left to right - are:
 *    preamble[7],sfd[1],da[6],sa[6],type(or len)[2],data[var],pad[var],fcs[4].
 *    Where, [x] = length in bytes. [var] = variable length.
 *
 *    da, sa & type(or len) put together is called ethernet header.
 *
 *    ISO802.3 has length field instead of Type field.
 *    But in both cases ethernet & ISO802.3, the length of the 3rd field
 *    remains 2 bytes. 
 *
 *    Ethernet address, Physical address & MAC address are synonymous.
 *
 *    ENET_HDR_REAL_SIZ: len of destination & source addr & type = 14 bytes.
 *    ETHERMTU: max length of data & pad fields = 1500 bytes.
 *    ETHERMIN: min length of data & pad fields (60-14) = 46 bytes.
 *
 * 2. MAC HW:
 *    Preamble & sfd are removed/added by Rx/Tx MAC HW before the frame
 *    is sent up/down to the protocols/cable. So as far as MAC SW (driver) goes, 
 *    the frame starts from DA and ends with FCS.
 */
#define MEM_PART_SIZE       0x00200000
#define EMAC_CLUSTER_SZ     2048

#define EADDR_LEN           6           /* ethernet address length */

#define NET_SPEED_10        10000000    /* 10 Mbps        */
#define NET_SPEED_100       100000000   /* 100 Mbps    */

typedef struct tx_mib
{
    unsigned long txRequest;
    unsigned long txQFull;
    unsigned long txFatalDiscard;
    unsigned long numTxPending;
    unsigned long txOk;
    unsigned long txError;
} TX_MIB; 

typedef struct err_mib
{
	long	Dummy;
} ERR_MIB;
   
/**********************************************************/    
/* MIB's                                                  */
/**********************************************************/    
typedef struct rx_mib
{
    /* driver counters */
    unsigned long rxGood;    
    unsigned long qFullHw;
    unsigned long clAlignErr;
    unsigned long outofMblk;    
    unsigned long bridgeOffDrop;

} RX_MIB;


/*
 * The BRDG End driver control structure 
 */

typedef struct BRDG_drv_ctrl
{
    END_OBJ     	endObj;             /* base class */
	 unsigned int	bridgePort;
    int         flags;              /* driver flags */
    int         unit;               /* logical unit number (instance #) */

//    int         hw_unit;            /* physical unit number */
//    char        *memBase;           /* descriptor mempool base addr */
//    ULONG       memSize;            /* descriptor mempool size */

    ULONG       usrFlags;
    CL_POOL_ID  clPoolId;

	 unsigned char       PortNetAddress[6]; /* ethernet address */

    TX_MIB      txMIB;
    RX_MIB      rxMIB;
    ERR_MIB     errMIB;

} BRDG_DRV_CTRL;


/*******************************************************************************
 * EMAC specific ethernet frame size (w/o CRC) & cluster size requirements.
 */

/* define for IOCTL, was decided to be 64 after talking to vxworks */
/* this is not being used by vxworks at this time but is include for */
/* completeness */
//#define EMAC_MIN_BUFFER_FOR_CHAINING    ( 64 )

/*
 * END specific defines
 */

#define END_FLAGS_ISSET(pEnd, setBits)              \
        ((pEnd)->flags & (setBits))

#define END_HADDR(pEnd)                             \
        ((pEnd)->mib2Tbl.ifPhysAddress.phyAddress)

#define END_HADDR_LEN(pEnd)                         \
        ((pEnd)->mib2Tbl.ifPhysAddress.addrLength)

#define END_MIB_SPEED_SET(pEndObj, speed)           \
        ((pEndObj)->mib2Tbl.ifSpeed=speed)


/*
 * DRV_CTRL flags & access macros 
 */

#define DRV_MEMOWN      0x0001      /* TDs and RDs allocated by driver */
#define EMAC_POLLING    0x0004      /* Poll mode, io mode              */
#define FLT_PROMISC     0x0008      /* Promiscuous, rx mode            */
#define FLT_MCAST       0x0010      /* Multicast, rx mode              */

#define DRV_FLAGS_SET(setBits)          \
        (pDrvCtrl->flags |= (setBits))

#define DRV_FLAGS_ISSET(setBits)        \
        (pDrvCtrl->flags & (setBits))

#define DRV_FLAGS_CLR(clrBits)          \
        (pDrvCtrl->flags &= ~(clrBits))

#define DRV_FLAGS_GET()                 \
        (pDrvCtrl->flags)

        
/*******************************************************************************
 *
 * Forward declarations 
 *
 */

/*
 * externals 
 */


/*
 * END Specific interfaces. 
 */

/* tUsrRoot to END: The only function exported out is the load function. */
END_OBJ *BRDG_Load ( signed char *initString, void *pBSP );

#ifdef __cplusplus
}
#endif

#endif /* __EMAC_END_H */
