/***************************************************************************
 *   MODULE NAME    : mac_filter.h                                         *
 ***************************************************************************
 *   Copyright 2001 Conexant Systems, Inc. as unpublished work             *
 *   All Rights Reserved                                                   *
 *                                                                         *
 *   The information contained herein is the confidential property         *
 *   of Conexant Systems, Inc..  The use, copying, transfer or             *
 *   disclosure of such information is prohibited except by express        *
 *   written agreement with Conexant Systems, Inc..                        *
 *                                                                         *
 *   Original Written By  :    Mickey Hung                                 *
 *   Original Date        :    03/06/2001                                  *
 ***************************************************************************/
/***************************************************************************
 * This file implements all the data types, structures and API declaration *
 * of MAC address table provided for MAC Filtering function in EZ-Connect  * 
 * project. All the implementaions are in source file "mac_filer.c" file.  *  
 ***************************************************************************/

#ifndef _MAC_FILTER_H_
#define _MAC_FILTER_H_




/*-------------------------------------------------------------------------*/
/*							for mac filter address table...                */
/*-------------------------------------------------------------------------*/
#define MAX_FILTER_ADDR_TBL_SIZE		16

/*-------------------------------------------------------------------------*/
/*							mac filtering enable/disable                   */
/*-------------------------------------------------------------------------*/
#define MAC_FILTER_ON	1
#define MAC_FILTER_OFF	0

/*-------------------------------------------------------------------------*/
/*				"func_num" defined in "BRDG_addrTbl_Access()"    	       */
/*-------------------------------------------------------------------------*/
#define FILTER_TBL_INIT				0
#define	FILTER_FUNC_ENABLE			1	
#define FILTER_FUNC_DISABLE			2
#define FILTER_TBL_ADD_ENTRY		3
#define FILTER_TBL_DEL_ENTRY		4
#define FILTER_TBL_MAC_CHECK		5
#define FILTER_TBL_GET_TBL			6



/***************************************************************************/
/*                   DATA TYPE AND STRUCTURE DEFINITION                    */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/* Address Table, for bridging function... We maintain only ONE Address    */
/* table for LAN and WAN side altogether... We will be able to tell the    */
/* mac address is from LAN side or which PVC by looking up the             */
/* corresponding "port_num" in address table...                            */
/* The "max_tbl_size" indicates the maximum size of this address table...  */
/* The "currt_tbl_size" indicates the current number of entries in the     */
/* address table...														   */  
/*-------------------------------------------------------------------------*/
typedef struct
{
	UINT8	src_mac[6];		/* src mac address of the incoming packet */

} STRUCT_MacFilterAddrTblEntry;


/* initially, size=0 */
typedef struct 
{
	UINT8	filter_function;			/* the filter function is enable/disable */
	UINT8	max_tbl_size;			/* max size of address table */
	UINT8   currt_tbl_size;			/* current number of entries in the table */
	STRUCT_MacFilterAddrTblEntry	filterAddrTblEntry[MAX_FILTER_ADDR_TBL_SIZE];
								
} STRUCT_MacFilterAddrTbl;



/*------------------------------------------------------------*/
/*			Return status of BRDG_addrTbl_Access()			  */
/*------------------------------------------------------------*/
typedef enum
{
	/* the first part of the return status are returned */
	/* directly from internal routines...				*/
	FILTER_OK,					/* general ok */
	FILTER_ERROR,				/* general error */

	FILTER_TBL_FULL,			/* table full error */
	FILTER_TBL_EMPTY,			/* table empty error */
	FILTER_NOT_IN_TBL,			/* entry not in the table */
	FILTER_MAC_IN_TBL,          /* entry found in the table */


	/* the following two status mean the function	*/ 
	/* even haven't been interpreted...				*/
	FILTER_SEM_ERROR,			/* error regarding semaphores				*/
	FILTER_FUNC_ERROR 			/* error regarding func_num interpretation	*/

} FILTER_STATUS;





/***************************************************************************/
/*                          GLOBAL FUNCTION DECLARATION                    */
/***************************************************************************/
FILTER_STATUS 	macFILTER_CTRL(int func_num, void* param);


/* --------------------------------------------------- */
/*   The following global routines are for debugging   */
/* --------------------------------------------------- */  
void d_show_filter_tbl(void);




#endif _MAC_FILTER_H_



/***************************************************************************/
/* $History$ 
 */