/***************************************************************************
 *   MODULE NAME    : mac_table.h                                          *
 ***************************************************************************
 *   Copyright 2001 Conexant Systems, Inc. as unpublished work             *
 *   All Rights Reserved                                                   *
 *                                                                         *
 *   The information contained herein is the confidential property         *
 *   of Conexant Systems, Inc..  The use, copying, transfer or             *
 *   disclosure of such information is prohibited except by express        *
 *   written agreement with Conexant Systems, Inc..                        *
 *                                                                         *
 *   Original Written By  :    Mickey Hung                                 *
 *   Original Date        :    02/13/2001                                  *
 ***************************************************************************/
/***************************************************************************
 * This file implements all the data types, structures and API declaration *
 * of MAC address table provided for bridging function in EZ-Connect       *
 * project. All the implementaions are in source file "mac_table.c" file.  *
 ***************************************************************************/


#ifndef _MAC_TABLE_H_
#define _MAC_TABLE_H_


#include "bspcfg.h"
#include "br_control.h"

#define BRG_FOR_DAFFYII
#undef  BRG_FOR_HASBANI
/*-------------------------------------------------------------------------*/
/*							for bridging address table...                  */
/*-------------------------------------------------------------------------*/
#define MAX_BRDG_ADDR_TBL_SIZE		128
#define DEFAULT_AGE_TIME_INTERVAL	100 /* second */

/*-------------------------------------------------------------------------*/
/*				"port_num" defined in STRUCT_BrdgAddrTblEntry			   */
/*-------------------------------------------------------------------------*/
/* "MAC_IN_PVC1" must start from "0" in order */
/* to reference to PVC endobj correctly...	  */

#define PORT_P_EMAC1		0
	#define PORT_L_EMAC1_0	0

#define PORT_P_EMAC2		1
	#define PORT_L_EMAC2_0	0

#define PORT_P_ADSL			2
	#define PORT_L_ADSL_0 	0
	#define PORT_L_ADSL_1 	1
	#define PORT_L_ADSL_2 	2
	#define PORT_L_ADSL_3 	3
	#define PORT_L_ADSL_4 	4
	#define PORT_L_ADSL_5 	5
	#define PORT_L_ADSL_6 	6
	#define PORT_L_ADSL_7 	7

#define PORT_P_USB			3
	#define PORT_L_USB_0	0

#define PORT_P_WIRELESS			4
	#define PORT_L_WIRELESS_0	0

/*-------------------------------------------------------------------------*/
/*				"func_num" defined in "BRDG_addrTbl_Access()"    	       */
/*-------------------------------------------------------------------------*/
#define ADDR_TBL_INITIAL		0
#define	ADDR_TBL_ADJUST_TIMER	1
#define ADDR_TBL_RESET_TIMER	2
#define ADDR_TBL_ADD_ENTRY		3
#define ADDR_TBL_COMPARE_MAC	4
#define ADDR_TBL_GET_NEXT_MAC	5
#define ADDR_TBL_READJUST_TIMER 6
#define ADDR_TBL_GET_MAC_TABLE  7



/***************************************************************************/
/*                   DATA TYPE AND STRUCTURE DEFINITION                    */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/* Address Table, for bridging function... We maintain only ONE Address    */
/* table for LAN and WAN side altogether... We will be able to tell the    */
/* mac address is from LAN side or which PVC by looking up the             */
/* corresponding "port_num" in address table...                            */
/* The "max_tbl_size" indicates the maximum size of this address table...  */
/* The "currt_tbl_size" indicates the current number of entries in the     */
/* address table...														   */
/*-------------------------------------------------------------------------*/
typedef struct
{
	UINT8	src_mac[6];		/* src mac address of the incoming packet */
	#ifdef MAC_OPERATION_IMPROVE
	UINT8	mac_hash;
	#endif
	BR_PORT	*pPort;			/* which port the packet is from          */
	//UINT8	port_num;		/* the packet is from LAN or which PVC    */
	//UINT8	port_logical; 	/* the packet is from LAN or which PVC    */
	UINT32  age_time;		/* time left(sec) for this entry before time out */
	UINT32  my_mac;
} STRUCT_BrdgAddrTblEntry;


/* initially, size=0 */
typedef struct
{
	UINT8	max_tbl_size;			/* max size of address table */
	UINT8   currt_tbl_size;		/* current number of entries in the table */
	STRUCT_BrdgAddrTblEntry		brdgAddrTblEntry[MAX_BRDG_ADDR_TBL_SIZE];

} STRUCT_BrdgAddrTbl;



/*------------------------------------------------------------*/
/*			Return status of BRDG_addrTbl_Access()			  */
/*------------------------------------------------------------*/
typedef enum
{
	/* the first part of the return status are returned */
	/* directly from internal routines...				*/
	RTN_OK,					/* general ok */
	RTN_ERROR,				/* general error */

	RTN_TBL_FULL,			/* table full error */
	RTN_TBL_EMPTY,			/* table empty error */
	RTN_NOT_IN_TBL,			/* entry not in the table */
	RTN_MAC_IN_TBL,         /* entry found in the table */
	RTN_MAC_MY_MAC,         /* entry found in the table */
	RTN_MAC_MY_OTHER_MAC,   /* entry found in the table */

	/* the following two status mean the function	*/
	/* even haven't been interpreted...				*/
	RTN_SEM_ERROR,			/* error regarding semaphores				*/
	RTN_FUNC_ERROR 			/* error regarding func_num interpretation	*/

} RTN_STATUS;





/***************************************************************************/
/*                          GLOBAL FUNCTION DECLARATION                    */
/***************************************************************************/
RTN_STATUS 	BRDG_addrTbl_Access(int func_num,
								UINT8* mac,
                                BR_PORT *pPort,
								//int	  my_mac,
								int* rtn_val	);

STATUS WEB_reAdjustMACTableAgeTime(void);
STATUS WEB_getMACTable(STRUCT_BrdgAddrTbl* WEB_mac_table);

UINT16 BridgeAgeingTimeGet();
void BridgeAgeingTimeSet(UINT16 T);

/* --------------------------------------------------- */
/*   The following global routines are for debugging   */
/* --------------------------------------------------- */
void d_show_mac_tbl(void);



#endif _MAC_TABLE_H_


/***************************************************************************/
/* $History$
 */
