 

/***************************************************************************** 
FILE NAME:	Protocol.h:

HISTORY:	98.11.16	Creation		G.L.
		98.11.19	Snarf Provisioning	G.L.
		98.11.29	Transparent Bridging	G.L.
		98.12.04	Address Learning	G.L.
		99.03.09	Release 0.1		G.L.

DESCRIPTION:	This header file defines constants, data types and function
		prototypes for the Snarf protocols of the SuperPIPE product.
		The implemention of functions is contained in Protocol.c. 

REFERENCES:	"SuperPIPE ARM#1 Software Design Document"
		"SuperPIPE Silicon System Design Engineering Specification" 

		Copyright 1999 Conexant Systems, Inc. 
		ALL RIGHTS RESERVED
		This file is Conexant proprietary, and all Conexant corporate 
		policies regarding source-file distribution must be observed.
********************************************************************************/

#ifndef __OUTPUTP_H
#define __OUTPUTP_H

#ifdef __cplusplus
extern "C" {
#endif

#include "protocol.h"
#include "vxWorks.h"
#include "net/mbuf.h"
#include "netBufLib.h"  
#include "net/systm.h"
#include "netLib.h"
#include "sys/ioctl.h"
#include "sysLib.h"
#include "sys/times.h"
#include "errno.h"
#include "errnoLib.h"
#include "memLib.h"
#include "intLib.h"
#include "cacheLib.h"
#include "logLib.h"
#include "iosLib.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "muxLib.h"
#include "etherLib.h"
#include "end.h"


#define PROTOERR(s) \
	fprintf( stderr, "Error: %s.  Failed in %s at line %d.\n", s, __FILE__, __LINE__ ); 

#if 1
struct PMIB
{
	struct
	{
		struct
		{
			unsigned int pkts;
			unsigned int cumchains;
			unsigned int netTupleGetfail;
			unsigned int netMblkToBufCopyfail;
			unsigned int chained;
			unsigned int notchained;
			unsigned int netMblkChainDupfail;
			unsigned int emacendSendfail;
			unsigned int cmacendSendfail;
			unsigned int emacendSendsuccess;
			unsigned int cmacendSendsuccess;
			unsigned int shutdownrtn;
			unsigned int restartrtn;
			unsigned int errorrtn;
			unsigned int initrtn;
		} cmac;

		struct
		{
			unsigned int pkts;
			unsigned int cumchains;
			unsigned int netTupleGetfail;
			unsigned int netMblkToBufCopyfail;
			unsigned int chained;
			unsigned int notchained;
			unsigned int netMblkChainDupfail;
			unsigned int emacendSendfail;
			unsigned int cmacendSendfail;
			unsigned int emacendSendsuccess;
			unsigned int cmacendSendsuccess;
			unsigned int shutdownrtn;
			unsigned int restartrtn;
			unsigned int errorrtn;
			unsigned int initrtn;
		} emac;

	} output;

	struct
	{
		long	Dummy;
	} snarf;
};
#endif

#ifdef __cplusplus
}
#endif


#endif   /* __PROTOCOL_H */


