/*       
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *=========================================================================+
 *
 * Module:      rfc1695_sub.h - ATM SNMP MIB handler header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/rfc1695_sub.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This header file contains definitions used by ATM SNMP
 *              mib handlers (rfc1695_stub.c) and supporting subroutines
 *              (rfc1695_sub.c).
 * 
 *=========================================================================+
 */

#ifndef _RFC1695_SUB_H_
#define _RFC1695_SUB_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "snmpapi.h"
#include "snmpapi_atm.h"	// for ATM SNMP API based on RFC1695

//#define SNMP_RFC1695_DEBUG	1

#define STRUCT_atmInterfaceConfEntry		MIB_ATM_INTERFACE_CONF_ENTRY
#define STRUCT_atmInterfaceDs3PlcpEntry		MIB_ATM_INTERFACE_DS3_PLCP_ENTRY
#define STRUCT_atmInterfaceTCEntry			MIB_ATM_INTERFACE_TC_ENTRY
#define STRUCT_atmTrafficDescrParamEntry	MIB_ATM_TRAFFIC_DESCR_PARAM_ENTRY
#define STRUCT_atmVplEntry					MIB_ATM_VPL_ENTRY
#define STRUCT_atmVclEntry					MIB_ATM_VCL_ENTRY
#define STRUCT_atmVpCrossConnectEntry		MIB_ATM_VP_CROSS_CONNECT_ENTRY
#define STRUCT_atmVcCrossConnectEntry		MIB_ATM_VC_CROSS_CONNECT_ENTRY
#define STRUCT_aal5VccEntry					MIB_AAL5_VCC_ENTRY

typedef struct
{
    m_UINT32    atmVpCrossConnectIndexNext;
    m_UINT32    atmVcCrossConnectIndexNext;
} STRUCT_atmMIBObjects;

BOOL atmFirstActivePvc 
( 
	UINT32	ifIndex, 
	UINT32 	*pPvc 
);
BOOL atmNextActivePvc 
( 
	UINT32 	ifIndex, 
	UINT32 	*pPvc 
);
int atmInterfaceConfEntry_lookup
(
    int                            	compc,
    OIDC_T                          *compl,
    STRUCT_atmInterfaceConfEntry    *data
);
void atmInterfaceConfEntry_firstEntry
( 
    STRUCT_atmInterfaceConfEntry    *data
);
void atmInterfaceConfEntry_nextEntry
( 
    STRUCT_atmInterfaceConfEntry    *data
);
unsigned atmInterfaceConfEntry_build_instance
(
    STRUCT_atmInterfaceConfEntry  	*data,
    OIDC_T              			*tmp_inst
);
BOOL atmInterfaceConfEntry_installEntry
(
    STRUCT_atmInterfaceConfEntry    *data
);
int atmInterfaceDs3PlcpEntry_lookup
(
    int                 			compc,
    OIDC_T              			*compl,
    STRUCT_atmInterfaceDs3PlcpEntry *data
);
void atmInterfaceDs3PlcpEntry_firstEntry
( 
    STRUCT_atmInterfaceDs3PlcpEntry *data
);
void atmInterfaceDs3PlcpEntry_nextEntry
( 
    STRUCT_atmInterfaceDs3PlcpEntry *data
);
unsigned atmInterfaceDs3PlcpEntry_build_instance
(
    STRUCT_atmInterfaceDs3PlcpEntry *data,
    OIDC_T              			*tmp_inst
);
BOOL atmInterfaceDs3PlcpEntry_installEntry
(
    STRUCT_atmInterfaceDs3PlcpEntry *data
);
int atmInterfaceTCEntry_lookup
(
    int                 		compc,
    OIDC_T              		*compl,
    STRUCT_atmInterfaceTCEntry  *data
);
void atmInterfaceTCEntry_firstEntry
( 
    STRUCT_atmInterfaceTCEntry  *data
);
void atmInterfaceTCEntry_nextEntry
( 
    STRUCT_atmInterfaceTCEntry  *data
);
unsigned atmInterfaceTCEntry_build_instance
(
    STRUCT_atmInterfaceTCEntry  *data,
    OIDC_T              		*tmp_inst
);
BOOL atmInterfaceTCEntry_installEntry
(
    STRUCT_atmInterfaceTCEntry 	*data
);
int atmTrafficDescrParamEntry_lookup
(
    int                 				compc,
    OIDC_T              				*compl,
    STRUCT_atmTrafficDescrParamEntry  	*data
);
void atmTrafficDescrParamEntry_firstEntry
( 
    STRUCT_atmTrafficDescrParamEntry    *data
);
void atmTrafficDescrParamEntry_nextEntry
( 
    STRUCT_atmTrafficDescrParamEntry    *data
);
unsigned atmTrafficDescrParamEntry_build_instance
(
    STRUCT_atmTrafficDescrParamEntry  	*data,
    OIDC_T              				*tmp_inst
);
BOOL atmTrafficDescrParamEntry_installEntry
(
    STRUCT_atmTrafficDescrParamEntry 	*data
);
int atmVplEntry_lookup
(
    int                	compc,
    OIDC_T              *compl,
    STRUCT_atmVplEntry  *data
);
void atmVplEntry_firstEntry
( 
    STRUCT_atmVplEntry  *data
);
void atmVplEntry_nextEntry
(
    STRUCT_atmVplEntry  *data
);
unsigned atmVplEntry_build_instance
(
    STRUCT_atmVplEntry  *data,
    OIDC_T              *tmp_inst
);
BOOL atmVplEntry_installEntry
(
    STRUCT_atmVplEntry 	*data
);
int atmVclEntry_lookup
(
    int                 compc,
    OIDC_T              *compl,
    STRUCT_atmVclEntry  *data
);
void atmVclEntry_firstEntry
(
    int                 *pPvc,
    STRUCT_atmVclEntry  *data
);
void atmVclEntry_nextEntry
(
    int                 *pPvc,
    STRUCT_atmVclEntry  *data
);
unsigned atmVclEntry_build_instance
(
    STRUCT_atmVclEntry  *data,
    OIDC_T              *tmp_inst
);
BOOL atmVclEntry_installEntry
(
    MIB_ATM_VCL_ENTRY   *data
);
int atmVpCrossConnectEntry_lookup
(
    int                          	compc,
    OIDC_T                          *compl,
    STRUCT_atmVpCrossConnectEntry   *data
);
void atmVpCrossConnectEntry_firstEntry
(
    STRUCT_atmVpCrossConnectEntry 	*data
);
void atmVpCrossConnectEntry_nextEntry
(
    STRUCT_atmVpCrossConnectEntry  	*data
);
unsigned atmVpCrossConnectEntry_build_instance
(
    STRUCT_atmVpCrossConnectEntry  	*data,
    OIDC_T              			*tmp_inst
);
BOOL atmVpCrossConnectEntry_installEntry
(
    STRUCT_atmVpCrossConnectEntry 	*data
);
int atmVcCrossConnectEntry_lookup
(
    int                             compc,
    OIDC_T                          *compl,
    STRUCT_atmVcCrossConnectEntry   *data
);
void atmVcCrossConnectEntry_firstEntry
(
    STRUCT_atmVcCrossConnectEntry  	*data
);
void atmVcCrossConnectEntry_nextEntry
(
    STRUCT_atmVcCrossConnectEntry  	*data
);
unsigned atmVcCrossConnectEntry_build_instance
(
    STRUCT_atmVcCrossConnectEntry  	*data,
    OIDC_T              			*tmp_inst
);
BOOL atmVcCrossConnectEntry_installEntry
(
    STRUCT_atmVcCrossConnectEntry 	*data
);
int aal5VccEntry_lookup
(
    int                     compc,
    OIDC_T                  *compl,
    STRUCT_aal5VccEntry  	*data
);
void aal5VccEntry_firstEntry
(
    int                 	*pPvc,
    STRUCT_aal5VccEntry  	*data
);
void aal5VccEntry_nextEntry
(
    int                 	*pPvc,
    STRUCT_aal5VccEntry  	*data
);
unsigned aal5VccEntry_build_instance
(
    STRUCT_aal5VccEntry  	*data,
    OIDC_T              	*tmp_inst
);
BOOL aal5VccEntry_installEntry
(
    STRUCT_aal5VccEntry 	*data
);
void atmMIBObjects_installEntry
(
    STRUCT_atmMIBObjects 	*data
);


#ifdef __cplusplus
}
#endif

#endif /* _RFC1695_SUB_H_ */
/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: rfc1695_sub.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.1   Nov 09 2001 11:44:58   liniy
 * Added new function prototypes from rfc1695_sub.c.
 * 
 *    Rev 1.0   Nov 06 2001 16:00:58   liniy
 *  
 * 
 *=========================================================================+
 */
