/*       
 *=========================================================================+
 *
 * Module:      rfc2662_sub.h - ADSL SNMP MIB handler header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/rfc2662_sub.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This header file contains definitions used by ADSL SNMP
 *              mib handlers (rfc2662_stub.c) and supporting subroutines
 *              (rfc2662_sub.c).
 * 
 *=========================================================================+
 */

#ifndef _RFC2662_SUB_H_
#define _RFC2662_SUB_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "snmpapi.h"
#include "snmpapi_adsl.h"   // for ADSL SNMP API based on RFC2662

//#define SNMP_RFC2662_DEBUG  1

#define STRUCT_adslLineEntry                    MIB_ADSL_LINE_ENTRY
#define STRUCT_adslAtucPhysEntry                MIB_ADSL_ATUC_PHYS_ENTRY
#define STRUCT_adslAturPhysEntry                MIB_ADSL_ATUR_PHYS_ENTRY
#define STRUCT_adslAtucChanEntry                MIB_ADSL_ATUC_CHAN_ENTRY
#define STRUCT_adslAturChanEntry                MIB_ADSL_ATUR_CHAN_ENTRY
#define STRUCT_adslAtucPerfDataEntry            MIB_ADSL_ATUC_PERF_DATA_ENTRY
#define STRUCT_adslAturPerfDataEntry            MIB_ADSL_ATUR_PERF_DATA_ENTRY
#define STRUCT_adslAtucIntervalEntry            MIB_ADSL_ATUC_INTERVAL_ENTRY
#define STRUCT_adslAturIntervalEntry            MIB_ADSL_ATUR_INTERVAL_ENTRY
#define STRUCT_adslAtucChanPerfDataEntry        MIB_ADSL_ATUC_CHAN_PERF_DATA_ENTRY
#define STRUCT_adslAturChanPerfDataEntry        MIB_ADSL_ATUR_CHAN_PERF_DATA_ENTRY
#define STRUCT_adslAtucChanIntervalEntry        MIB_ADSL_ATUC_CHAN_INTERVAL_ENTRY
#define STRUCT_adslAturChanIntervalEntry        MIB_ADSL_ATUR_CHAN_INTERVAL_ENTRY
#define STRUCT_adslLineConfProfileEntry         MIB_ADSL_LINE_CONF_PROFILE_ENTRY
#define STRUCT_adslLineAlarmConfProfileEntry    MIB_ADSL_LINE_ALARM_CONF_PROFILE_ENTRY


int adslLineEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslLineEntry *data	
);
void adslLineEntry_firstEntry
( 
    STRUCT_adslLineEntry    *data
);
void adslLineEntry_nextEntry
( 
    STRUCT_adslLineEntry    *data
);
unsigned adslLineEntry_build_instance
(
    STRUCT_adslLineEntry            *data, 
    OIDC_T                          *tmp_inst
);
BOOL adslLineEntry_installEntry
( 
    STRUCT_adslLineEntry  *data 
);
int adslAtucPhysEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucPhysEntry *data
);
void adslAtucPhysEntry_firstEntry
( 
    STRUCT_adslAtucPhysEntry        *data
);
void adslAtucPhysEntry_nextEntry
( 
    STRUCT_adslAtucPhysEntry        *data
);
unsigned adslAtucPhysEntry_build_instance
(
    STRUCT_adslAtucPhysEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslAtucPhysEntry_installEntry
( 
    STRUCT_adslAtucPhysEntry  *data 
);
int adslAturPhysEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturPhysEntry *data
);
void adslAturPhysEntry_firstEntry
( 
    STRUCT_adslAturPhysEntry        *data
);
void adslAturPhysEntry_nextEntry
( 
    STRUCT_adslAturPhysEntry        *data
);
unsigned adslAturPhysEntry_build_instance
(
    STRUCT_adslAturPhysEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslAturPhysEntry_installEntry
( 
    STRUCT_adslAturPhysEntry  *data 
);
int adslAtucChanEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucChanEntry *data
);
void adslAtucChanEntry_firstEntry
( 
    STRUCT_adslAtucChanEntry        *data
);
void adslAtucChanEntry_nextEntry
( 
    STRUCT_adslAtucChanEntry        *data
);
unsigned adslAtucChanEntry_build_instance
(
    STRUCT_adslAtucChanEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslAtucChanEntry_installEntry
( 
    STRUCT_adslAtucChanEntry  *data 
);
int adslAturChanEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturChanEntry *data
);
void adslAturChanEntry_firstEntry
( 
    STRUCT_adslAturChanEntry        *data
);
void adslAturChanEntry_nextEntry
( 
    STRUCT_adslAturChanEntry        *data
);
unsigned adslAturChanEntry_build_instance
(
    STRUCT_adslAturChanEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslAturChanEntry_installEntry
( 
    STRUCT_adslAturChanEntry  *data 
);
int adslAtucPerfDataEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucPerfDataEntry *data
);
void adslAtucPerfDataEntry_firstEntry
( 
    STRUCT_adslAtucPerfDataEntry    *data
);
void adslAtucPerfDataEntry_nextEntry
( 
    STRUCT_adslAtucPerfDataEntry    *data
);
unsigned adslAtucPerfDataEntry_build_instance
(
    STRUCT_adslAtucPerfDataEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslAtucPerfDataEntry_installEntry
( 
    STRUCT_adslAtucPerfDataEntry  *data 
);
int adslAturPerfDataEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturPerfDataEntry *data
);
void adslAturPerfDataEntry_firstEntry
( 
    STRUCT_adslAturPerfDataEntry    *data
);
void adslAturPerfDataEntry_nextEntry
( 
    STRUCT_adslAturPerfDataEntry    *data
);
unsigned adslAturPerfDataEntry_build_instance
(
    STRUCT_adslAturPerfDataEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslAturPerfDataEntry_installEntry
( 
    STRUCT_adslAturPerfDataEntry  *data 
);
int adslAtucIntervalEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucIntervalEntry *data
);
void adslAtucIntervalEntry_firstEntry
( 
    STRUCT_adslAtucIntervalEntry    *data
);
void adslAtucIntervalEntry_nextEntry
( 
    STRUCT_adslAtucIntervalEntry    *data
);
unsigned adslAtucIntervalEntry_build_instance
(
    STRUCT_adslAtucIntervalEntry    *data, 
    OIDC_T                          *tmp_inst
);
BOOL adslAtucIntervalEntry_installEntry
( 
    STRUCT_adslAtucIntervalEntry    *data 
);
int adslAturIntervalEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturIntervalEntry *data
);
void adslAturIntervalEntry_firstEntry
( 
    STRUCT_adslAturIntervalEntry    *data
);
void adslAturIntervalEntry_nextEntry
( 
    STRUCT_adslAturIntervalEntry    *data
);
unsigned adslAturIntervalEntry_build_instance
(
    STRUCT_adslAturIntervalEntry    *data, 
    OIDC_T                          *tmp_inst 
);
BOOL adslAturIntervalEntry_installEntry
( 
    STRUCT_adslAturIntervalEntry    *data 
);
int adslAtucChanPerfDataEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucChanPerfDataEntry *data
);
void adslAtucChanPerfDataEntry_firstEntry
( 
    STRUCT_adslAtucChanPerfDataEntry    *data
);
void adslAtucChanPerfDataEntry_nextEntry
( 
    STRUCT_adslAtucChanPerfDataEntry    *data
);
unsigned adslAtucChanPerfDataEntry_build_instance
(
    STRUCT_adslAtucChanPerfDataEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslAtucChanPerfDataEntry_installEntry
( 
    STRUCT_adslAtucChanPerfDataEntry  *data 
);
int adslAturChanPerfDataEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturChanPerfDataEntry *data
);
void adslAturChanPerfDataEntry_firstEntry
( 
    STRUCT_adslAturChanPerfDataEntry    *data
);
void adslAturChanPerfDataEntry_nextEntry
( 
    STRUCT_adslAturChanPerfDataEntry    *data
);
unsigned adslAturChanPerfDataEntry_build_instance
(
    STRUCT_adslAturChanPerfDataEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslAturChanPerfDataEntry_installEntry
( 
    STRUCT_adslAturChanPerfDataEntry  *data 
);
int adslAtucChanIntervalEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAtucChanIntervalEntry *data
);
void adslAtucChanIntervalEntry_firstEntry
( 
    STRUCT_adslAtucChanIntervalEntry    *data
);
void adslAtucChanIntervalEntry_nextEntry
( 
    STRUCT_adslAtucChanIntervalEntry    *data
);
unsigned adslAtucChanIntervalEntry_build_instance
(
    STRUCT_adslAtucChanIntervalEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslAtucChanIntervalEntry_installEntry
( 
    STRUCT_adslAtucChanIntervalEntry  *data 
);
int adslAturChanIntervalEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslAturChanIntervalEntry *data
);
void adslAturChanIntervalEntry_firstEntry
( 
    STRUCT_adslAturChanIntervalEntry    *data
);
void adslAturChanIntervalEntry_nextEntry
( 
    STRUCT_adslAturChanIntervalEntry    *data
);
unsigned adslAturChanIntervalEntry_build_instance
(
    STRUCT_adslAturChanIntervalEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslAturChanIntervalEntry_installEntry
( 
    STRUCT_adslAturChanIntervalEntry  *data 
);
int adslLineConfProfileEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslLineConfProfileEntry *data
);
void adslLineConfProfileEntry_firstEntry
( 
    STRUCT_adslLineConfProfileEntry     *data
);
void adslLineConfProfileEntry_nextEntry
( 
    STRUCT_adslLineConfProfileEntry     *data
);
unsigned adslLineConfProfileEntry_build_instance
(
    STRUCT_adslLineConfProfileEntry  *data, 
    OIDC_T              *tmp_inst
);
BOOL adslLineConfProfileEntry_installEntry
( 
    STRUCT_adslLineConfProfileEntry  *data 
);
int adslLineAlarmConfProfileEntry_lookup
(
    int compc, 
    OIDC_T *compl, 
    STRUCT_adslLineAlarmConfProfileEntry *data
);
void adslLineAlarmConfProfileEntry_firstEntry
( 
    STRUCT_adslLineAlarmConfProfileEntry    *data
);
void adslLineAlarmConfProfileEntry_nextEntry
( 
    STRUCT_adslLineAlarmConfProfileEntry    *data
);
unsigned adslLineAlarmConfProfileEntry_build_instance
(
    STRUCT_adslLineAlarmConfProfileEntry  *data, 
    OIDC_T              *tmp_inst 
);
BOOL adslLineAlarmConfProfileEntry_installEntry
( 
    STRUCT_adslLineAlarmConfProfileEntry  *data 
);


#ifdef __cplusplus
}
#endif

#endif /* _RFC2662_SUB_H_ */
/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: rfc2662_sub.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:59  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.1   Nov 09 2001 11:46:54   liniy
 * Updated function prototypes as defined in rfc2662_sub.c.
 * 
 *    Rev 1.0   Nov 06 2001 16:01:00   liniy
 *  
 * 
 *=========================================================================+
 */
