/*****************************************************************************
;
;    Project : Common plateform
;    Creator :
;    File    : sntp_cfg.h
;    Abstract: define the data structure for the file sntp_cfg.c
;
;
;Modification History:
;       By              Date     Ver.   Modification Description
;       --------------- -------- -----  --------------------------------------
;
;*****************************************************************************/
#if __cplusplus
extern "C" {
#endif

#ifndef SNTP_CFG_H
#define SNTP_CFG_H

#include "bspcfg.h"

#include "coretype.h"
#include "prd_cfg.h"


enum	SNTP_TIME_ZONE
{
	TIME_ZONE_ENEWETAK_KWAJALEIN,	/* -12 for GMT */
	TIME_ZONE_MIDWAY_ISLAND,	/* -11 for GMT */
	TIME_ZONE_HAWAII,		/* -10 for GMT */
	TIME_ZONE_ALASKA,		/* -9 for GMT */
	TIME_ZONE_PACIFIC,		/* -8 for GMT */
	TIME_ZONE_ARIZONA,		/* -7 for GMT */
	TIME_ZONE_MOUNTAIN,		/* -7 for GMT */
	TIME_ZONE_CENTRAL,		/* -6 for GMT */
	TIME_ZONE_MEXICO_CITY,		/* -6 for GMT */
	TIME_ZONE_SASKATCHEWAN,		/* -6 for GMT */
	TIME_ZONE_BOGOTA,		/* -5 for GMT */
	TIME_ZONE_EASTERN,		/* -5 for GMT */
	TIME_ZONE_INDIANA,		/* -5 for GMT */
	TIME_ZONE_ATLANTIC,		/* -4 for GMT */
	TIME_ZONE_CARACAS,		/* -4 for GMT */
	TIME_ZONE_SANTIAGO,		/* -4 for GMT */
	TIME_ZONE_NEWFOUNDLAND,		/* -3 for GMT */
	TIME_ZONE_BRASILIA,		/* -3 for GMT */
	TIME_ZONE_BUENOS,		/* -3 for GMT */
	TIME_ZONE_MID_ATLANTIC,		/* -2 for GMT */
	TIME_ZONE_AZORES,		/* -1 for GMT */
	TIME_ZONE_CASABLANCA,		/* 0 for GMT */
	TIME_ZONE_GREENWICH_MEAN_TIME_DUBLIN,	/* 0 for GMT */
	TIME_ZONE_GREENWICH_MEAN_TIME_LISBON,	/* 0 for GMT */
	TIME_ZONE_AMSTERDAM,		/* +1 for GMT */
	TIME_ZONE_STOCKHOIM,		/* +1 for GMT */
	TIME_ZONE_BRATISLAVA,		/* +1 for GMT */
	TIME_ZONE_PRAGUE,		/* +1 for GMT */
	TIME_ZONE_PARIS,		/* +1 for GMT */
	TIME_ZONE_SOFIJA,		/* +1 for GMT */
	TIME_ZONE_ATHENS,		/* +2 for GMT */
	TIME_ZONE_BUCHAREST,		/* +2 for GMT */
	TIME_ZONE_CAIRO,		/* +2 for GMT */
	TIME_ZONE_HARARE,		/* +2 for GMT */
	TIME_ZONE_HELSINKI,		/* +2 for GMT */
	TIME_ZONE_ISRAEL,		/* +2 for GMT */
	TIME_ZONE_BAGHDAD,		/* +3 for GMT */
	TIME_ZONE_MOSCOW,		/* +3 for GMT */
	TIME_ZONE_TEHRAN,		/* +3 for GMT */
	TIME_ZONE_ABU_DHABI,		/* +4 for GMT */
	TIME_ZONE_VOGOGRAD,		/* +4 for GMT */
	TIME_ZONE_ISLAMABAD,		/* +5 for GMT */
	TIME_ZONE_ALMATY,		/* +6 for GMT */
	TIME_ZONE_BANGKOK,		/* +7 for GMT */
	TIME_ZONE_BEIJING,		/* +8 for GMT */
	TIME_ZONE_TAIPEI,		/* +8 for GMT */
	TIME_ZONE_TOKYO,		/* +9 for GMT */
	TIME_ZONE_BRISBANE,		/* +10 for GMT */
	TIME_ZONE_CANBERRA,		/* +10 for GMT */
	TIME_ZONE_GUAM,			/* +10 for GMT */
	TIME_ZONE_HOBART,		/* +10 for GMT */
	TIME_ZONE_MAGADAN,		/* +11 for GMT */
	TIME_ZONE_FIJI,			/* +12 for GMT */
	TIME_ZONE_WELLINGTON,		/* +12 for GMT */
	TIME_ZONE_END
};

#define TIME_SERVER_MAX     6

typedef STRUCT SNTP_CFG_S
{
    UI32_T	timezone;
    ULONG   DaySaving;  /* Daylight Saving Time flag */
    ULONG   timeserver;
    UINT32  timeserver_ip;
    UINT32  Timeout;
} SNTP_CFG_T;



#define SNTP_CFG_TZ_DEFAULT			TIME_ZONE_PACIFIC
#define SNTP_CFG_DS_DEFAULT			NO
#define SNTP_CFG_TS_DEFAULT			1
#define SNTP_CFG_TIMEOUT_DEFAULT	(30 * 60)			/* sec */ 


enum    SNTP_CFG_ERROR_CODE_E
{
    SNTP_CFG_NO_ERROR = 0,
    SNTP_CFG_INVALID_TIMEZONE,
    SNTP_CFG_INVALID_DAYSAVE,
    SNTP_CFG_INVALID_TIMESERVER
};


/*------------------------------------------------------*/
/*  definitions                                         */
/*------------------------------------------------------*/
UI32_T sntp_cfg_TimeZone(void);
UI32_T sntp_cfg_SetTimeZone(UI32_T timezone);
UI32_T sntp_cfg_DaySave(void);
UI32_T sntp_cfg_SetDaySave(int daysave);
UI32_T sntp_cfg_TimeServer(void);
UI32_T sntp_cfg_SetTimeServer(int timeserver);
UI32_T sntp_cfg_TimeServer_IP(void);
void   sntp_cfg_SetTimeServer_IP(UI32_T timeserver);
UI32_T sntp_cfg_Timeout();

BOOL
SntpClientSave
(
	char*	pRegPath
);

BOOL
SntpClientCreateDefault
(
);

BOOL 
SntpClientModuleInit
(
);

#endif

#if __cplusplus
}
#endif
