/****************************************************************************
****    Copyright (c) 2001
****    Conexant Systems Inc. (formerly Rockwell Semiconductor Systems)
****    Personal Computing Division
****    All Rights Reserved
****
****    CONFIDENTIAL and PROPRIETARY --
****        No Dissemination or use without prior written permission.
****
*****************************************************************************
MODULE NAME:
        Network Address Port Translation

FILE NAME:
        dns_proxy.h

ABSTRACT:

DETAILS:

KEYWORDS:
        $Archive:   P:/d874/hasbani/archives/dns_proxy_h/dns_proxy.h_v  $
        $Revision: 1.1.1.1 $
        $Date: 2004/04/01 09:10:01 $
****************************************************************************/
#if __cplusplus
extern "C" {
#endif


#ifndef DNS_PROXY_H
#define DNS_PROXY_H

#define DNS_PROXY_DNS_USERDEFINED   1
#define DNS_PROXY_DNS_AUTODISCOVERY 2


void DNS_PROXY_Start(void);
void DNS_PROXY_Stop(void);

void DNS_PROXY_DnsClean(void);

STATUS DNS_PROXY_DnsAdd(unsigned long new_dns_ip, char *pIfName, UINT32 dns_source);
STATUS DNS_PROXY_DnsDelete(unsigned long old_dns_ip);
STATUS DNS_PROXY_IfAdd(char *if_name, UINT32 dns_source_config);
STATUS DNS_PROXY_IfDelete(char *if_name);

#ifdef DNS_PROXY_DEBUG
int dnsShow(void);
#endif /* DNS_PROXY_DEBUG */

#if (0)	// JVIS: TBD: Remove once tested.

int OEMWEBREDIRECT_Current_Mode( void );

typedef enum { WEBREDIRECT_MODE, BRIDGE_DETECT_MODE, FORCE_BRIDGE_MODE } WebRedirectMode;

/*
 Normal         := It is not a WEB_REDIRECT specific mode.
 WEBREDIRECT        := Normal WebRedirect support with DHCPS/NAT/PPP0E
 BRIDGE_DETECT  := Boot detect DHCPS on the subnet, force PPP0E down.
 FORCE_BRIDGE   := User force bridge mode on WebRedirect.

*/

#endif /* (0) */ 

#endif /* DNS_PROXY_H */


#if __cplusplus
}
#endif
