/*
  This is for multi-dhcpclients for multi-Ends, but, per Ends, per dhcp clients only.
  Note, for multi-dhcpclients with samesubnet, must process arp manually, and cannot depend on OS's 
  IP statck.
*/
#include "vxworks.h"
#include "stdio.h"
#include "stdlib.h"
#include "dhcp/dhcp.h"
#include "taskLib.h"
#include "syslib.h"

#include "ticklib.h"
#include "xxxprotocol.h"
#include "xxxmiscu.h"
#include "xxxnetwork.h"
#include "xxxmempool.h"

#include "oneonenatconstant.h"
#include "dhcpclients.h"
#include "muxlibex.h"

#ifdef WAN_SUPPORT_DHCP

//#define DHCPCLIENT_DEBUG

static DhcpClients DhcpclientsMgr; //DhcpclientsArray

#define RELEASE_IF_REASETIME_OVER

//export 
BOOL InitDhcpClient();
BOOL StartDhcpClient(char *EndName, int EndUnit );
void ReleaseDhcpClient( int Unit, BOOL bfGatewaydownOrLeasetimeover );


#define DHCPCLEINT_RESOURCE_STATUS_NOTUSED         0 /*MUST BE ZERO */
#define DHCPCLEINT_RESOURCE_STATUS_OK 		1 
#define DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE 2
#define DHCPCLEINT_RESOURCE_STATUS_FREEING      3

#define MEM_ALIGN_BYTES 4 
/*Note, if DHCP get/release a ip successfully, it will call outside function:
	DhcpClientGetIP_Notify:
	DhcpClientIPFree_Notify:
*/
extern BOOL DhcpClientGetIP_Notify(char *EndName, int unit, 
		ULONG clientIP, ULONG ServerIP/*no need */, ULONG routerIP, ULONG mask, ULONG priDNSIP, ULONG secDNSIP )
;

extern BOOL DhcpClientIPFree_Notify(char *EndName, int unit, BOOL bfGatewaydownOrLeasetimeover ); //after dhcpclient timout an ip, call it



//import functions:
extern char * pickup_opt (struct dhcp *, int, char);

#ifdef SUPPORT_ARP_MANUAL	
extern BOOL UpdateArpTable( ULONG IP/*input*/, char *Mac/*input*/);
extern BOOL SearchArpTable( ULONG IP/*input*/, char *Mac/*output*/);
extern void InitArpmanager();
#endif

/*Local functions */
static BOOL DhcpClientRecvHook( void * pCookie,  long type,  M_BLK_ID pMblk, LL_HDR_INFO * pLinkHdrInfo, void *pSpare);
static void DHCPClientTask(int EndUnit);
static void DHCPClientsManager();
static void CheckGatewayManager();

BOOL InitDhcpClient()
{
	int i;
	memset( &DhcpclientsMgr, 0, sizeof(DhcpclientsMgr) );

	DhcpclientsMgr.IP_IdentifyID = 100;
	DhcpclientsMgr.DHCPClientsManagerID = 0;
	DhcpclientsMgr.bfDhcpCInitOK = FALSE;
	
	DhcpclientsMgr.DHCPClientsManagerID = taskSpawn("tDHCPCMgr",200,0,10240,(FUNCPTR)DHCPClientsManager,0,1,2,3,4,5,6,7,8,9);
	if( DhcpclientsMgr.DHCPClientsManagerID == ERROR) 
	{
		printf("InitDhcpClient: taskSpawn fail\r\n");
		return FALSE;
	}	
	DhcpclientsMgr.CheckGatewayID = taskSpawn("tDHCPCMgr",200,0,10240,(FUNCPTR)CheckGatewayManager,0,1,2,3,4,5,6,7,8,9);
	if( DhcpclientsMgr.CheckGatewayID == ERROR) 
	{
		printf("InitDhcpClient: taskSpawn fail 2\r\n");
		return FALSE;
	}	

	for( i=0; i< MAX_DHCP_CLIENTS; i++)
	{
		DhcpclientsMgr.bfUsed[i] = DHCPCLEINT_RESOURCE_STATUS_NOTUSED;
		DhcpclientsMgr.pCookie[i] = NULL;
		DhcpclientsMgr.PrivateSemID[i] = semBCreate(SEM_Q_FIFO, SEM_FULL);
		if( DhcpclientsMgr.PrivateSemID[i] == NULL )
		{
			printf("sembcreate error 2 in InitDhcpClient\r\n");
			return FALSE;
		}
	}	

#ifdef SUPPORT_ARP_MANUAL	
	InitArpmanager( );
#endif
		
	DhcpclientsMgr.bfDhcpCInitOK = TRUE;

	return TRUE;
}

M_BLK_ID CreateDHCPClientPacket(int EndUnit, u_char type)
{	
	DHCP *pDhcp = NULL;
	UDP  *pUdp = NULL;
	IP	  *pIp = NULL;
	char s[10]={0};
	short len;
	M_BLK_ID pMblk = NULL;
	int optionLen;

	len = 1500;
	pMblk = np17mMblkGet(len);
	if( pMblk == NULL) 
	{
		printf("CreateDHCPClientPacket: np17mMblkGet NULL \r\n");
		return NULL;
	}	
	memset( pMblk->mBlkHdr.mData, 0, len);
	pMblk->mBlkHdr.mData = &pMblk->mBlkHdr.mData[2]; //mem align
			
	pIp = (IP * )&pMblk->mBlkHdr.mData[14];
	pUdp = (UDP *)&pMblk->mBlkHdr.mData[14+20];
	pDhcp = (DHCP *)&pMblk->mBlkHdr.mData[14+20+8]; 

	//mac header
	if( type == DHCPDISCOVER ) 
		memcpy( &pMblk->mBlkHdr.mData[0], BROADCAST_HW_ADDR, 6);
	else
		memcpy( &pMblk->mBlkHdr.mData[0], DhcpclientsMgr.DhcpEntry[EndUnit].ServerMac, 6);

	memcpy( &pMblk->mBlkHdr.mData[6], DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 6);
	pMblk->mBlkHdr.mData[12] = 0x08; pMblk->mBlkHdr.mData[13] = 0x00;

	//printf("begin dhcp option\r\n"); taskDelay(1);

	/*fill dhcp and its option */
	pDhcp->Op = 1;	   /*1-request 2- reply*/
	pDhcp->HType = 1;
	pDhcp->HLen = HWLEN;
	pDhcp->Hops = 0;	 /*need to check */

	pDhcp->TransactionID = htonl( DhcpclientsMgr.DhcpEntry[EndUnit].transactionID  );
	pDhcp->seconds = htons(0);
	pDhcp->Flags = htons( 0 ); /*0 */
	memcpy(pDhcp->ClientHw,	DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 6);

	if( DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev != DHCP_STATE_REQUESTOK )
		memcpy( &pDhcp->ClientIP, ZERO_IP_ADDR, 4);
	else 
		memcpy( &pDhcp->ClientIP, &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 4);

	//Begin dhcp option. First is Vendor information
	optionLen = 0;
#if 0
	memcpy( &pDhcp->options[0], "cpx ", 4);
#else //??? It seems it must use this value
	pDhcp->options[0]=0x63; pDhcp->options[1]=0x82; pDhcp->options[2]=0x53; pDhcp->options[3]=0x63;
#endif
	optionLen = 4;

	//dhcp option: MSG TYPE
	pDhcp->options[4] = _DHCP_MSGTYPE_TAG;
	pDhcp->options[5] = 1;
	pDhcp->options[6] = type;
	optionLen += 3;
	
	//dhcp option: reserved
	pDhcp->options[optionLen ] = 0xfb;
	pDhcp->options[optionLen + 1] = 1;
	pDhcp->options[optionLen + 2] = 1;
	optionLen += pDhcp->options[optionLen + 1] +2;;

	//dhcp option: client ID ( use mac as its main ID )
	pDhcp->options[optionLen ] = _DHCP_CLIENT_ID_TAG;
	pDhcp->options[optionLen + 1] = 7;
	pDhcp->options[optionLen + 2] = 1;
	memcpy( &pDhcp->options[optionLen + 3], DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 6);
	optionLen += pDhcp->options[optionLen + 1] +2;;

	//dhcp option: request ip if dhcp ip hasnot been bound
	if( DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev != DHCP_STATE_REQUESTOK)
	{
		pDhcp->options[optionLen ] = _DHCP_REQUEST_IPADDR_TAG;
		pDhcp->options[optionLen + 1] = 4;
		
		memcpy( &pDhcp->options[optionLen + 2], &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 4);
		optionLen += pDhcp->options[optionLen + 1] + 2;
	}

	//dhcp option: hostname
	pDhcp->options[optionLen ] = _DHCP_HOSTNAME_TAG;
	sprintf(s, "sgh%d", DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit);
	pDhcp->options[optionLen + 1] = strlen(s);
	memcpy( &pDhcp->options[optionLen + 2], s, strlen(s));
	optionLen += pDhcp->options[optionLen + 1] +2;;


	//dhcp option: class ID. Maybe no use. 
	{
		char classID[]={ 0x4d, 0x53, 0x46, 0x54, 0x20, 0x39, 0x38};
		pDhcp->options[optionLen ] = _DHCP_CLASS_ID_TAG;
		pDhcp->options[optionLen + 1] = sizeof(classID);			
		memcpy( &pDhcp->options[optionLen + 2], classID, 8);
		optionLen += pDhcp->options[optionLen + 1] +2;
	}
		
	//dhcp option: paramenter request list
	pDhcp->options[optionLen ] = _DHCP_REQ_LIST_TAG;
	pDhcp->options[optionLen + 1] = 10;
	pDhcp->options[optionLen + 2] = 0x1; //subnet
	pDhcp->options[optionLen + 3] = 0xf; //domain
	pDhcp->options[optionLen + 4] = 0x3; //router on the subnet
	pDhcp->options[optionLen + 5] = 0x6; //domain name server
	pDhcp->options[optionLen + 6] = 0x2c; //netbios over tcp/ip name servers
	pDhcp->options[optionLen + 7] = 0x2e; //netbios over tcp/ip node type
	pDhcp->options[optionLen + 8] = 0x2f; //netbios over tcp/ip scope
	pDhcp->options[optionLen + 9] = 0x1f; //perform routine discovery
	pDhcp->options[optionLen + 10] = 0x21; //static router
	pDhcp->options[optionLen + 11] = 0x2b; //vendor info	
	optionLen += pDhcp->options[optionLen + 1] +2;
	
	pDhcp->options[optionLen] = 0xff; // List End 
	optionLen ++;
	

    //   mac  ip  udp   dhcp
	len = 14 + 20 + 8 +     sizeof(DHCP)  - sizeof( pDhcp->options ) + optionLen;
	//printf("begin len = %d\r\n", len); taskDelay(1);

	//redefine the Mblk len
	pMblk->mBlkHdr.mLen = len;
	pMblk->mBlkPktHdr.len = len;

	//printf("begin ip\r\n"); taskDelay(1);
	//ip header
	pIp->ip_v = 4;
	pIp->ip_hl = (u_char) ((4 << 4) + 5 ); /*Only 20 bytes header */
	pIp->ip_tos = IP_NORMAL;

	pIp->ip_len = htons( (unsigned short) (len) - 14 );
		
	pIp->ip_id = htons(DhcpclientsMgr.IP_IdentifyID ++);
	pIp->ip_off = htons( 0 );
	pIp->ip_ttl = IP_TTL1 ;
	pIp->ip_p = 17; /*17 - uDP */	
	pIp->ip_sum = 0;

	if( DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev != DHCP_STATE_REQUESTOK )
		memcpy( &pIp->ip_src, &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 4 ); 
	else
		memcpy( &pIp->ip_src, ZERO_IP_ADDR, 4 ); 
	
	if( type == DHCPDISCOVER )
		memcpy( &pIp->ip_dst, BROADCAST_IP_ADDR, 4);
	else if( DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP != 0 )
		memcpy( &pIp->ip_dst, &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP ,4);
	else memcpy( &pIp->ip_dst, BROADCAST_IP_ADDR, 4);

	//printf("begin udp\r\n"); taskDelay(1);
	//udp
	pUdp->src_port = htons( 68 );
	pUdp->dst_port = htons( 67 );
	pUdp->len = htons ( (unsigned short) (len) - 14 - 20 ); // 20 bytes ip header
	
	Cal_Checksum_UDP(pIp);
	Cal_Checksum_IP(pIp);

#if 0	
	printf("SendDataViaCookie[%d]=%p ", EndUnit, DhcpclientsMgr.pCookie[EndUnit]); 
	ShortMemDumpXX(pMblk->mBlkHdr.mData, 14);
	printf("\r\n");
	taskDelay(3);	
#endif

	return pMblk;	

}


/*apply with fix ip to server */
M_BLK_ID CreateDHCPClientPacketDiscover(int EndUnit)
{	
	DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent = DHCP_STATE_DISCOVERING;
	return( CreateDHCPClientPacket( EndUnit, DHCPDISCOVER) );
}

M_BLK_ID CreateDHCPClientPacketRequest(int EndUnit)
{	
	DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent = DHCP_STATE_REQUESTING;
	return( CreateDHCPClientPacket( EndUnit, DHCPREQUEST) );
}

M_BLK_ID CreateDHCPClientPacketRelease(int EndUnit)
{
	DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent = DHCP_STATE_REQUESTING;
	return( CreateDHCPClientPacket( EndUnit, DHCPRELEASE) );
}

M_BLK_ID CreateDHCPClientPacketDeny(int EndUnit)
{
	DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent = DHCP_STATE_REQUESTING;
	return( CreateDHCPClientPacket( EndUnit, DHCPNACK) );
}


void ReleaseDhcpClient( int Unit, BOOL bfGatewaydownOrLeasetimeover )
{
	if( !DhcpclientsMgr.bfDhcpCInitOK || Unit < 0 || Unit >= MAX_DHCP_CLIENTS ) 
	{
		printf("ReleaseDhcpClient fail: index(%d) error\r\n", Unit );
		return ;
	}

	if( semTake( DhcpclientsMgr.PrivateSemID[Unit], WAIT_FOREVER) == ERROR )
	{
		printf("semTake error in ReleaseDhcpClient: %d\r\n", Unit );
		return ;
	}
	
	if( DhcpclientsMgr.bfUsed[Unit] >= DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE) 
	{ /*already prepare releaseing */
		semGive( DhcpclientsMgr.PrivateSemID[Unit] );
		return ;
	}
	
	if( DhcpclientsMgr.bfUsed[Unit] < DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE ) 
	{
		DhcpclientsMgr.bfUsed[Unit] = DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE;
		DhcpclientsMgr.DhcpEntry[Unit].bfGatewaydownOrLeasetimeover = bfGatewaydownOrLeasetimeover;
	#ifdef DHCPCLIENT_DEBUG
		printf("Set dhcp to DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE\r\n");
	#endif
	}

	semGive( DhcpclientsMgr.PrivateSemID[Unit] );
		
}

//index: 0 ~ MAX_DHCP_CLIENTS -1: index = EndUnit
BOOL StartDhcpClient(char *EndName, int EndUnit )
{
	BOOL bfNeedReset = FALSE;
	char tmpName[20]={0};
	
	if( !DhcpclientsMgr.bfDhcpCInitOK || EndUnit < 0 || EndUnit >= MAX_DHCP_CLIENTS ) 
	{
		printf("StartDhcpClient fail: index(%d) error\r\n", EndUnit );
		return FALSE;
	}
	
	if( EndName == NULL )
	{
		printf("StartDhcpClient fail: dhcpclients's EndName error forunit %d\r\n", EndUnit );
		return FALSE;
	}

	if( semTake( DhcpclientsMgr.PrivateSemID[EndUnit], WAIT_FOREVER) == ERROR )
	{
		printf("semTake error in StartDhcpClient: %d\r\n", EndUnit );
		return FALSE;
	}

	if( strlen(EndName) >= sizeof(DhcpclientsMgr.DhcpEntry[EndUnit].EndName) - 1 ) 
	{
		semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
		printf("StartDhcpClient fail: dhcpclients's EndName too long(%s)\r\n", EndName );
		return FALSE;
	}
	
	if( DhcpclientsMgr.bfUsed[EndUnit] == DHCPCLEINT_RESOURCE_STATUS_OK ) //already muxbind a End
	{
		if( strcmp( DhcpclientsMgr.DhcpEntry[EndUnit].EndName, EndName ) != 0 ||
			DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit != EndUnit ) 
		{ //now want to bind to another interface,
			semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
			
			printf("dhcpclients error: old %s%d, new %s%d\r\n", DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit,
				  EndName, EndUnit );
			return FALSE;
		}
	}	
	else if( DhcpclientsMgr.bfUsed[EndUnit] == DHCPCLEINT_RESOURCE_STATUS_NOTUSED) //already muxbind a End
	{
		if( DhcpclientsMgr.DhcpEntry[EndUnit].taskID != (ULONG) NULL )
		{
			printf("dhcpclient's taskID none-NULL:%s%d\r\n", EndName, EndUnit );
			semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
			return FALSE;
		}
		
		bfNeedReset = TRUE;
	}
	else /*is Freeing/Releaseing the dhcp client. Deny it */
	{
		semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
		return FALSE;
	}

	if( bfNeedReset )
	{
		//reset all variant
		memset( &DhcpclientsMgr.DhcpEntry[EndUnit], 0, sizeof(DhcpclientsMgr.DhcpEntry[EndUnit]) );

		DhcpclientsMgr.bfUsed[EndUnit] = DHCPCLEINT_RESOURCE_STATUS_OK;

		DhcpclientsMgr.DhcpEntry[EndUnit].transactionID = EndUnit + 1;
		
		strcpy( DhcpclientsMgr.DhcpEntry[EndUnit].EndName, EndName );
		DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit = EndUnit;

		if( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID == NULL )
		{
			DhcpclientsMgr.DhcpEntry[EndUnit].MsgID = msgQCreate( 100, 4, MSG_Q_FIFO ); 
			if( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID == NULL )
			{
				printf("StartDhcpClient msgQCreate fail\r\n");
				goto FAIL;
			}
		}
		
		sprintf( tmpName, "dhcpc%d", EndUnit);
		if( DhcpclientsMgr.pCookie[EndUnit] == NULL )
		{
			DhcpclientsMgr.pCookie[EndUnit]= muxBindEx (EndName, EndUnit,
								DhcpClientRecvHook, NULL, NULL, NULL,
								MUX_PROTO_SNARF, tmpName, (void *)( EndUnit * MEM_ALIGN_BYTES) );
			if( DhcpclientsMgr.pCookie[EndUnit] == NULL ) 
			{
				printf("StartDhcpClient muxbind fail: %s%d\r\n", EndName, EndUnit);
				goto FAIL;
			}
		}
	#ifdef DHCPCLIENT_DEBUG	
		printf("pcookie=%p\r\n", DhcpclientsMgr.pCookie[EndUnit] );
	#endif

		if( !GetMacAddress2XXX( DhcpclientsMgr.pCookie[EndUnit], DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac ) )
		{
			printf("StartDhcpClient GetMacAddress2XXX fail: %s%d\r\n", EndName, EndUnit);
			goto FAIL;
		}
	#ifdef DHCPCLIENT_DEBUG	
		printf("%s%d mac is :", DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit);
		ShortMemDumpXX(DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 6); printf("\r\n"); 
	#endif
	

		if( DhcpclientsMgr.DhcpEntry[EndUnit].taskID == 0 || DhcpclientsMgr.DhcpEntry[EndUnit].taskID == ERROR ) 
		{
			DhcpclientsMgr.DhcpEntry[EndUnit].taskID = taskSpawn(tmpName,200,0,10240,(FUNCPTR)DHCPClientTask,EndUnit,1,2,3,4,5,6,7,8,9);
			if( DhcpclientsMgr.DhcpEntry[EndUnit].taskID == ERROR) 
			{
				printf("StartDhcpClient taskSpawn fail\r\n");
				goto FAIL;
			}
		}		
	}

	semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
	return TRUE;

FAIL:

	semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );

	ReleaseDhcpClient( EndUnit, TRUE);	
	return FALSE;
	
}

BOOL DhcpClientRecvHook( void * pCookie,  long type,  M_BLK_ID pMblk, LL_HDR_INFO * pLinkHdrInfo, void *pSpare)
{
	int EndUnit = ( (ULONG) pSpare ) / MEM_ALIGN_BYTES ;

	if( EndUnit < 0 || EndUnit >= MAX_DHCP_CLIENTS ) return FALSE;
	
	if( pMblk == NULL ) return TRUE;

	if( !DhcpclientsMgr.bfDhcpCInitOK ) return FALSE;
	
	//printf("DhcpClientRecvHook...\r\n"); 
	
	if( IsDhcpRespondPkt( pMblk->mBlkHdr.mData) )
	{
		//printf("Hook: dhpcrespond\r\n");
		goto PUT_QUEQUE;
	}
	else if( IsDhcpRequestPkt( pMblk->mBlkHdr.mData )  ) 
	{//Delete
		//printf("Hook: dhpcresquest\r\n");
		netMblkClChainFree (pMblk); 
		return TRUE;
	}	
	
#ifdef SUPPORT_ARP_MANUAL
	else if( IsArpPacket( pMblk->mBlkHdr.mData )  )
	{
		ARP *arp = (ARP *) &pMblk->mBlkHdr.mData[14];
		if( htons(arp->opcode) == 2)  //arp reply
		{
			ULONG tmpIP;
			memcpy( &tmpIP, &arp->sender_ip, 4);
			UpdateArpTable(tmpIP, arp->sender_mac);
		}			
	}
#endif	

	return FALSE;

PUT_QUEQUE:
	if( semTake( DhcpclientsMgr.PrivateSemID[EndUnit], WAIT_FOREVER) == ERROR )
	{
		printf("semTake error in DhcpClientRecvHook: %d\r\n", EndUnit );
		return FALSE ;
	}

	if( DhcpclientsMgr.bfUsed[EndUnit] == DHCPCLEINT_RESOURCE_STATUS_OK && 		
		DhcpclientsMgr.DhcpEntry[EndUnit].MsgID ) 
	{
		if( msgQSend( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID, (char *)&pMblk,4, NO_WAIT, MSG_PRI_NORMAL ) == ERROR ) 
		{//DELETE
			printf("msgQSend error\r\n");
			netMblkClChainFree (pMblk);
		}
	#ifdef DHCPCLIENT_DEBUG	
		else printf("msgQSend ok\r\n");
	#endif
	}
	else
	{   //DELETE
		netMblkClChainFree (pMblk); 
	}

	semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );
	return TRUE;

}


M_BLK_ID CreateDiscoverStatePacket(int EndUnit)
{
	DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev= DHCP_STATE_INIT;
	DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent= DHCP_STATE_DISCOVERING;
	
	DhcpclientsMgr.DhcpEntry[EndUnit].lastSendTime = tickGet();
	DhcpclientsMgr.DhcpEntry[EndUnit].nSendTimes = 1;
	memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].ServerMac, BROADCAST_HW_ADDR, 6);
	
	return CreateDHCPClientPacketDiscover( EndUnit );
}


void PrintDhcpClientInfo(int EndUnit )
{
	printf("EndName: %s%d\r\n", DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit );
	printf("EState(curr/prev): %d/%d\r\n", DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent, DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev );
		
	printf("clientIP ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, FALSE);
	printf("Mac "); ShortMemDumpXX(DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 6); printf("\r\n");
	
	printf("ServerIP ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP, FALSE );
	printf("Mac "); ShortMemDumpXX(DhcpclientsMgr.DhcpEntry[EndUnit].ServerMac, 6); printf("\r\n");
	
	printf("RouterIP ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.RouterIP, FALSE);
	printf(" SubNetMask ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.SubNetMask, TRUE);
	
	printf("Domain1IP ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain1IP, FALSE);
	printf(" Domain2IP ="); PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain2IP, TRUE);
	
	printf("Real leasetime=%lu, T1=%lu, T2 =%lu\r\n", DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime,
		DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1, DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 );
	printf("Ticks: leasetime=%lu, T1=%lu, T2 =%lu (current Ticks %lu) \r\n", DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leasetimeTicks,
		DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1Ticks, DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2Ticks, tickGet());					

}

void PrintDhcpClients(int EndUnit )
{
	int i; 
	
	for(i=0; i<MAX_DHCP_CLIENTS; i++) 
	{
		if( DhcpclientsMgr.bfUsed[i] ) 
		{
			PrintDhcpClientInfo(i);
			printf("\r\n");
		}
	}
}

void DHCPClientTask(int EndUnit)
{	
	M_BLK_ID pMblk = NULL;
	M_BLK_ID pMblk2 = NULL, pMblk3 = NULL, pArpMblk = NULL;
	char *pData = NULL;	
	IP* pIp = NULL;
	UDP* pUdp = NULL;
	DHCP * pDhcp = NULL;
	short rdhcplen = 0;
	char RespondMsg;

	char *option;
	BOOL bfResPktErr = TRUE;
	ULONG currentTicks;
	ULONG sysTickRate;
	
	ULONG oldClientIP = 0;
	BOOL bfGatewaydownOrLeasetimeover;
	char EndName[END_NAME_LEN];

	if( EndUnit < 0 || EndUnit >= MAX_DHCP_CLIENTS ) 
	{
		printf("DHCPClientTask Endunit Error: %d\r\n", EndUnit );
		return ;
	}

	if( semTake( DhcpclientsMgr.PrivateSemID[EndUnit], WAIT_FOREVER) == ERROR )
	{
		printf("semTake error in DHCPClientTask: %d\r\n", EndUnit );
		return ;
	}		   		
	pMblk2 = CreateDiscoverStatePacket(EndUnit );

	semGive( DhcpclientsMgr.PrivateSemID[EndUnit]);
	
	SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk2 );
	

#ifdef DHCPCLIENT_DEBUG
	printf("CreateDHCPClientPacketDiscover ok\r\n");
#endif

	//taskDelay(10000);
	while(1)
	{	
		/* First check all kinds of timeout: discover timeout, request timeout, arp-detect/ip-verify timeout, 
		   leasetime(T1/T2) time out and so on */
		pMblk2 = NULL; pMblk3 = NULL; pArpMblk = NULL;
		
		if( semTake( DhcpclientsMgr.PrivateSemID[EndUnit], 200) == ERROR )
		{
			printf("semTake error in DHCPClientTask: %d\r\n", EndUnit );
			continue;
		}		   
		if( DhcpclientsMgr.bfUsed[EndUnit] >= DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE ) 
		{
			goto FREE_RESOURCE;
		}
		semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );

		pMblk = NULL;
		if( msgQReceive( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID, (char *)&pMblk, 4, 30 ) != 4 ) 
		{
			//printf("dhcp task continue\r\n");
			continue;
		}
		
		pData = pMblk->mBlkHdr.mData;
		currentTicks = tickGet();

		if( !IsDhcpRespondPkt(pData) )
		{
			netMblkClChainFree (pMblk); 
			continue;
		}
		
		pIp = (IP *) &pData[14];
		pUdp = (UDP*)( ( (char *)pIp) + IP_HLEN(pIp));
		pDhcp =(DHCP*)( ( (char *) pUdp )+ UDP_HLEN );

		rdhcplen = ntohs(pUdp->len) - UDP_HLEN;
		option = pickup_opt ((struct dhcp *) pDhcp, rdhcplen, _DHCP_MSGTYPE_TAG);
		if( option == NULL )
		{
		#ifdef DHCPCLIENT_DEBUG
			printf("cannot find msgtype tag in dhcp pkt\r\n");
		#endif
			netMblkClChainFree (pMblk); 
			continue;
		}	
		option = OPTBODY(option); //pointe to dhcp type:
		RespondMsg = *option;
		
	#ifdef DHCPCLIENT_DEBUG
		printf("recv dhcp pkt: %d\r\n", RespondMsg);
	#endif
	
		if( semTake( DhcpclientsMgr.PrivateSemID[EndUnit], 200) == ERROR )
		{
			printf("semTake error in DHCPClientTask: %d\r\n", EndUnit );
			netMblkClChainFree (pMblk); 
			continue;
		}		   

		if( RespondMsg != DHCPOFFER && RespondMsg != DHCPACK && RespondMsg != DHCPNACK )
			goto FreePkt;

		if( ntohl( pDhcp->TransactionID) != DhcpclientsMgr.DhcpEntry[EndUnit].transactionID ) //check transaction id
			goto FreePkt;

		//process received packet		
		switch( DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent ) 
		{
			case DHCP_STATE_DISCOVERING:
				if( RespondMsg == DHCPOFFER )
				{
					//get IP information						
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_SERVER_ID_TAG); //in dhcp request pkt of ciaddr is zero
					if( option == NULL ) goto FreePkt;

					//record dhcpserver information
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP, OPTBODY(option), 4 );//dhcpserver ip
					memcpy( DhcpclientsMgr.DhcpEntry[EndUnit].ServerMac, &pData[6], 6 ); //dhcpserver mac

					//record client ip
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, &pDhcp->YourIP, 4); //dhcpserver ip
					
					DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev= DHCP_STATE_INIT;
					DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent= DHCP_STATE_VERIFYING_IP;
					DhcpclientsMgr.DhcpEntry[EndUnit].nSendTimes = 1;

					//Must set to 0 for now not send dhcp pkt ********
					DhcpclientsMgr.DhcpEntry[EndUnit].lastSendTime = 0; 
					{
						pArpMblk = CreateArpMblk( DhcpclientsMgr.DhcpEntry[EndUnit].ClientMac, 
											DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, BROADCAST_HW_ADDR, DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 1);						
					}

				}
				break;
		
			
			case DHCP_STATE_REQUESTING:
				
				if( RespondMsg == DHCPACK )
				{
					bfResPktErr = TRUE;
					
					//get client IP information							
					memcpy( &oldClientIP, &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 4);
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, &pDhcp->YourIP, 4);
					if( oldClientIP != DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP)
					{ //
						memcpy( &oldClientIP, &pDhcp->YourIP, 4);
						printf("ip is different with last time : " );
						PrintIP_LXX(oldClientIP, FALSE); printf(" ");
						PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, TRUE); 
						printf("\r\n");
						goto RespondError;
					}
					
					//subnet
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_SUBNET_MASK_TAG); 
					if( option == NULL ) 
					{
						printf("no dhcp server ip\r\n" );
						goto RespondError;
					}
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.SubNetMask, OPTBODY(option), 4);
						

					//dhcpserver ip
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_SERVER_ID_TAG); 
					if( option == NULL ) 
					{
						printf("no dhcp server ip\r\n" );
						goto RespondError;
					}
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP, OPTBODY(option), 4); 
					memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].ServerMac, &pData[6], 6);

					//router ip
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_ROUTER_TAG); 
					if( option != NULL ) 
					{
						memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.RouterIP, OPTBODY(option), 4); 
					}
					else DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.RouterIP = 0;
					

					//DNS1
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_DNS_SERVER_TAG); 
					if( option != NULL ) 
					{							
						if( option[1] == 4) 
						{
							option = OPTBODY(option);
							memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain1IP, option, 4 ); 
						}
						else if( option[1] >= 8) 
						{
							// 2 dns is enough
							option = OPTBODY(option);
							memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain1IP, option, 4 ); 
							memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain2IP, option + 4, 4 ); 
						}
						else 
						{
							DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain1IP = 0;
							DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain2IP = 0;
						}
					}
					
					//least time
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_LEASE_TIME_TAG); 
					if( option != NULL ) 
					{
						option = OPTBODY(option);
						memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime, option, 4);
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime = ntohl(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime);
					}
					else DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime = 60; /*one minute */
					
					//T1/T2: _DHCP_T1_TAG, _DHCP_T2_TAG
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_T1_TAG); 
					if( option != NULL ) 
					{
						option = OPTBODY(option);
						memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1, option, 4);
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 = ntohl(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1);
					}
					else 
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 = DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime/2;

					//T2
					option = pickup_opt ( (struct dhcp *)pDhcp, rdhcplen, _DHCP_T2_TAG); 
					if( option != NULL ) 
					{
						option = OPTBODY(option);
						memcpy( &DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2, option, 4);
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 = ntohl(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2);
					}
					else 
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 = DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime * 3/4;

					#ifdef DHCPCLIENT_DEBUG
						printf("leasetime=%d, T1=%d, T2 =%d Original\r\n", DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime,							
							DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1, DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 );
					#endif

					//adjust T1/T2
					if( DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 >= DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime )
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 = DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime/2;
					if( DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 <= DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 )
						DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 = DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime - 
                             ( DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1/2 ) ;
				#if 0	
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 = 10;
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 = 30;
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime = 60;
				#endif	

					sysTickRate = sysClkRateGet();
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leasetimeTicks = currentTicks + DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.leaseTime* sysTickRate;
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1Ticks= currentTicks + DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T1 * sysTickRate;
					DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2Ticks = currentTicks + DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.T2 * sysTickRate;
			

					//change state: discover -> requesting
					if( DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev == DHCP_STATE_DISCOVEROK )
					{ //first time to get dhcpACK.
					
						if( DhcpClientGetIP_Notify(DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit, 
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, 
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ServerIP, 
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.RouterIP,
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.SubNetMask,
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain1IP, 
							 DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.Domain2IP ) ) 
						{
						#ifdef DHCPCLIENT_DEBUG
							printf("DhcpClientGetIP_Notify ok %s%d: ", DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit);
							PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, FALSE );
							PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.SubNetMask, TRUE);
						#endif
							bfResPktErr = FALSE;
							DhcpclientsMgr.DhcpEntry[EndUnit].StatePrev = DHCP_STATE_REQUESTOK;
							DhcpclientsMgr.DhcpEntry[EndUnit].stateCurrent= DHCP_STATE_REQUESTOK;

						#ifdef CHECK_DHCPSERVER
							DhcpclientsMgr.DhcpEntry[EndUnit].bfAckOk = TRUE;
						#endif
						}
						else 
						{
						#ifdef DHCPCLIENT_DEBUG
							printf("DhcpClientGetIP_Notify fail %s%d: ", DhcpclientsMgr.DhcpEntry[EndUnit].EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndUnit);
							PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.ClientIP, FALSE );
							PrintIP_LXX(DhcpclientsMgr.DhcpEntry[EndUnit].BaseIPAttr.SubNetMask, TRUE);
						#endif
						}
					}
					else //already bound.ie, the pkt is for T1
						bfResPktErr = FALSE;
					

					if( bfResPktErr )
					{
						RespondError: 
							//first send deny pkt
							printf("send deny pkt\r\n");
							pMblk2 = CreateDHCPClientPacketDeny( EndUnit );

							//change to init state
							pMblk3 = CreateDiscoverStatePacket( EndUnit);
					}
				#ifdef DHCPCLIENT_DEBUG	
					else PrintDhcpClientInfo( EndUnit );
				#endif	
				}
				else if( RespondMsg == DHCPNACK )
				{ //recv NACK
					printf("recv NAK\r\n");						
					//change to init state
					pMblk2 = CreateDiscoverStatePacket(EndUnit );
				}
					
				break;
				
			default: 
				break; 
		}

		
	FreePkt:
		if( pMblk )
		{
			netMblkClChainFree (pMblk); 
			pMblk = NULL;
		}		

		if( pMblk2 )
		{
			SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk2 );
		}
		if( pMblk3 )
		{
			SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk3 );
		}

		if(pArpMblk )
		{
			SendDataViaCookie(DhcpclientsMgr.pCookie[EndUnit], pArpMblk);
		}

		semGive(DhcpclientsMgr.PrivateSemID[EndUnit]);
	}

	printf("Error if come to here in dhcpclienttask\r\n");

	return ;
	
FREE_RESOURCE:
		
	DhcpclientsMgr.bfUsed[EndUnit] = DHCPCLEINT_RESOURCE_STATUS_FREEING;
	
	pMblk2 = CreateDHCPClientPacketRelease(EndUnit);
	pMblk3 = CreateDHCPClientPacketRelease(EndUnit);

#if 0	
	if( DhcpclientsMgr.pCookie[EndUnit] != NULL )
	{
		if( muxUnbindEx(DhcpclientsMgr.pCookie[EndUnit], MUX_PROTO_SNARF, ( FUNCPTR) DhcpClientRecvHook) == ERROR )
		{
			printf("muxUnbindEx fail in ReleaseDhcpClient: index = %d\r\n", EndUnit );
		}
		DhcpclientsMgr.pCookie[EndUnit] = NULL;
	}	
#endif	
		//first free task, then free msg, sem and so on 	
		
	if( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID != NULL ) 
	{  /*free mBlks */
		while( msgQReceive( DhcpclientsMgr.DhcpEntry[EndUnit].MsgID, (char *)&pMblk, 4, NO_WAIT ) > 0 ) 
		{
			netMblkClChainFree (pMblk); 
		}
	#if 0	
		msgQDelete(DhcpclientsMgr.DhcpEntry[EndUnit].MsgID);
		DhcpclientsMgr.DhcpEntry[EndUnit].MsgID = NULL;
	#endif	
	}	

	/*save some info */
	bfGatewaydownOrLeasetimeover = DhcpclientsMgr.DhcpEntry[EndUnit].bfGatewaydownOrLeasetimeover;
	strcpy( EndName, DhcpclientsMgr.DhcpEntry[EndUnit].EndName );	

	/*clear basic info */
	memset( &DhcpclientsMgr.DhcpEntry[EndUnit], 0, sizeof(DhcpclientsMgr.DhcpEntry[EndUnit]) );
	
	DhcpclientsMgr.bfUsed[EndUnit] = DHCPCLEINT_RESOURCE_STATUS_NOTUSED;

	semGive( DhcpclientsMgr.PrivateSemID[EndUnit] );

	if( pMblk2 )
	{
		SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk2 );
	}
	if( pMblk3 )
	{
		SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk3 );
	}

	

#ifdef DHCPCLIENT_DEBUG
	printf("want to DhcpClientIPFree_Notify %s%d\r\n", EndName, EndUnit);
#endif
		
	DhcpClientIPFree_Notify(EndName, EndUnit, bfGatewaydownOrLeasetimeover);

	return;

 }


void DHCPClientsManager()
{	
	ULONG sysTickRate = 0;
	ULONG currentTicks = 0;
	int nIndex = 0;
	M_BLK_ID pMblk1;

	while( !DhcpclientsMgr.bfDhcpCInitOK ) 
	{
		taskDelay(50);
		continue;
	}
		
	while(1)
	{	
		/* First check all kinds of timeout: discover timeout, request timeout, arp-detect/ip-verify timeout, 
		   leasetime(T1/T2) time out and so on */
	 	sysTickRate = sysClkRateGet();

		taskDelay(sysTickRate/3);
		
		for( nIndex= 0; nIndex<MAX_DHCP_CLIENTS ; nIndex ++ ) 
		{							
			if( DhcpclientsMgr.PrivateSemID[nIndex] == NULL )
			{
				printf("dhcpcliens error: DhcpclientsMgr NULL\r\n");
				continue;
			}			
			
			if( semTake( DhcpclientsMgr.PrivateSemID[nIndex], WAIT_FOREVER) == ERROR )
			{
				printf("dhcpcliens error: semTake PrivateSemID ERROR\r\n");
				continue;
			}
			
			if( DhcpclientsMgr.bfUsed[nIndex] != DHCPCLEINT_RESOURCE_STATUS_OK ) 
			{
				semGive(DhcpclientsMgr.PrivateSemID[nIndex]);
				continue;
			}

			currentTicks = tickGet(); 
			pMblk1 = NULL;
			
			switch( DhcpclientsMgr.DhcpEntry[nIndex].stateCurrent ) 
			{ 
				case DHCP_STATE_DISCOVERING: //which will cause constantly discovering pkt send 
					if( currentTicks - DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime > 10 * sysTickRate )
					{//arp timeout, ie, no pc is using the ip, so the ip is ok
						//change state: discover -> requesting:
					#ifdef DHCPCLIENT_DEBUG	
						printf("reDiscovering 1\r\n");
					#endif
						pMblk1 = CreateDiscoverStatePacket( nIndex);
					}
					
					break;
				
				case DHCP_STATE_VERIFYING_IP: 
					if( currentTicks - DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime > sysTickRate / 6 )
					{//arp timeout, ie, no pc is using the ip, so the ip is ok
						//change state: discover -> requesting:
					#ifdef DHCPCLIENT_DEBUG	
						printf("arp timeout, so verify ip ok 1 state\r\n");
					#endif
						DhcpclientsMgr.DhcpEntry[nIndex].StatePrev= DHCP_STATE_DISCOVEROK;
						DhcpclientsMgr.DhcpEntry[nIndex].stateCurrent= DHCP_STATE_REQUESTING;
						DhcpclientsMgr.DhcpEntry[nIndex].nSendTimes = 1;
						DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime = currentTicks;
						pMblk1 = CreateDHCPClientPacketRequest( nIndex );
					}
					break;
				
				case DHCP_STATE_REQUESTING:
				case DHCP_STATE_REQUESTOK:	 //process leasetime
					if( DhcpclientsMgr.DhcpEntry[nIndex].StatePrev == DHCP_STATE_DISCOVEROK )
					{
						if( DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime != 0 && currentTicks - DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime > 20 * sysTickRate )
						{ //recv offer, but first request timeout.
						#ifdef DHCPCLIENT_DEBUG
							printf("enter discover again for first request lost\r\n");
						#endif
							pMblk1 = CreateDiscoverStatePacket(nIndex );
						}
					}
					else if( DhcpclientsMgr.DhcpEntry[nIndex].StatePrev == DHCP_STATE_REQUESTOK)
					{					
						if( DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T1Ticks != 0 && 
							   currentTicks >= DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T1Ticks)
						{
						#ifdef DHCPCLIENT_DEBUG
							printf("T1 arrive\r\n");
						#endif
							DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T1Ticks = 0 ; // ****
							DhcpclientsMgr.DhcpEntry[nIndex].nSendTimes = 1;
							DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime = currentTicks;
							pMblk1 = CreateDHCPClientPacketRequest( nIndex );
						}
						else if( DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T2Ticks != 0 && 
							   currentTicks > DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T2Ticks)
						{
						#ifdef DHCPCLIENT_DEBUG
							printf("T2 arrive\r\n");
						#endif
							DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.T2Ticks = 0; // ***
							DhcpclientsMgr.DhcpEntry[nIndex].nSendTimes = 1;
							DhcpclientsMgr.DhcpEntry[nIndex].lastSendTime = currentTicks;
							pMblk1 = CreateDHCPClientPacketDiscover( nIndex );
						}
						else if( currentTicks > DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.leasetimeTicks)
						{
						#ifdef DHCPCLIENT_DEBUG
							printf("enter discover again leasetimeTicks\r\n");
						#endif
						
						#ifdef RELEASE_IF_REASETIME_OVER
							if( DhcpclientsMgr.bfUsed[nIndex] < DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE )
							{ /*want to prelease */
								DhcpclientsMgr.bfUsed[nIndex] = DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE;
								DhcpclientsMgr.DhcpEntry[nIndex].bfGatewaydownOrLeasetimeover = TRUE;
							}
						#else
							pMblk1 = CreateDiscoverStatePacket( nIndex );
						#endif
						}
					}
					break;			
					
				default: 
					break;				
			}
			
			semGive(DhcpclientsMgr.PrivateSemID[nIndex]);

			if( pMblk1 != NULL )
			{
				SendDataViaCookie( DhcpclientsMgr.pCookie[nIndex], pMblk1 );
			}
		}
	}

 }


#ifdef CHECK_DHCPSERVER

void CheckGatewayManager()
{	
	char  tmpMac[6]={0};

	M_BLK_ID arpMblk = NULL;
	ULONG currentTicks = 0, sysTickRate = 0;
	BOOL bfArpAgain = FALSE;
	int nIndex;

	while( !DhcpclientsMgr.bfDhcpCInitOK ) 
	{
		taskDelay(50);
		continue;
	}
		
	while(1)
	{	
		sysTickRate = sysClkRateGet();

		taskDelay(sysTickRate * 60 * 2 ); /*2 minutes check one time*/
			
		for( nIndex= 0; nIndex<MAX_DHCP_CLIENTS ; nIndex ++ ) 
		{						
			if( DhcpclientsMgr.PrivateSemID[nIndex] == NULL )
			{
				printf("CheckGatewayManager error: PrivateSemID NULL\r\n");
				continue;
			}			
			if( DhcpclientsMgr.pCookie[nIndex] == NULL ) continue;				
			
			if( semTake( DhcpclientsMgr.PrivateSemID[nIndex], sysTickRate ) == ERROR )
			{
				printf("semTake error in CheckGatewayManager: %d\r\n", nIndex );
				continue ;
			}


			if( DhcpclientsMgr.bfUsed[nIndex] != DHCPCLEINT_RESOURCE_STATUS_OK || 
				!DhcpclientsMgr.DhcpEntry[nIndex].bfAckOk ) 
			{
				semGive( DhcpclientsMgr.PrivateSemID[nIndex] );
				continue;
			}
			
			if( SearchArpTable( DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.RouterIP, tmpMac) )
			{ /*get gateway mac,ie, ok*/
				DhcpclientsMgr.DhcpEntry[nIndex].ulLastCheckDhcpServerDownTick = 0;
				semGive( DhcpclientsMgr.PrivateSemID[nIndex] );
				continue;
			}

			//
			arpMblk = CreateArpMblk( DhcpclientsMgr.DhcpEntry[nIndex].ClientMac, DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.ClientIP, 
					           (char *)BROADCAST_HW_ADDR, DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.RouterIP, 1);

			//fear for semID loop-lock, so here for semGive
			semGive( DhcpclientsMgr.PrivateSemID[nIndex] );

			SendDataViaCookie( DhcpclientsMgr.pCookie[nIndex], arpMblk );
			taskDelay(60); //wait 


			if( semTake( DhcpclientsMgr.PrivateSemID[nIndex], sysTickRate) == ERROR )
			{
				printf("semTake error in CheckGatewayManager 2: %d\r\n", nIndex );
				continue ;
			}	
			if( DhcpclientsMgr.bfUsed[nIndex] != DHCPCLEINT_RESOURCE_STATUS_OK || 
				!DhcpclientsMgr.DhcpEntry[nIndex].bfAckOk ) 
			{
				semGive( DhcpclientsMgr.PrivateSemID[nIndex] );
				continue;
			}			
			
			if( SearchArpTable( DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.RouterIP, tmpMac) )
			{ /*get gateway mac,ie, ok*/
				DhcpclientsMgr.DhcpEntry[nIndex].ulLastCheckDhcpServerDownTick = 0;
				semGive( DhcpclientsMgr.PrivateSemID[nIndex] );
				continue;
			}

			//check if timeout
			currentTicks = tickGet();
			bfArpAgain = TRUE;
			
			if( DhcpclientsMgr.DhcpEntry[nIndex].ulLastCheckDhcpServerDownTick == 0 ) 
				DhcpclientsMgr.DhcpEntry[nIndex].ulLastCheckDhcpServerDownTick = currentTicks;			
			else if( currentTicks - DhcpclientsMgr.DhcpEntry[nIndex].ulLastCheckDhcpServerDownTick >= CHECK_DHCPSERVER_DOWN_TICKS * sysTickRate )
			{ //timeout 
				  /*Want to release dhcp */
				if( DhcpclientsMgr.bfUsed[nIndex] < DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE ) 
				{
					DhcpclientsMgr.bfUsed[nIndex] = DHCPCLEINT_RESOURCE_STATUS_FREEPREPARE;
					DhcpclientsMgr.DhcpEntry[nIndex].bfGatewaydownOrLeasetimeover = TRUE;
					bfArpAgain = FALSE;
				}
				
			}

			//send arp again
			if( bfArpAgain )
				arpMblk = CreateArpMblk( DhcpclientsMgr.DhcpEntry[nIndex].ClientMac, DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.ClientIP, 
										   (char *)BROADCAST_HW_ADDR, DhcpclientsMgr.DhcpEntry[nIndex].BaseIPAttr.RouterIP, 1);

			semGive( DhcpclientsMgr.PrivateSemID[nIndex] );

			if( bfArpAgain )
				SendDataViaCookie( DhcpclientsMgr.pCookie[nIndex], arpMblk );
			
		}			
	}
}

#endif  /*CHECK_DHCPSERVER */
				
#endif /*WAN_SUPPORT_DHCP*/

///SendDataViaCookie( DhcpclientsMgr.pCookie[EndUnit], pMblk );
