#ifndef DHCP_CLIENTS_H
#define DHCP_CLIENTS_H

#include "semlib.h"
#include "endlib.h"
#include "msgQLib.h"

#define CHECK_DHCPSERVER

#define CHECK_DHCPSERVER_DOWN_TICKS     ( 60 * 3 ) /*SECONDS*/

#define HWLEN 6
#define IPLEN  4
#define UDP_ALEN IPLEN

#define MAX_DHCP_CLIENTS 8


#define DHCP_STATE_INIT           0
#define DHCP_STATE_DISCOVERING    1 
#define DHCP_STATE_VERIFYING_IP	2 
#define DHCP_STATE_DISCOVEROK	  3 
#define DHCP_STATE_REQUESTING	  4
#define DHCP_STATE_REQUESTOK	  5

#define SUPPORT_ARP_MANUAL

#define END_NAME_LEN 20
typedef struct DhcpClientIPAttr
{		
	ULONG ClientIP; /*deceit IP from DHCP server*/
	ULONG ServerIP; 	/*dhcp server IP*/	
	ULONG Domain1IP;
	ULONG Domain2IP;
	ULONG SubNetMask;
	ULONG RouterIP; 

	ULONG  leaseTime;	/*deceit iP's lease time: unit is seconds */
	ULONG   T1; //unicast request pkt
	ULONG   T2; //broadcast discover pkt with old ip

	//according to leaseTime/T1/T2 change them to the time of ticks
	ULONG leasetimeTicks;
	ULONG T1Ticks;
	ULONG T2Ticks;
		
}DhcpClientIPAttr;


typedef struct DhcpClientsEntry
{
	char 	EndName[END_NAME_LEN];
	int  	EndUnit;
	
	char 	ClientMac[HWLEN]; /*deceit hardware addr*/
	char 	ServerMac[6]; /*dhcp server */
	
	MSG_Q_ID	MsgID;
	int 		taskID;

	DhcpClientIPAttr BaseIPAttr;
	
	/*status, the main dhcp client status: 0->HDCPDISCOVER->DHCPREQUEST->DHCPACK*/
	/*Note, if the dhcp is already DHCPACK, it will not be modified to DHCPREQUEST again */
	ULONG transactionID;
	u_char stateCurrent;		 
	u_char StatePrev;
		
	ULONG lastSendTime;
	int nSendTimes;

	BOOL bfGatewaydownOrLeasetimeover;	

#ifdef CHECK_DHCPSERVER
	BOOL bfAckOk;
	ULONG ulLastCheckDhcpServerDownTick;
#endif	
	
}DhcpClientsEntry;

typedef struct DhcpClients
{
	DhcpClientsEntry  DhcpEntry[MAX_DHCP_CLIENTS];	
	SEM_ID 		PrivateSemID[MAX_DHCP_CLIENTS];
  	int     	bfUsed[MAX_DHCP_CLIENTS];
	void 		*pCookie[MAX_DHCP_CLIENTS];
	ULONG 		CheckGatewayID;
	ULONG       DHCPClientsManagerID;
	//SEM_ID 		DhcpCResourceSem;
	BOOL 		bfDhcpCInitOK;
	short 		IP_IdentifyID;
	
} DhcpClients;

#endif

