/*
   ??? Note, in vxworks 2.1.1, if one interface's mask is 255.255.255.255, or invoke ifrouteDelete to its interface,
   then OS will not accept all arp reply. 
*/
#include "vxworks.h"
#include "stdio.h"
#include "inetLib.h"
#include "routeLib.h"

#include "oneonenatconstant.h"
#include "xxxmiscu.h"

#ifdef WAN_SUPPORT_DHCP
extern int PPP_start_unit;

//#define DHCP_CONTROL_DEBUG
#define INDIVIDUAL_LOING_MASK_SPECIAL

//import
extern BOOL SetOneOneNatWanIP(char* DevName, int DevUnit, ULONG LocalIP, ULONG remoteIP, ULONG mask, ULONG priDNSIP, ULONG secDNSIP );
extern char *GetWanVirtualEndName();
BOOL SetOneOneNatPPPDown(char* DevName, int DevUnit );

void ReleaseDhcpClient( int Unit, BOOL bfGatewaydownOrLeasetimeover );;


//local
static void DelUselessRouteIP(int unit);

//export
void DhcpClientTerminate(int unit );
BOOL DhcpClientGetIP_Notify(char *EndName, int unit, 
	ULONG clientIP, ULONG ServerIP/*no need */, ULONG routerIP, ULONG mask, ULONG priDNSIP, ULONG secDNSIP );
BOOL DhcpClientIPFree_Notify(char *EndName, int unit, BOOL bfGatewaydownOrLeasetimeover ); //after dhcpclient timout an ip, call it

static char *ReservedIPStr = "1.0.0.1"; /*note, cannot set to 0.0.0.0 */

BOOL DhcpClientGetIP_Notify(char *EndName, int unit, 
	ULONG clientIP, ULONG ServerIP/*no need */, ULONG routerIP, ULONG mask, ULONG priDNSIP, ULONG secDNSIP )
{
	char IpStr[20] = {0};
	char EndNameUnit[20] = {0};

	if( clientIP == 0 ) return FALSE;

	sprintf(EndNameUnit, "%s%d", EndName, unit);
	inet_ntoa_b( *(struct in_addr *)(&clientIP), IpStr );

	ifRouteDelete(EndName, unit); /*delete old useless route table*/

	if( unit == PPP_start_unit ) 
	{
		if( ifMaskSet( EndNameUnit, ntohl(mask) ) == ERROR ) /*must set it before SetOneOneNatWanIP. Reason, NAPT will check ip */
		{
			printf("DhcpClientGetIP_Notify: ifMaskSet fail %s ", EndNameUnit );
			PrintIP_LXX(mask, TRUE);
			return FALSE;
		}	
	}
	else
	{
	#ifdef	INDIVIDUAL_LOING_MASK_SPECIAL
		if( ifMaskSet( EndNameUnit, ntohl(0xffffffff) ) == ERROR ) /*must set it before SetOneOneNatWanIP. Reason, NAPT will check ip */
		{
			printf("DhcpClientGetIP_Notify: ifMaskSet fail %s ", EndNameUnit );
			PrintIP_LXX(0xffffffff, TRUE);
			return FALSE;
		}
	#endif	
	}
	
	if( ifAddrSet( EndNameUnit, IpStr ) == ERROR ) /*must set it before SetOneOneNatWanIP. Reason, NAPT will check ip */
	{
		printf("DhcpClientGetIP_Notify: ifAddrSet fail %s ", EndNameUnit );
		PrintIP_LXX(clientIP, TRUE);

		DelUselessRouteIP(unit);
		return FALSE;
	}	
	
	if( !SetOneOneNatWanIP(EndName, unit, clientIP, routerIP, mask, priDNSIP, secDNSIP) )
	{
	#ifdef DHCP_CONTROL_DEBUG
		printf("SetOneOneNatWanIP fail\r\n");
	#endif
	
		DelUselessRouteIP(unit);
		return FALSE;
	}
#ifdef DHCP_CONTROL_DEBUG	
	printf("SetOneOneNatWanIP ok in DhcpClientGetIP_Notify:%s\r\n", EndNameUnit);
#endif
	
	if( unit == PPP_start_unit ) /*napt wan ip */
	{		
		inet_ntoa_b( *(struct in_addr *)(&routerIP), IpStr );
		if( routeAdd("0.0.0.0", IpStr ) == ERROR )
		{
			printf("routeAdd error:%lx\r\n", routerIP );
		}
	#ifdef DHCP_CONTROL_DEBUG	
		printf("set route 0.0.0.0 via %s\r\n", IpStr );
	#endif
	}

	return TRUE;
	//return SetOneOneNatWanIP( EndName, unit,  clientIP, routerIP,  mask, priDNSIP, secDNSIP); 
}

/*Only be called for dhcp clients's reason: for example, gateway down, or lease time expire. */
BOOL DhcpClientIPFree_Notify(char *EndName, int unit, BOOL bfGatewaydownOrLeasetimeover) //after dhcpclient timout an ip, call it
{ //same as pppdown
	
	if( bfGatewaydownOrLeasetimeover ) 	
		SetOneOneNatPPPDown( EndName, unit );

	DelUselessRouteIP( unit);

	return TRUE;
		
}


void DhcpClientTerminate(int unit ) /*call by outside */
{
	ReleaseDhcpClient( unit , FALSE);
}


void DelUselessRouteIP(int unit)
{
	char IfName[32] = {0};
	char IPStr[20] = {0};
	ULONG tmpIP = 0;

	tmpIP =htonl( ntohl( inet_addr(ReservedIPStr) ) + unit );
	sprintf(IfName, "%s%d", GetWanVirtualEndName(), unit);	

	ifRouteDelete(GetWanVirtualEndName(), unit);
	if( unit == PPP_start_unit )
	{
		routeDelete("0.0.0.0", "0.0.0.0");
	}		


	/*set to reserverd ip */
	if( ifMaskSet( IfName, ntohl(0xffffffff) ) == ERROR ) /*must set it before SetOneOneNatWanIP. Reason, NAPT will check ip */
	{
		printf("DelUselessRouteIP: ifMaskSet fail %s ", IfName );
		PrintIP_LXX(0xffffffff, TRUE);
	}	


	tmpIP =htonl( ntohl( inet_addr(ReservedIPStr) ) + unit );
	inet_ntoa_b( *(struct in_addr *)(&tmpIP), IPStr );
	ifAddrSet( IfName, IPStr );		

	
#ifdef DHCP_CONTROL_DEBUG	
	printf("DelUselessRouteIP ok \r\n");	
#endif
}

#endif
