#ifndef GEN_MD_H
#define GEN_MD_H

/* MD5 context. */
typedef struct {
    unsigned int state[4];		/* state (ABCD) */
    unsigned int count[2];		/* number of bits, modulo 2^64 (lsb first) */
    unsigned char buffer[64];	/* input buffer */
} MD5_CTX;

#ifdef __cplusplus
  extern "C" {
#endif

void MyMD5Init(MD5_CTX *);
void MyMD5Update(MD5_CTX *, unsigned char *, unsigned int);
void MyMD5Final(unsigned char[16], MD5_CTX *);
void MyGen_passwd( unsigned char *passwd_resp, int *resp_len, char *cleartext_pw,
                 char *secret, unsigned char *request_authenticator );

void MyGen_ra( char *data, int len );

#ifdef __cplusplus
}
#endif

#define MD5_DIGEST_CHARS         16

#endif
