/*
SHOW_GetTrellis();
SHOW_GetShakeHands();
SHOW_GetWiring();
SHOW_GetBitswapEnable();
 
SHOW_SetTrellis(TRUE);
SHOW_SetShakeHands(1);
SHOW_SetWiring(1);
SHOW_SetBitswapEnable(TRUE);
 

*/
BOOL upgradeAdslAdvanced( short nTrillIndex, short nShakehandsIndex, short nWiringIndex, short nBitsSwapIndex );

char *adslAdvance_format="
<HTML><HEAD>\n\
<TITLE>LAN Setup Page</TITLE>\n\
<META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"now\">\n\
<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n\
<SCRIPT LANGUAGE='JavaScript'>
function ResetCfg()
{
	document.forms[1].submit();
}
</SCRIPT>
</HEAD>\n\
<body background=\"bg.gif\" bgcolor=\"#FFFFFF\" onload=\"if( parent && parent !=self ) parent.startrefresh()\"><center>\n\
\n\
<form method=\"POST\" action=\"act_adslAdvance\">\n\
<CENTER>
<center><FONT SIZE=+2 COLOR=blue><B>ADSL Configuration</B></FONT></center>
<p></p>
<TABLE cellspacing=\"0\" cellpadding=\"0\">
<!VPI>%s 
<!VCI>%s
<!trellis>%s
<!handshake>%s
<!adsl wiring>%s
<!bis swap>%s
</TABLE>
<P>
<INPUT type=submit value=\"Submit\">
<INPUT type=reset value=\"Default Setting\" onclick=\"ResetCfg()\">
</CENTER>
</FORM>
<form method=\"POST\" action=\"act_adslAdvanceReset\">\n\
</form>
</BODY>
</HTML>";


char *trellisMode[]={
	"Disabled",
	"Enabled"
};

char *HandshakeProtocol_Mode[]=
{
	"Autosense - G.dmt first",
	"Autosense - T1.413 first",
	"G.dmt/G.lite",
	"T1.413",
	"G.dmt",
	"G.lite"		
};

char *WiringMode[]=
{
	"Auto",
	"Tip/Ring",
	"A/A1"
};

char *BitsSwapMode[]={
	"Disabled",
	"Enabled"
};

void CreateTrellis(char *Buf, short Index)
{
	int i;

	Buf[0] = 0;	
		
	sprintf(&Buf[strlen(Buf)], "<TR><TD>Trellis</TD><TD><SELECT NAME=adsl_trellis >");
	
	for(i=0; i<sizeof(trellisMode)/sizeof(trellisMode[0]); i++)
		sprintf(&Buf[strlen(Buf)], "<OPTION VALUE=%d %s> %s </OPTION> ",
			i, (Index == i)?"SELECTED":"", trellisMode[i] );

	sprintf(&Buf[strlen(Buf)], "</SELECT></TD></TR>");

	//printf("Buf = %s\r\n", Buf );
	
	return ;
}


void CreateHandshake_Protocol(char *Buf, short Index)
{
	int i;

	Buf[0] = 0;	
	sprintf(&Buf[strlen(Buf)], "<TR><TD>Handshake Protocol</TD><TD><SELECT NAME=adsl_handshake >");
	for(i=0; i<sizeof(HandshakeProtocol_Mode)/sizeof(HandshakeProtocol_Mode[0]); i++)
		sprintf(&Buf[strlen(Buf)], "<OPTION VALUE=%d %s> %s </OPTION> ",
			i, (Index == i)?"SELECTED":"", HandshakeProtocol_Mode[i] );
	sprintf(&Buf[strlen(Buf)], "</SELECT></TD></TR>");
	
	return ;
}

void CreateWiring(char *Buf, short Index)
{
	int i;
	
	Buf[0] = 0;
	sprintf(&Buf[strlen(Buf)], "<TR><TD>Wiring Selection</TD><TD><SELECT NAME=adsl_wiring_selection >");
	for(i=0; i<sizeof(WiringMode)/sizeof(WiringMode[0]); i++)
		sprintf(&Buf[strlen(Buf)], "<OPTION VALUE=%d %s> %s </OPTION> ",
			i, (Index == i)?"SELECTED":"", WiringMode[i] );
	sprintf(&Buf[strlen(Buf)], "</SELECT></TD></TR>");
	
	return ;
}


void CreateBisSwap(char *Buf, short Index)
{
	int i;
	
	Buf[0] = 0;
	sprintf(&Buf[strlen(Buf)], "<TR><TD>Bit Swapping</TD><TD><SELECT NAME=adsl_bit_swapping >");
	for(i=0; i<sizeof(BitsSwapMode)/sizeof(BitsSwapMode[0]); i++)
		sprintf(&Buf[strlen(Buf)], "<OPTION VALUE=%d %s> %s </OPTION> ",
			i, (Index == i)?"SELECTED":"", BitsSwapMode[i] );
	sprintf(&Buf[strlen(Buf)], "</SELECT>(No system reboot needed)</TD></TR>");
	
	return ;
}


void CreateVPI(char *Buf)
{
	int i;
	short tmp16;
	
	Buf[0] = 0; 
	SYSTEM_WanInfoGet(VPI_NUMBER, nCurentVCICircuit, (char *)&tmp16, 2);
	sprintf(&Buf[strlen(Buf)], "<TR><TD>VPI</TD><TD>");
	sprintf(&Buf[strlen(Buf)], "<INPUT TYPE=text NAME=wan_VPI SIZE=4 value=%d>", tmp16 );
	sprintf(&Buf[strlen(Buf)], "</TD></TR>");
	
	return ;
}

void CreateVCI(char *Buf)
{
	int i;
	short tmp16;
	
	Buf[0] = 0; 
	SYSTEM_WanInfoGet(VCI_NUMBER, nCurentVCICircuit, (char *)&tmp16, 2);
	sprintf(&Buf[strlen(Buf)], "<TR><TD>VCI</TD><TD>");
	sprintf(&Buf[strlen(Buf)], "<INPUT TYPE=text NAME=wan_VCI SIZE=4 value=%d>", tmp16 );
	sprintf(&Buf[strlen(Buf)], "</TD></TR>");
	
	return ;
}

int update_adslAdvance_htm ( pHTTP_CONN conn )
{
	short nTrillIndex=-1, nShakehandsIndex=-1, nWiringIndex=-1, nBitsSwapIndex=-1;
	char VPI[200]={0};
	char VCI[200]={0};
	char Trills[400] = {0};
	char Shakehands[400]= {0};
	char Wiring[400] ={0};
	char BitsSwap[400]={0};
	int len = 0;
	char *adsl_advance_htm = NULL;
	SHTM_CFG_FT_T*	pShtmCfgIf = NULL;
	int level;

	level = HttpDGetSecurityLevel(conn);

	if ( !ShtmIsLoaded()) 
	{
		printf("update_adslAdvance_htm: ShtmIsLoaded not\r\n");
		goto update_END;
	}
	
	pShtmCfgIf = ShtmGetCfgInterface();

	if (pShtmCfgIf == NULL)
	{
		printf("update_adslAdvance_htm: ShtmGetCfgInterface fail\r\n");
		goto update_END;
	}
		
	//printf("Old: %d_%d_%d_%d\r\n", nTrillIndex, nShakehandsIndex, nWiringIndex, nBitsSwapIndex );
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(TRELLIS, (char *)&nTrillIndex, 2) != OK ) 
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", TRELLIS );
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(HANDSHAKE, (char *)&nShakehandsIndex, 2) != OK ) 
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", HANDSHAKE );
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(WIRING_SELECTION, (char *)&nWiringIndex, 2) != OK )
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", WIRING_SELECTION );

#if 0
 	//???? Maybe not BNA for bitsswaping 
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(BNA, (char *)&nBitsSwapIndex, 2) != OK )
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", BNA );
#else	
	nBitsSwapIndex = SHOW_GetBitswapEnable();
#endif

	//printf("Get: %d_%d_%d_%d\r\n", nTrillIndex, nShakehandsIndex, nWiringIndex, nBitsSwapIndex );
	//VPI
	CreateVPI(VPI);
	if( strlen(VPI) >= sizeof(VPI) ) printf("CreateVPI memory error\r\n");

	//VCI
	CreateVCI(VCI);
	if( strlen(VCI) >= sizeof(VCI) ) printf("CreateVCI memory error\r\n");

	//Trellis
	if( level == HTTP_SECURITY_LEVEL_SUPER || level == HTTP_SECURITY_LEVEL_SUPER_SGH )
	{
		CreateTrellis(Trills, nTrillIndex);
		if( strlen(Trills) >= sizeof(Trills) ) printf("CreateTrellis memory error\r\n");
	}

	//Shakehands
	if( level == HTTP_SECURITY_LEVEL_ADMIN || 
		level == HTTP_SECURITY_LEVEL_SUPER || level == HTTP_SECURITY_LEVEL_SUPER_SGH )
	{
		CreateHandshake_Protocol(Shakehands, nShakehandsIndex);
		if( strlen(Shakehands) >= sizeof(Shakehands) ) printf("CreateHandshake_Protocol memory error\r\n");
	}

	//Wiring
	if( level == HTTP_SECURITY_LEVEL_SUPER || level == HTTP_SECURITY_LEVEL_SUPER_SGH )
	{
		CreateWiring(Wiring, nWiringIndex);
		if( strlen(Wiring) >= sizeof(Wiring) ) printf("CreateWiring memory error\r\n");
	}

	//BitsSwap
	if( level == HTTP_SECURITY_LEVEL_SUPER || level == HTTP_SECURITY_LEVEL_SUPER_SGH )
	{
		CreateBisSwap(BitsSwap, nBitsSwapIndex);
		if( strlen(BitsSwap) >= sizeof(BitsSwap) ) printf("CreateBisSwap memory error\r\n");
	}
	
	
update_END:
	len = sprintfii(&adsl_advance_htm, adslAdvance_format,
		VPI, VCI, Trills, Shakehands, Wiring, BitsSwap );

	if( adsl_advance_htm == NULL )
	{
		printf("update_adslAdvance_htm error\r\n");
		return OK;
	}

	HTTPDSendHeader(conn->sock, httpdGetUrlType(".htm"), len);
	HTTPDSendData(conn->sock, adsl_advance_htm, len );
	sprintfii_free(adsl_advance_htm);

	//printf("update_adslAdvance_htm ok\r\n");
		
    return OK;
	
}

#if 0
BOOL ChangeAdslCfg( short nNewTrillIndex, short nNewShakehandsIndex, short nNewWiringIndex, short nNewBitsSwapIndex )
{
	short nTrillIndex=-1, nShakehandsIndex=-1, nWiringIndex=-1, nBitsSwapIndex=-1;
	char *adsl_advance_htm = NULL;
	SHTM_CFG_FT_T*	pShtmCfgIf = NULL;
	BOOL bfNeedSave = FALSE;
	
	if ( !ShtmIsLoaded()) 
	{
		SendMsgBuffer("ShtmIsLoaded not .");
		return FALSE;
	}
	
	pShtmCfgIf = ShtmGetCfgInterface();
	if( pShtmCfgIf == NULL ) 
	{
		SendMsgBuffer("ShtmIsLoaded not .");
		return FALSE;
	}

	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(TRELLIS, (char *)&nTrillIndex, 2) != OK )
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", TRELLIS );
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(HANDSHAKE, (char *)&nShakehandsIndex, 2) != OK ) 
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", HANDSHAKE );
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(WIRING_SELECTION, (char *)&nWiringIndex, 2) != OK )
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", WIRING_SELECTION );

#if 0
	//???? Maybe not BNA for bitsswaping 
	if( pShtmCfgIf->SYSTEM_ADSLInfoGet(BNA, (char *)&nBitsSwapIndex, 2) != OK )
		printf("SYSTEM_ADSLInfoGet fail: %d\r\n", BNA );
#else
	nBitsSwapIndex = SHOW_GetBitswapEnable();
#endif
				

	//printf("Want Old: %d_%d_%d_%d\r\n", nTrillIndex, nShakehandsIndex, nWiringIndex, nBitsSwapIndex );
	//printf("Want New: %d_%d_%d_%d\r\n", nNewTrillIndex, nNewShakehandsIndex, nNewWiringIndex, nNewBitsSwapIndex );

	if( nTrillIndex != nNewTrillIndex )
	{
		bfNeedSave = TRUE;
	#if 1
		if( pShtmCfgIf->SYSTEM_ADSLInfoSet(TRELLIS, (char *)&nNewTrillIndex, 2) != OK )
			printf("SYSTEM_ADSLInfoSet fail: %d\r\n", TRELLIS );
	#else
		SHOW_SetTrellis(nNewTrillIndex);
	#endif
	}
	if( nShakehandsIndex != nNewShakehandsIndex )
	{
		bfNeedSave = TRUE;
	#if 1	
		if( pShtmCfgIf->SYSTEM_ADSLInfoSet(HANDSHAKE, (char *)&nNewShakehandsIndex, 2) != OK )
			printf("SYSTEM_ADSLInfoSet fail: %d\r\n", HANDSHAKE );
	#else
		SHOW_SetShakeHands(nNewShakehandsIndex);
	#endif
	}
	if( nWiringIndex != nNewWiringIndex )
	{
		bfNeedSave = TRUE;
	#if 1	
		if( pShtmCfgIf->SYSTEM_ADSLInfoSet(WIRING_SELECTION, (char *)&nNewWiringIndex, 2) != OK )	
			printf("SYSTEM_ADSLInfoSet fail: %d\r\n", WIRING_SELECTION );
	#else		
		SHOW_SetWiring(nNewWiringIndex);	
	#endif
	}
	if( nBitsSwapIndex != nNewBitsSwapIndex )
	{
		bfNeedSave = TRUE;
	#if 0
		if( pShtmCfgIf->SYSTEM_ADSLInfoSet(BNA, (char *)&nNewBitsSwapIndex, 2) != OK )
			printf("SYSTEM_ADSLInfoSet fail: %d\r\n", BNA );
	#else
		SHOW_SetBitswapEnable(nNewBitsSwapIndex);
	#endif
	}

	if( bfNeedSave )
	{	
		SYSTEM_InfoStore();
		SendMsgBuffer("Applied parameter accepted. Reboot to validate");
	}		

	return TRUE;
	
}

#endif
