#include <stdio.h>
#include <string.h>
#include <inetLib.h>
#include <memLib.h>
#include <stdlib.h>
#include <netinet\if_ether.h>
#include <iflib.h>
#include <net/mbuf.h>
#include "syslib.h"
#include "tickLib.h"
#include "taskLib.h"
#include "msgQLib.h"
#include "arplib.h"
#include "etherlib.h"
#include "endlib.h"
#include "xxxprotocol.h"

#include "oneonenatconstant.h"

#ifdef NEED_ARP_SPOOF_FOR_PUBLIC_IP_SAME_SUBNET

//import 
extern ULONG GetDhcpdIP();
extern END_OBJ *GetDhcpdEndObj();
extern char *GetDhcpdMac();


//local variant/function
static BOOL bfArpSpoofInitOK = FALSE;
static bfIPDetecting = FALSE;
static ULONG DetectingIP = 0;
static bfFound = FALSE;
static MSG_Q_ID ArpNeedSpoofMsg = NULL;

LOCAL BOOL AddSpoofBuffer( M_BLK_ID pMblk );//network order
LOCAL void ArpSpoofTask();

//Export
BOOL InitArpSpoof();
BOOL ArpSpoof_PublicIP_SameSunet(M_BLK_ID pMblk);
	
//Funciton define
BOOL AddSpoofBuffer( M_BLK_ID pMblk )
{	
	if( ArpNeedSpoofMsg == NULL )
	{
		netMblkClChainFree (pMblk);
		printf("ArpNeedSpoofMsg == NULL\r\n");
		return FALSE;
	}
	
	if( msgQSend( ArpNeedSpoofMsg, (char *)&pMblk, 4, NO_WAIT, MSG_PRI_NORMAL) == ERROR )
	{
		netMblkClChainFree (pMblk);
		printf("msgQSend ArpNeedSpoofMsg error\r\n");
		return FALSE;
	}

	return TRUE;	
}


BOOL InitArpSpoof()
{
	ArpNeedSpoofMsg = msgQCreate( 20, 4, MSG_Q_FIFO );
	if( ArpNeedSpoofMsg == NULL  ) 
	{
		printf("msgQCreate error in InitArpSpoof\r\n");
		return FALSE;
	}

	bfArpSpoofInitOK = TRUE;
	
	if( taskSpawn("tArpSpoof",100,0,1024 * 8 ,(FUNCPTR)ArpSpoofTask,0,1,2,3,4,5,6,7,8,9) == ERROR) 
	{
		printf("error: taskSpawn in InitArpSpoof\r\n");
		return FALSE;
	}	

	return TRUE;
}


//#define ARPSPOOF_TASK_DEBUG 
void ArpSpoofTask()
{
	M_BLK_ID pMblk = NULL, pTmpMblk1 = NULL/*, pTmpMblk2 = NULL*/;
	char *pData = NULL; 
	ARP *pArp = NULL;
	ULONG IP =0;
	ULONG IP2 =0;
	ULONG TimeoutTicks_Wait = sysClkRateGet()/3; 

	while(1)
	{		
		pMblk = NULL;
		
		while( 1) 
		{
			pMblk = NULL;
			if( msgQReceive(ArpNeedSpoofMsg, (char *)&pMblk, 4, WAIT_FOREVER ) != 4 )
			{
				printf("ArpSpoofTask: msgQReceive error\r\n");
				continue;
			}		
			if( pMblk == NULL ) 
			{
				printf("ArpSpoofTask: pMblk == NULL\r\n");
				continue;
			}

			pData = pMblk->mBlkHdr.mData;
			pArp = (ARP *) &pData[14];
			memcpy( &IP, &pArp->target_ip, 4);
			memcpy( &IP2, &pArp->sender_ip, 4);
			
			pTmpMblk1 = CreateArpMblk( GetDhcpdMac(), GetDhcpdIP(), ZERO_HW_ADDR, IP, 1);
			//pTmpMblk2 = CreateArpMblk( GetDhcpdMac(), GetDhcpdIP(), ZERO_HW_ADDR, IP, 1);

			//Set to wait detecting status
			bfFound = FALSE;
			bfIPDetecting = TRUE;
			DetectingIP = IP;
			#ifdef ARPSPOOF_TASK_DEBUG	
				printf("ARP detecting ...");	
				PrintIP_LXX(DetectingIP, TRUE);
			#endif	
			
			
			SendMblkViaEndObj( pTmpMblk1, GetDhcpdEndObj());
			//SendMblkViaEndObj( pTmpMblk2, GetDhcpdEndObj());
			
			taskDelay( TimeoutTicks_Wait );

			//restore some variant
			bfIPDetecting = FALSE;
			DetectingIP = 0;
			
			if( bfFound ) 
			{ //the ip is used by other pc, not spoof it
				netMblkClChainFree (pMblk);
				pMblk = NULL ;
				
				#ifdef ARPSPOOF_TASK_DEBUG	
					printf("Not spoof ");
					PrintIP_LXX(IP, TRUE);
				#endif
			}	
			else 
			{
				memcpy( &pData[0], &pData[6], 6);
				memcpy( &pData[6], GetDhcpdMac(), 6);
							
				pArp->opcode = htons( 2);
				memcpy( &pArp->target_ip, &pArp->sender_ip, 4);
				memcpy( &pArp->sender_ip, &IP, 4);
				memcpy( pArp->target_mac, pArp->sender_mac, 6); 		
				memcpy( pArp->sender_mac, GetDhcpdMac(), 6);

				#ifdef ARPSPOOF_TASK_DEBUG	
					printf("Spoof OK: ");	
					PrintIP_LXX(IP, TRUE);
				#endif

				
				SendMblkViaEndObj(pMblk, GetDhcpdEndObj() ); 
				pMblk = NULL ;
			}			
		}
	}
}

#if 0 //???? Why it will cause usb cannot send pkt
//This function will be called in a Mac HOOK
//Return TRUE-- The Mblk is swallow.
BOOL ArpSpoof_PublicIP_SameSunet(M_BLK_ID pMblk)
{
	char *pData = NULL;	
	ARP *pArp = NULL;
	ULONG IP =0;
	ULONG IP2 =0;
	extern BOOL bfAllInitOk;

	if( pMblk == NULL ) return TRUE;
	
	pData = pMblk->mBlkHdr.mData;
	
	if( !bfArpSpoofInitOK && !bfAllInitOk ) return FALSE;
#if 0
	printf("ArpSpoof_PublicIP_SameSunet 1: ");
	ShortMemDumpXX(&pData[12], 2); 
	printf("\r\n");
#endif

	if( IsArpPacket(pData) )
	{		
		pArp = (ARP *) &pData[14];			
		memcpy( &IP, &pArp->target_ip, 4);
		memcpy( &IP2, &pArp->sender_ip, 4);

		//printf("ArpSpoof_PublicIP_SameSunet 2....\r\n");
		
		if( IsArpReply(pData) )
		{	
			if( bfIPDetecting && !bfFound && DetectingIP == IP2 && IP != IP2 ) 
			{
			#ifdef ARPSPOOF_TASK_DEBUG	
				printf("Found the ip: ");
				PrintIP_LXX(DetectingIP, TRUE);
			#endif
				bfFound = TRUE;
			}
		}
		else 
		{
			if( IP != IP2 && IsNeedToArpSpoofForSamePublicIPSubnet( &pData[6], IP ) )
			{//put the Mblk into spoof Buffer
			#ifdef ARPSPOOF_TASK_DEBUG	
				printf("put to arp buffer\r\n");
			#endif
				AddSpoofBuffer( pMblk );
				return TRUE;
			}
		}
	}
	
	return FALSE;
}
#else //It's ok, but don't detect if need to spoof with arp/ping
BOOL ArpSpoof_PublicIP_SameSunet(M_BLK_ID pMblk)
{
	M_BLK_ID pSpoofMblk;
	extern BOOL bfAllInitOk;
	char *pData = pMblk->mBlkHdr.mData;

	if( bfAllInitOk && IsArpPacket(pData) && !IsArpReply(pData) )
	{
		ARP *pArp = (ARP *) &pData[14];
		ULONG IP =0;
		ULONG IP2 =0;

		memcpy( &IP, &pArp->target_ip, 4);
		memcpy( &IP2, &pArp->sender_ip, 4);

		if( IP != IP2 && /*!IsSpecialIP_Private( IP) */ IsNeedToArpSpoofForSamePublicIPSubnet( &pData[6], IP )  )
		{//Change request to respond pkt
			memcpy( &pData[0], &pData[6], 6);
			memcpy( &pData[6], GetDhcpdMac(), 6);
			
			pArp->opcode = htons( 2);
			memcpy( &pArp->target_ip, &pArp->sender_ip, 4);
			memcpy( &pArp->sender_ip, &IP, 4);	
			memcpy( pArp->target_mac, pArp->sender_mac, 6);
			memcpy( pArp->sender_mac, GetDhcpdMac(), 6);

			SendMblkViaEndObj(pMblk, GetDhcpdEndObj()); 

			return TRUE;
		}
	}		

	return FALSE;
}
#endif



#endif
