#ifndef _LAN_SECU_H_
#define _LAN_SECU_H_

#define MAX_DHCP_RESERVATIONS	 10

typedef struct 
{
	unsigned long	ip_address;
	char			host_name[16];
	char			ether_addr[6];
} DHCP_RESERVATION;



typedef struct LAN_SECURITY_STRUC_IP
{
	ULONG LanIP; /*network order */
	ULONG LanMask; /*network order */

	ULONG dhcpStartIP;	/*network order */
	ULONG dhcpEndIP; /*network order */

	ULONG DNS1; //no use now
	ULONG DNS2; //no use now

	ULONG GatewayIP;

	DHCP_RESERVATION	dhcp_resv_entries[MAX_DHCP_RESERVATIONS];

}LAN_SECURITY_STRUC_IP;

typedef struct LAN_SECURITY_STRUC
{
	ULONG Flag1;
	ULONG version; //no use now
	
	//Normal user: low
	char UserName[128];
	char UserName_PSW[128];

	//Admin: middle
	char AdminName[128];
	char AdminName_PSW[128];

	//Super User: highest
	char SuperName[128];
	char SuperName_PSW[128];

	LAN_SECURITY_STRUC_IP IPAttr;

		/*2004.03.29*/
	BOOL SharingLoginStrictCheck;
	BOOL WirelessMD5Protection;
	int      MaxWanPPPNum;		

	
}LAN_SECURITY_STRUC;

BOOL ReadLanSecurityCfg (void);
BOOL SaveLanSecurity_Private();
BOOL SaveLanSecurity();
char *GetUserName();
char *GetUserPassword();
BOOL SetUserPassword(char *NewPsw);
char *GetAdminName();
char *GetAdminPassword();
BOOL SetAdminPassword(char *NewPsw);
char *GetSuperName();
char *GetSuperPassword();
BOOL SetSuperPassword(char *NewPsw);
ULONG GetLanIP();
BOOL SetLanIP(ULONG IP);
ULONG GetLanMask();
BOOL SetLanMask(ULONG IP);
ULONG GetLanDns1();
BOOL SetLanDns1(ULONG newip);
ULONG GetLanDns2();
BOOL SetLanDns2(ULONG newip);
ULONG GetDhcpStartIP();
BOOL SetDhcpStartIP(ULONG IP);
ULONG GetDhcpEndIP();
BOOL SetDhcpEndIP(ULONG IP);
ULONG GetUsingLanIP();
ULONG GetUsingLanMask();
ULONG GetUsingLanDns1();
ULONG GetUsingLanDns2();
ULONG GetUsingDhcpStartIP();
ULONG GetUsingDhcpEndIP();
DHCP_RESERVATION *GetdDhcpResvEntry();

void ShowLanSecurityInfo();





#endif

