/*****************************************************************************
 *
 * Project:       Compex NetPassage66
 *
 * Module:
 *
 * Copyright:     (c) Powermatic Data Systems Ltd.
 *                (c) Conexant Systems Inc.
 *
 * $Author: shao-gh $
 * $Revision: 1.1.1.1 $
 * $Modtime:   21 Mar 2002 15:03:06  $
 *
 * $Log: rtl8019End.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:36  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:51  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:25  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.1   25 Mar 2002 15:03:26   He-YH
 * RTL Ethernet END can work,
 * 
 *    Rev 1.0   08 Mar 2002 11:17:20   He-YH
 * Checked in from initial workfile by PVCS Version Manager Project Assistant.
 *****************************************************************************/
#ifndef    __INCrtl8019Endh
#define    __INCrtl8019Endh

#ifdef    __cplusplus
extern "C" {
#endif

#define END_OBJ_STRING		"RTL8019 Enhanced Network Driver"
#define RTL_DEV_NAME        "rtl"
#define RTL_DEV_NAME_LEN    4

/* globals */
/*HYH_RTL_FIX1*/ /*need caution too, because we use gpio int!*/
/*
IMPORT STATUS sysLanIntDisable (int level);
IMPORT STATUS sysLanIntEnable (int level);
*/


/*
 * Offsets from pDrvCtrl->regBase of the ports used to access
 * the 8390 NIC registers.
 *
 * The names in parenthesis are the abbreviations by which
 * the registers are referred to in the 8390 data sheet.
 *
 * Some of the offsets appear more than once
 * because they have have relevant page 0 and page 1 values,
 * or they are different registers when read than they are
 * when written. The notation MSB indicates that only the
 * MSB can be set for this register, the LSB is assumed 0.
 */

#define NIC_COMMAND         0x0     /* (CR)                        */
#define NIC_PAGE_START      0x1     /* (PSTART)   MSB, write-only  */
#define NIC_PHYS_ADDR       0x1     /* (PAR0)     page 1           */
#define NIC_PAGE_STOP       0x2     /* (PSTOP)    MSB, write-only  */
#define NIC_BOUNDARY        0x3     /* (BNRY)     MSB              */
#define NIC_XMIT_START      0x4     /* (TPSR)     MSB, write-only  */
#define NIC_XMIT_STATUS     0x4     /* (TSR)      read-only  */
#define NIC_XMIT_COUNT_LSB  0x5     /* (TBCR0)    write-only */
#define NIC_XMIT_COUNT_MSB  0x6     /* (TBCR1)    write-only */
#define NIC_FIFO            0x6     /* (FIFO)     read-only  */
#define NIC_INTR_STATUS     0x7     /* (ISR)                 */
#define NIC_CURRENT         0x7     /* (CURR)     page 1     */
#define NIC_MC_ADDR         0x8     /* (MAR0)     page 1     */
#define NIC_CRDA_LSB        0x8     /* (CRDA0)               */
#define NIC_RMT_ADDR_LSB    0x8     /* (RSAR0)               */
#define NIC_CRDA_MSB        0x9     /* (CRDA1)               */
#define NIC_RMT_ADDR_MSB    0x9     /* (RSAR1)               */
#define NIC_RMT_COUNT_LSB   0xa     /* (RBCR0)    write-only */
#define NIC_RMT_COUNT_MSB   0xb     /* (RBCR1)    write-only */
#define NIC_RCV_CONFIG      0xc     /* (RCR)      write-only */
#define NIC_RCV_STATUS      0xc     /* (RSR)      read-only  */
#define NIC_XMIT_CONFIG     0xd     /* (TCR)      write-only */
#define NIC_FAE_ERR_CNTR    0xd     /* (CNTR0)    read-only  */
#define NIC_DATA_CONFIG     0xe     /* (DCR)      write-only */
#define NIC_CRC_ERR_CNTR    0xe     /* (CNTR1)    read-only  */
#define NIC_INTR_MASK       0xf     /* (IMR)      write-only */
#define NIC_MISSED_CNTR     0xf     /* (CNTR2)    read-only  */
#define NIC_RACK_NIC        0x10    /* Byte to read or write */
#define NIC_RESET           0x1f    /* (RESET)               */


/*
 * Constants for the NIC_COMMAND register.
 *
 * Start/stop the card, start transmissions, and select
 * which page of registers was seen through the ports.
 */

#define CR_STOP         (UCHAR)0x01        /* reset the card           */
#define CR_START        (UCHAR)0x02        /* start the card           */
#define CR_XMIT         (UCHAR)0x04        /* begin transmission       */
#define CR_NO_DMA       (UCHAR)0x20        /* stop remote DMA          */

#define CR_PS0          (UCHAR)0x40        /* low bit of page number   */
#define CR_PS1          (UCHAR)0x80        /* high bit of page number  */
#define CR_PAGE0        (UCHAR)0x00        /* select page 0            */
#define CR_PAGE1        CR_PS0             /* select page 1            */
#define CR_PAGE2        CR_PS1             /* select page 2            */

#define CR_DMA_WRITE    (UCHAR)0x10        /* Write                    */
#define CR_DMA_READ     (UCHAR)0x08        /* Read                     */
#define CR_SEND         (UCHAR)0x18        /* send                     */


/*
 * Constants for the NIC_XMIT_STATUS register.
 *
 * Indicate the result of a packet transmission.
 */

#define TSR_XMIT_OK     (UCHAR)0x01        /* transmit with no errors       */
#define TSR_COLLISION   (UCHAR)0x04        /* collided at least once        */
#define TSR_ABORTED     (UCHAR)0x08        /* too many collisions           */
#define TSR_NO_CARRIER  (UCHAR)0x10        /* carrier lost                  */
#define TSR_NO_CDH      (UCHAR)0x40        /* no collision detect heartbeat */


/*
 * Constants for the NIC_INTR_STATUS register.
 *
 * Indicate the cause of an interrupt.
 */

#define ISR_EMPTY       (UCHAR)0x00        /* no bits set in ISR                */
#define ISR_RCV         (UCHAR)0x01        /* packet received with no errors    */
#define ISR_XMIT        (UCHAR)0x02        /* packet transmitted with no errors */
#define ISR_RCV_ERR     (UCHAR)0x04        /* error on packet reception         */
#define ISR_XMIT_ERR    (UCHAR)0x08        /* error on packet transmission      */
#define ISR_OVERFLOW    (UCHAR)0x10        /* receive buffer overflow           */
#define ISR_COUNTER     (UCHAR)0x20        /* MSB set on tally counter          */
#define ISR_DMA_DONE    (UCHAR)0x40        /* RDC                               */
#define ISR_RESET       (UCHAR)0x80        /* (not an interrupt) card is reset  */


/*
 * Constants for the NIC_RCV_CONFIG register.
 *
 * Configure what type of packets are received.
 */

#define RCR_REJECT_ERR  (UCHAR)0x00        /* reject error packets         */
#define RCR_BROADCAST   (UCHAR)0x04        /* receive broadcast packets    */
#define RCR_MULTICAST   (UCHAR)0x08        /* receive multicast packets    */
#define RCR_ALL_PHYS    (UCHAR)0x10        /* receive ALL directed packets */
#define RCR_MONITOR     (UCHAR)0x20        /* don't collect packets        */


/*
 * Constants for the NIC_RCV_STATUS register.
 *
 * Indicate the status of a received packet.
 *
 * These are also used to interpret the status byte in the
 * packet header of a received packet.
 */

#define RSR_PACKET_OK   (UCHAR)0x01        /* packet received with no errors */
#define RSR_CRC_ERROR   (UCHAR)0x02        /* packet received with CRC error */
#define RSR_MULTICAST   (UCHAR)0x20        /* packet received was multicast  */
#define RSR_DISABLED    (UCHAR)0x40        /* received is disabled           */
#define RSR_DEFERRING   (UCHAR)0x80        /* receiver is deferring          */


/*
 * Constants for the NIC_XMIT_CONFIG register.
 *
 * Configures how packets are transmitted.
 */

#define TCR_NO_LOOPBACK (UCHAR)0x00        /* normal operation                   */
#define TCR_LOOPBACK    (UCHAR)0x02        /* loopback (set when NIC is stopped) */

#define TCR_INHIBIT_CRC (UCHAR)0x01        /* inhibit appending of CRC */

#define TCR_NIC_LBK     (UCHAR)0x02        /* loopback through the NIC */
#define TCR_SNI_LBK     (UCHAR)0x04        /* loopback through the SNI */
#define TCR_COAX_LBK    (UCHAR)0x06        /* loopback to the coax     */


/*
 * Constants for the NIC_DATA_CONFIG register.
 *
 * Set data transfer sizes.
 */

#define DCR_BYTE_WIDE   (UCHAR)0x00        /* byte-wide DMA transfers */
#define DCR_WORD_WIDE   (UCHAR)0x01        /* word-wide DMA transfers */

#define DCR_LOOPBACK    (UCHAR)0x00        /* loopback mode (TCR must be set) */
#define DCR_NORMAL      (UCHAR)0x08        /* normal operation                */

#define DCR_FIFO_2_BYTE (UCHAR)0x00        /* 2-byte FIFO threshhold */
#define DCR_FIFO_4_BYTE (UCHAR)0x20        /* 4-byte FIFO threshhold */
#define DCR_FIFO_8_BYTE (UCHAR)0x40        /* 8-byte FIFO threshhold */
#define DCR_FIFO_12_BYTE (UCHAR)0x60       /* 12-byte FIFO threshhold */
#define DCR_AUTO_INIT   (UCHAR)0x10        /* Auto-init to remove packets from ring */


/*
 * Constants for the NIC_INTR_MASK register.
 *
 * Configure which ISR settings actually cause interrupts.
 */

#define IMR_RCV         (UCHAR)0x01        /* packet received with no errors    */
#define IMR_XMIT        (UCHAR)0x02        /* packet transmitted with no errors */
#define IMR_RCV_ERR     (UCHAR)0x04        /* error on packet reception         */
#define IMR_XMIT_ERR    (UCHAR)0x08        /* error on packet transmission      */
#define IMR_OVERFLOW    (UCHAR)0x10        /* receive buffer overflow           */
#define IMR_COUNTER     (UCHAR)0x20        /* MSB set on tally counter          */


/*
 * The status of transmit buffers.
 */

typedef enum {
    EMPTY = 0x00,
    FULL = 0x02
} BUFFER_STATUS;


/*
 * controls the number of transmit buffers on the packet.
 * Choices are 1 through 12.
 */
#define DEFAULT_NUMBUFFERS 18


/*
 * Maximum number of transmit buffers on the card.
 */
#define MAX_XMIT_BUFS   18

/*
 * Definition of a transmit buffer.
 */
typedef UINT XMIT_BUF;

/*
 * Number of 256-byte buffers in a transmit buffer.
 */
#define BUFS_PER_TX 1

/*
 * Size of a single transmit buffer.
 */
#define TX_BUF_SIZE (BUFS_PER_TX*256)



/*
 * Default value for Adapter->MulticastListMax
 */
#define DEFAULT_MULTICASTLISTMAX 8




/*
 * Macros to extract high and low bytes of a word.
 */
#ifndef MSB 
#define MSB(Value) ((UCHAR)((((ULONG)Value) >> 8) & 0xff))
#endif
#ifndef LSB 
#define LSB(Value) ((UCHAR)(((ULONG)Value) & 0xff))
#endif



#ifdef    __cplusplus
}
#endif

#endif    /* __INCrtl8019Endh */

