/*
+=============================================================================+
;                  CONEXANT PROPRIETARY AND CONFIDENTIAL
;                         SOFTWARE FILE HEADER
;                Conexant Systems Inc. (C) 1998, 1999, 2000
;
;                           Newport Beach, CA
+=============================================================================+
;
; File:         igmp.h  
;
; Author:       NDD
;
; $Log: igmp_proxy.h,v $
; Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
; no message
;
; Revision 1.1.1.1  2004/01/16 09:32:37  SHAO-GH
; no message
;
; Revision 1.1.1.1  2003/12/23 10:28:51  SHAO-GH
; no message
;
; Revision 1.1.1.1  2003/11/21 08:29:12  SHAO-GH
; 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
;
 * 
 *    Rev 1.1.1.0   Nov 25 2002 17:15:46   dinhtm
 * Fixed: PR#761_IGMP doesn't work in PPPoE/
 * PPPoA.
 * PR#778 _ Bad Checksum found in UDP
 * streaming
 * 
 *    Rev 1.1   Apr 08 2002 20:15:16   vlassog
 * T211_BUILD:
 * "cookie" problem fixed.
 * 
 * 
 *    Rev 1.0   Oct 19 2001 17:12:58   dinhtm
 *  
;
+=============================================================================+
*/


#ifndef _IGMP_PROXY_H_
#define _IGMP_PROXY_H_
#define ETHER_ADDR_LEN   6

/*
 * IGMP packet format.
 */
struct igmpx {
	unsigned char	igmp_type;	/* version & type of IGMP message  */
	unsigned char	igmp_code;	/* code for routing sub-messages   */
	unsigned short	igmp_cksum;	/* IP-style checksum               */
	struct in_addr	igmp_group;	/* group address being reported    */
}; 
//__attribute__((__packed__));		/*  (zero for queries)             */

#define	IGMP_MINLEN		     8

#define	IGMP_HOST_MEMBERSHIP_QUERY	0x11  /* membership query      */
#define	IGMP_v1_HOST_MEMBERSHIP_REPORT	0x12  /* v1 membership report  */
#define	IGMP_DVMRP			0x13  /* DVMRP routing message */
#define	IGMP_PIM			0x14  /* PIM routing message   */
#define	IGMP_v2_HOST_MEMBERSHIP_REPORT	0x16  /* v2 membership report  */
#define	IGMP_HOST_LEAVE_MESSAGE		0x17  /* leave-group message   */
#define	IGMP_MTRACE_REPLY		0x1e  /* traceroute reply      */
#define	IGMP_MTRACE_QUERY		0x1f  /* traceroute query      */

typedef enum { LAN_PORT_TYPE, WAN_PORT_TYPE, UNKNOWN_PORT_TYPE } PORT_TYPE;
#define RIP_MCAST_ADDR 0xe0000009 	/* RIP group address is 224.0.0.9 */
#define IGMP_MAX_NUM_IF   20
#define IP_HDR_SIZE     20
#define UDP_PROTOCOL    17
#define IGMP_PROTOCOL	0x02

typedef struct {

    char          IfName[ 16 ];
    int           Unit;
    char          EtherAddress[ 6 ];
    unsigned long IpAddress;
    PORT_TYPE     Type;
#if (1) /* T211 */ 
	void*		  pCookie;
#else /* T211 */ 
    END_OBJ       *EndObj;
#endif /* T211 */ 
    struct mbuf   *pMblk;

} PER_INTERFACE;


typedef struct {

    int NumWanIf;
    int NumLanIf;
    int TotalIf;
    PER_INTERFACE If[ IGMP_MAX_NUM_IF ];

} IGMP_DATA_BASE;


void IGMP_Init( void );
void IGMP_ReplaceIp( char *if_name, int if_unit, unsigned long Ip );


#endif /* _NETINET_IGMP_H_ */
