/****************************************************************************
*
*   Name:           IpCtx.h
*
*   Description:    Ip runtime Context.
*
*   Copyright:      (c) 2002 Conexant Systems Inc.
*
*   Revision:   Date:       Author:             Description:
*
*   00.00.0000  10/24/02    George G. Vlasov    Created.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Oct 25 2002 15:54:26  $
****************************************************************************/

#ifndef IPCTX_H
#define IPCTX_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"
#include "bsptypes.h"

#include "JxArrSrv.h"

#include "IpDnsS.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

/****************************************************************************
*  Object declarations
****************************************************************************/

/****************************************************************************
*  Function prototypes
****************************************************************************/

/****************************************************************************
*
*	Name:			IpCtxDnsServerAdd
*	
*	Description:	Adds/sets DNS Server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCtxDnsServerAdd
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCtxDnsServerDelete
*	
*	Description:	Deletes DNS server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCtxDnsServerDelete
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCtxDnsServerFind
*	
*	Description:	Gets DNS server entry.
*	
*	Parameters: 	pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCtxDnsServerFind
(
	IP_DNS_SERVER_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			IpCtxDnsServerEnumerate
*	
*	Description:	Enumerates DNS server entry.
*					For internal use only.
*	
*	Parameters: 	Index	-	index of DNS server entry.
*	
*					pData	-	pointer to DNS server entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
IpCtxDnsServerEnumerate
(
	ULONG					Index, 
	IP_DNS_SERVER_DATA_T*	pData
);

#endif /* IPCTX_H */ 
