/*
 * $Log: nat_constants.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.2  2004/01/26 10:02:04  SHAO-GH
 * add some system head file
 *
 * Revision 1.16  2003/12/18 07:23:50  TTY
 * Added defines for  ICQ port.
 * Increase maximum IP forwarding entries to 50.
 * Increase maximum port forwarding entries to 30.
 *
 * Revision 1.15  2002/07/12 14:10:00  TTY
 * Changed FTP_MAXIMUM_PORT_STRING_LENGTH to 60, so that it can hold a longer PASV reply.
 *
 * 
 *    Revision 1.14   11 Dec 2001 09:57:36   TTY
 * Added NAT_N2P_CONTROL_TCP and NAT_N2P_CONTROL_UDP to NAT_PACKET_TYPES for 
 * Net2Phone support.
 * Added NUMBER_OF_ICMP_IDENT_NO_TRANSLATE, NUMBER_OF_TCP_PORT_NO_TRANSLATE and 
 * NUMBER_OF_UDP_PORT_NO_TRANSLATE for DMZ support.
 * 
 *    Revision 1.13   27 Jul 2001 17:06:44   TTY
 * Added NAT_FRAGMENT_ENTRY_TIMER
 * 
 *    Revision 1.12   28 Jun 2001 09:12:38   TTY
 * Added defines for ESP and ISAKMP.
 * NAT_TIMER_INTERVAL moved from val_nat.c
 * 
 *    Revision 1.11   21 Mar 2001 09:50:02   TTY
 * Modified constants for IRC DCC
 * 
 *    Revision 1.10   01 Mar 2001 17:58:16   TTY
 * Increase the maximum number of various static entries to 20
 * 
 *    Revision 1.9   09 Oct 2000 19:04:48   TTY
 * Added various packet types' defines for protocols used by Netmeeting.
 * Changed LOWER_EPHEMERAL_PORT_VALUE to 1864, to avoid conflict with Netmeeting
 * protocols' port number.
 * Changed port based static entries defines, to support special translation
 * entries used by Netmeeting
 * 
 *    Revision 1.8   14 Sep 2000 14:54:10   TTY
 * Changed UPPER_EPHEMERAL_PORT_VALUE from 8000 to 5030, because BPA will use
 * port 5040, and Dana uses 5555
 * 
 *    Revision 1.7   05 Sep 2000 18:37:08   TTY
 * Added defines for IRC DCC packets
 * 
 *    Revision 1.6   31 Jul 2000 10:46:14   TTY
 * Changed LOWER_EPHEMERAL_PORT_VALUE to 1724 to avoid conflict with PPTP.
 * Added defines for PPTP and GRE
 * 
 *    Revision 1.5   10 Jul 2000 14:13:28   TTY
 * Changed some constants values
 * 
 *    Revision 1.4   22 Feb 2000 17:52:02   TTY
 * 
 *    Revision 1.2   21 Feb 2000 15:40:16   TTY
 * Updated to Routerware's NAT release dated 28-Oct-1999
 * 
 *    Revision 1.1   23 Nov 1999 12:47:20   TTY
 * Initial revision.
 * 
 * 5     7/12/99 3:54p Nishit
 * Added support for FTP PASV command, fixed problems with NATG
 * 
 * 4     9/23/98 5:47p Nishit
 * the translation for packet received on local side is now done on local rx as against global tx
 * for NATS (NATG will follow); modified local rx filters,  changes for making code work on SENS
 * (VxWorks); added functionality for dial on demand global port; Upon rx, the first forking is
 * based on global/local rx port (used to be packet type) and then according to packet type; added
 * support for IP fragments
 * 
 * 3     9/08/98 5:04p Nishit
 * Updated copyright notice
 * 
*/
/************************************************************************/
/*	Copyright (C) 1997 - 1998 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
enum NAT_PACKET_TYPES
{
	NAT_IP,
	NAT_TCP,
	NAT_UDP,
	NAT_FTP,
	NAT_HTTP,
	NAT_ICMP_TRANSACTION,
	NAT_ICMP_DATAGRAM,
	NAT_RIP,
	NAT_OSPF,
	NAT_CUSEEME,
	NAT_GRE,
	NAT_PPTP,
    NAT_ESP,
    NAT_ISAKMP,
    NAT_IRC,
    NAT_ICQ,
#ifndef NO_ICQ2001B  /* ICQ2001b support */
    NAT_ICQ_DIRECT,
#endif
    NAT_LDAP,
    NAT_T120,
    NAT_H323_SETUP,
    NAT_H323_CONTROL,
    NAT_NETMEETING_AUDIO_CONTROL,
    NAT_RSVP,
    NAT_MSNP,
    NAT_N2P_CONTROL_TCP,
    NAT_N2P_CONTROL_UDP,
	NAT_UNKNOWN
};

enum NAT_PACKET_DIRECTION
{
	GLOBAL_RX_PACKET,
/*	GLOBAL_TX_PACKET, */
	LOCAL_RX_PACKET
/*	LOCAL_TX_PACKET */
};

#define SIZEOF_CLASS_C_ADDRESS_RANGE 256

enum NAT_PRINTF_GROUPS
{
	NAT_INITIALIZATION_PRINTF,
	NAT_DATA_PRINTF,
	NAT_TRACE_PRINTF,
	NAT_ERROR_PRINTF
};

#if !defined NUMBER_OF_IP_PORTS
	#define NUMBER_OF_IP_PORTS 								2
#endif

enum NAT_PORT_TYPE
{
	NAT_GLOBAL_PORT,
	NAT_LOCAL_PORT
};

enum NAT_TCP_PORT_STATE
{
	NAT_SYNCH_STATE,
	NAT_FIN_STATE,
	NAT_ESTABLISHED_STATE,
	NAT_INITIAL_STATE,
	NAT_DISCONNECTED_STATE,
	NAT_ILLEGAL_STATE
};

enum NAT_TCP_STATE_INPUT
{
	NAT_SYNCH,
	NAT_ACK,
	NAT_FIN,
	NAT_ESTABLISHED,
	NAT_RESET,
	NAT_FORCED_RESET
};

enum NAT_TCP_DELTA_SIGN
{
	DELTA_POSITIVE = 1,
	DELTA_NEGATIVE = -1
};

enum NAT_FILTER
{
	NAT_TRANSLATE,
	NAT_DONT_TRANSLATE,
	NAT_FILTER
};

#define NUMBER_OF_NAT_TCP_PORT_STATES						6
#define NUMBER_OF_NAT_TCP_STATE_INPUTS						6


/* Timers defines */
#define NAT_TIMER_INTERVAL 4        /* Timer interval in seconds */

#ifdef ORIGINAL_CONSTANTS
#define NAT_TCP_DISCONNECTED_TIMER							120
#define NAT_TCP_CONNECTING_TIMER							300
#define NAT_TCP_CONNECTED_TIMER							(3600 * 12)
#define NAT_TCP_CLOSING_TIMER								0
#define SEQUENCE_ENTRY_TIMER								180
#define NAT_TRANSLATION_ENTRY_TIMER						120
#define NAT_UDP_TRANSLATION_ENTRY_TIMER				120
#define NAT_ICMP_TRANSLATION_ENTRY_TIMER				120
#define NAT_DIAL_ON_DEMAND_GLOBAL_PORT_INACTIVITY_TIMEOUT_TIMER	300
#else
#define NAT_TCP_DISCONNECTED_TIMER                      60
#define NAT_TCP_CONNECTING_TIMER                        150
#define NAT_TCP_CONNECTED_TIMER                         (3600*12)
#define NAT_TCP_CLOSING_TIMER                           0
#define SEQUENCE_ENTRY_TIMER                            180
#define NAT_FRAGMENT_ENTRY_TIMER                        30
#define NAT_TRANSLATION_ENTRY_TIMER                     120
#define NAT_UDP_TRANSLATION_ENTRY_TIMER                 120
#define NAT_ICMP_TRANSLATION_ENTRY_TIMER                60
#define NAT_PPTP_TRANSLATION_ENTRY_TIMER                60
#define NAT_DIAL_ON_DEMAND_GLOBAL_PORT_INACTIVITY_TIMEOUT_TIMER	300
#endif

#define PPTP_SERVER_PORT								1723

/* ISAKMP default UDP port */
#define ISAKMP_PORT                                     500

#define FTP_SERVER_PORT										21
#define FTP_PORT_STRING										"PORT"
#define FTP_PORT_PARAMETER_STRING						"PORT %hu,%hu,%hu,%hu,%hu,%hu\r\n"
#define FTP_PORT_PARAMETER_COUNT							6
#define FTP_PORT_STRING_END_MARKER						'\n'
#define FTP_MAXIMUM_PORT_STRING_LENGTH					60
#define FTP_PASV_STRING										"PASV"
#define FTP_PASV_PARAMETER_STRING						"%d Entering Passive Mode (%hu,%hu,%hu,%hu,%hu,%hu)\r\n"
#define FTP_PASV_PARAMETER_COUNT							7
#define FTP_PASV_STRING_END_MARKER						'\n'
/* not ')' */
#define FTP_PASV_RETURN_CODE								227


/* IRC DCC constants */
#define IRC_SERVER_PORT_START                               6660
#define IRC_SERVER_PORT_END                                 6669
#define IRC_DCC_STRING                                      "DCC "
#define IRC_DCC_SEND_STRING                                 "SEND "
#define IRC_DCC_SEND_PARAMETER_STRING                       "%s %lu %lu %lu\x1"
#define IRC_DCC_SEND_PARAMETER_COUNT                        4
#define IRC_DCC_CHAT_STRING                                 "CHAT "
#define IRC_DCC_CHAT_PARAMETER_STRING                       "%s %lu %lu\x1"
#define IRC_DCC_CHAT_PARAMETER_COUNT                        3
#define IRC_DCC_ACCEPT_STRING                               "ACCEPT "
#define IRC_DCC_ACCEPT_PARAMETER_STRING                     "%s %lu %lu\x1"
#define IRC_DCC_ACCEPT_PARAMETER_COUNT                      3
#define IRC_DCC_RESUME_STRING                               "RESUME "
#define IRC_DCC_RESUME_PARAMETER_STRING                     "%s %lu %lu\x1"
#define IRC_DCC_RESUME_PARAMETER_COUNT                      3
#define IRC_DCC_STRING_END_MARKER                           0x1
#define IRC_MAXIMUM_DCC_STRING_LENGTH					    64

/* ICQ constants */
#define ICQ_SERVER_PORT                                     5190


/* Netmeeting constants */
#define LDAP_SERVER_PORT                                    389
#define T120_PORT                                           1503
#define H323_SETUP_PORT                                     1720
#define NETMEET_AUDIO_CONTROL_PORT                          1731
#define MSNP_SERVER_PORT                                    1863

#define CUSEEME_PORT											7648

#define NUMBER_OF_CORPORATE_NETWORK_ADDRESSES		5

#define MAXIMUM_NUMBER_OF_STATIC_ENTRIES	50

#define MAXIMUM_UDP_STATIC_ENTRIES          30
#define MAXIMUM_SPECIAL_UDP_STATIC_ENTRIES  20
#define TOTAL_NUMBER_OF_UDP_STATIC_ENTRIES  (MAXIMUM_UDP_STATIC_ENTRIES+MAXIMUM_SPECIAL_UDP_STATIC_ENTRIES)

#define MAXIMUM_TCP_STATIC_ENTRIES          30
#define MAXIMUM_SPECIAL_TCP_STATIC_ENTRIES  20
#define TOTAL_NUMBER_OF_TCP_STATIC_ENTRIES  (MAXIMUM_TCP_STATIC_ENTRIES+MAXIMUM_SPECIAL_TCP_STATIC_ENTRIES)

#define LOWER_EPHEMERAL_PORT_VALUE						1864
#define UPPER_EPHEMERAL_PORT_VALUE						5030

#define NUMBER_OF_ICMP_IDENT_NO_TRANSLATE               4
#define NUMBER_OF_TCP_PORT_NO_TRANSLATE                 4
#define NUMBER_OF_UDP_PORT_NO_TRANSLATE                 4
