/*
 * $Log: nat_packet_structures.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:43  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:17:49  SHAO-GH
 * no message
 *
 * Revision 1.4  2001/06/28 09:17:18  TTY
 * Added structures definition for ESP and ISAKMP packet.
 *
 * 
 *    Revision 1.3   09 Oct 2000 14:09:38   TTY
 * Added TCP_PSEUDO_HEADER structure for tcp checksum calculation purpose
 * 
 *    Revision 1.2   31 Jul 2000 10:52:00   TTY
 * Added structures for PPTP and GRE packets
 * 
 *    Revision 1.1   23 Nov 1999 12:47:18   TTY
 * Initial revision.
 * 
 * 5     11/06/98 5:47p Nishit
 * Fixed type incompatibility issues
 * 
 * 4     11/04/98 11:27a Nishit
 * Added enums ICMP_UNREACHABLE_CODE, ICMP_TIME_EXCEEDED_CODE and ICMP_REDIRECT_CODE
 * 
 * 3     10/02/98 9:37a Nishit
 * Modifications to accommodate dial-on-demand and inactivity time-out
 * 
 * 2     9/23/98 5:47p Nishit
 * the translation for packet received on local side is now done on local rx as against global tx
 * for NATS (NATG will follow); modified local rx filters,  changes for making code work on SENS
 * (VxWorks); added functionality for dial on demand global port; Upon rx, the first forking is
 * based on global/local rx port (used to be packet type) and then according to packet type; added
 * support for IP fragments
 * 
 * 1     9/08/98 6:49p Nishit
 * Removed including IP/TCP/RTM etc. files; instead, added nat_packet_structures.h
 * 
*/
/************************************************************************/
/*    Copyright (C) 1997 - 1998 RouterWare, Inc.                                   */
/*    Unpublished - rights reserved under the Copyright Laws of the            */
/*    United States.  Use, duplication, or disclosure by the                     */
/*    Government is subject to restrictions as set forth in                     */
/*    subparagraph (c)(1)(ii) of the Rights in Technical Data and             */
/*    Computer Software clause at 252.227-7013.                                        */
/*    RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#if !defined (NAT_PACKET_STRUCTURES)
    #define NAT_PACKET_STRUCTURES

#if !defined (_IPLIB_H_)

/* enums */

enum IP_PROTOCOL_VALUE
{
    RESERVED_PROTOCOL    = 0,           /* Reserved */
    ICMP_PROTOCOL        = 1,
    IGMP_PROTOCOL        = 2,
    IP_PROTOCOL            = 4,           /* IP in IP (encasulation) */
    TCP_PROTOCOL        = 6,
    IGP_PROTOCOL         = 9,           /* any private interior gateway */
    UDP_PROTOCOL        = 17,
    IDRP_PROTOCOL         = 45,          /* Inter-Domain Routing Protocol */
    RSVP_PROTOCOL         = 46,
    GRE_PROTOCOL        = 47,
    IPSEC_ESP_PROTOCOL = 50,
    IPSEC_AH_PROTOCOL = 51,
    IGRP_PROTOCOL        = 88,
    OSPF_PROTOCOL        = 89,          /* OSPFIGP */
    IPIP_PROTOCOL        = 94,          /* IP-within-IP Encapsulation Protocol */
    ETHERIP_PROTOCOL    = 97                 /* Ethernet-within-IP Encapsulation */
} _pack;


enum TCP_OPTION_KIND
{
    TCP_OPTION_MAX_SEGMENT_SIZE = 2
} _pack;


enum ICMP_MESSAGE_TYPE
{
    ICMP_ECHO_REPLY_TYPE                            = 0,
    ICMP_DESTINATION_UNREACHABLE_TYPE        = 3, 
    ICMP_SOURCE_QUENCH_TYPE                        = 4,
    ICMP_REDIRECT_TYPE                            = 5,
    ICMP_ECHO_REQUEST_TYPE                         = 8,
    ICMP_TIME_EXCEEDED_TYPE                        = 11,
    ICMP_PARAMETER_PROBLEM_TYPE                 = 12,
    ICMP_TIMESTAMP_TYPE                            = 13,
    ICMP_TIMESTAMP_REPLY_TYPE                    = 14,
    ICMP_INFO_REQUEST_TYPE                        = 15,
    ICMP_INFO_REPLY_TYPE                            = 16,
    ICMP_ADDRESS_MASK_TYPE                        = 17,
    ICMP_ADDR_MASK_REPLY_TYPE                    = 18,
    TOTAL_ICMP_TYPES                                = 19
} _pack;

enum ICMP_UNREACHABLE_CODE
{
    ICMP_NET_UNREACHABLE_CODE            = 0,
    ICMP_HOST_UNREACHABLE_CODE            = 1,
    ICMP_PROTOCOL_UNREACHABLE_CODE    = 2,
    ICMP_PORT_UNREACHABLE_CODE            = 3,
    ICMP_FRAGMENT_NEEDED_CODE            = 4,
    ICMP_ROUTE_FAIL_CODE                    = 5,
    ICMP_ADMIN_PROHIBIT_CODE           = 13,
    TOTAL_UNREACHABLE_CODES                = 14
} _pack;

enum ICMP_TIME_EXCEEDED_CODE
{
    ICMP_TTL_EXCEEDED_CODE            = 0,
    ICMP_FRAGMENT_EXCEEDED_CODE    = 1,
    TOTAL_TIME_EXCEEDED_CODES        = 2
} _pack;

enum ICMP_REDIRECT_CODE
{
    ICMP_REDIRECT_NET_CODE                    = 0,
    ICMP_REDIRECT_HOST_CODE                    = 1,
    ICMP_REDIRECT_TOS_AND_NET_CODE        = 2,
    ICMP_REDIRECT_TOS_AND_HOST_CODE        = 3,
    TOTAL_REDIRECT_CODES                        = 4
} _pack;

enum IP_SEND_CONFIRMATION
{ 
    IP_SEND_ILLEGAL_OPTION_LENGTH                     = 0,
    IP_SEND_NO_ROUTE                                         = 1,
    IP_SEND_BROADCAST_NOT_AVAILABLE                     = 2,
    IP_SEND_BROADCAST_NOT_ALLOWED                     = 3,
    IP_SEND_MESSAGE_TOO_BIG                             = 4,
    IP_SEND_FRAGMENTATION_NEEDED                         = 5,
    IP_SEND_PACKET_FILTERED                             = 6,
    IP_SEND_CANNOT_FRAGMENT                             = 7,
    IP_SEND_PORT_DISABLED                                 = 8,
    IP_SEND_PACKET_FRAGMENTED_OK                         = 9,
    IP_SEND_OK                                                 = 0x0a,
    IP_SEND_NO_ARP_TABLE_ENTRY                         = 0x0b,
    IP_SEND_REAL_PORT_DISABLED                         = 0x0c,
    IP_SEND_FAILED_TO_DETERMINE_OUTGOING_PORT        = 0x0d,
    IP_SEND_DID_NOT_FREE_PACKET                        = 0x0e,
    IP_SEND_FAIL                                            = 0x0f,
    TOTAL_IP_SEND_CONFIRMATIONS                         = 0x10
} _pack;


enum PPTP_MESSAGE_TYPE
{
    PPTP_CONTROL_TYPE                   = 1,
    PPTP_MANAGEMENT_TYPE                = 2
} _pack;

enum PPTP_CONTROL_MESSAGE_TYPE
{
    PPTP_CONTROL_OUTGOING_CALL_REQUEST  = 7,
    PPTP_CONTROL_OUTGOING_CALL_REPLY    = 8,
    PPTP_CONTROL_CALL_CLEAR_REQUEST     = 12,
    PPTP_CONTROL_CALL_DISCONNECT_NOTIFY = 13,
    PPTP_CONTROL_SET_LINK_INFO          = 15
} _pack;


#define RIP_PORT                                            520
#define IP_NO_SUCH_PORT                                    0xffff
#define IP_HEADER_LENGTH                                20

/* structurs */

typedef _struct IP_HEADER
{
#if !defined (BIG_ENDIAN)
    unsigned char               header_length:4;
    unsigned char               version:4;
#else
    unsigned char               version:4;
    unsigned char               header_length:4;
#endif
#if !defined (BIG_ENDIAN)
    unsigned char               unused:2;
    unsigned char               high_reliability:1;
    unsigned char               high_throughput:1;
    unsigned char               low_delay:1;
    unsigned char               precedence:3;
#else
    unsigned char               precedence:3;
    unsigned char               low_delay:1;
    unsigned char               high_throughput:1;
    unsigned char               high_reliability:1;
    unsigned char               unused:2;
#endif
    USHORT                      total_length;
    USHORT                      identifier;
#if !defined (BIG_ENDIAN)
    unsigned char               fragment_offset_most_significant_part:5;
    unsigned char               more_fragment_flag:1;
    unsigned char               do_not_fragment_flag:1;
    unsigned char               unused_bit:1;
#else
    unsigned char               unused_bit:1;
    unsigned char               do_not_fragment_flag:1;
    unsigned char               more_fragment_flag:1;
    unsigned char               fragment_offset_most_significant_part:5;
#endif
    BYTE                        fragment_offset_least_significant_part;
    BYTE                        time_to_live;
    BYTE                        protocol;
    USHORT                      header_checksum;
    ULONG                       source_ip_address;
    ULONG                       destination_ip_address;
} _pack IP_HEADER;


typedef _struct TCP_PSEUDO_HEADER
{
    ULONG                       source_ip_address;
    ULONG                       destination_ip_address;
    USHORT                      protocol;
    USHORT                      tcp_length;
} _pack TCP_PSEUDO_HEADER;

typedef _union    UNION_OPTIONS_OR_DATA
{
    BYTE            data;
    BYTE            ip_options;
} _pack UNION_OPTIONS_OR_DATA;

typedef _struct IP_PACKET
{
    UNION_MAC_HEADER              mac_header;
    IP_HEADER                     header;
    UNION_OPTIONS_OR_DATA         options_or_data;
} _pack IP_PACKET;

/* UDP */

typedef _struct UDP_HEADER
{
    USHORT         source_port;
    USHORT         destination_port;
    USHORT         length;
    USHORT         checksum;
} _pack UDP_HEADER;

typedef _struct    UDP_PACKET
{
    UNION_MAC_HEADER            mac_header;
    IP_HEADER                   ip_header;
    UDP_HEADER                  header;
    BYTE                        data[VARIABLE_NUMBER_OF_BYTES];
} _pack UDP_PACKET;


/* TCP */


typedef _struct TCP_OPTIONS                    /* The only option we will send in TCP is maximum segment size */
{
    BYTE                   kind;
    BYTE                   length;
    USHORT                 maximum_segment_size;
} _pack TCP_OPTIONS;


typedef _union TCP_UNION_OPTIONS_OR_DATA
{
    TCP_OPTIONS            tcp_options;
    BYTE                   tcp_data;
}  _pack TCP_UNION_OPTIONS_OR_DATA;


/* TCP header as defined by RFC793 */
typedef _struct TCP_HEADER
{
    USHORT                source_port;
    USHORT                destination_port;
    ULONG                 sequence_number;
    ULONG                 acknowledgment_number;
#if !defined (BIG_ENDIAN)
    unsigned char         reserved1:4;
    unsigned char         header_length:4;
#else
    unsigned char         header_length:4;
    unsigned char         reserved1:4;
#endif
#if !defined (BIG_ENDIAN)
    unsigned char         finished_flag:1;
    unsigned char         synchronize_flag:1;
    unsigned char         reset_flag:1;
    unsigned char         push_flag:1;
    unsigned char         acknowledgment_flag:1;
    unsigned char         urgent_flag:1;
    unsigned char         congest_flag:1;                /* not in rfc793 */
    unsigned char         reserved2:1;
#else
    unsigned char         reserved2:1;
    unsigned char         congest_flag:1;                /* not in rfc793 */
    unsigned char         urgent_flag:1;
    unsigned char         acknowledgment_flag:1;
    unsigned char         push_flag:1;
    unsigned char         reset_flag:1;
    unsigned char         synchronize_flag:1;
    unsigned char         finished_flag:1;
#endif
    USHORT                window_size;
    USHORT                checksum;
    USHORT                urgent_pointer;
} _pack TCP_HEADER;


typedef _struct TCP_PACKET
{
    UNION_MAC_HEADER                  mac_header;
    IP_HEADER                         ip_header;
    TCP_HEADER                        tcp_header;
    TCP_UNION_OPTIONS_OR_DATA         options_or_data;
} _pack TCP_PACKET;


/* ICMP */

typedef _struct ICMP_UNREACHABLE_MESSAGE
{
    USHORT            unused;
    USHORT            mtu;
    IP_HEADER         ip_data;
}_pack ICMP_UNREACHABLE_MESSAGE;

typedef _struct ICMP_PARAM_PROBLEM_MESSAGE
{
    BYTE              pointer;
    BYTE              unused[3];
    IP_HEADER         ip_data;
} _pack ICMP_PARAM_PROBLEM_MESSAGE;

typedef _struct ICMP_REDIRECT_MESSAGE
{
    ULONG             gateway;
    IP_HEADER         ip_data;
} _pack ICMP_REDIRECT_MESSAGE;

typedef _struct ICMP_ECHO_MESSAGE
{
    USHORT         identifier;
    USHORT         sequence_number;
} _pack ICMP_ECHO_MESSAGE;

typedef _struct ICMP_SOURCE_QUENCH_MESSAGE
{
    ULONG             unused;
    IP_HEADER         ip_data;
} _pack ICMP_SOURCE_QUENCH_MESSAGE;

typedef _struct ICMP_TIME_EXCEEDED_MESSAGE
{
    ULONG             unused;
    IP_HEADER         ip_data;
} _pack ICMP_TIME_EXCEEDED_MESSAGE;

typedef _struct ICMP_TIMESTAMP_MESSAGE
{
    USHORT         identifier;
    USHORT         sequence_number;
    ULONG          orginate_timestamp;
    ULONG          receive_timestamp;
    ULONG          transmit_timestamp;
} _pack ICMP_TIMESTAMP_MESSAGE;

typedef _struct ICMP_ADDRESS_MASK_MESSAGE
{
    USHORT         identifier;
    USHORT         sequence_number;
    ULONG          mask;
} _pack ICMP_ADDRESS_MASK_MESSAGE;

typedef _union UNION_ICMP_PACKET_OPTIONS
{
    ICMP_UNREACHABLE_MESSAGE           unreachable_message;
    ICMP_PARAM_PROBLEM_MESSAGE         parameter_problem_message;
    ICMP_REDIRECT_MESSAGE              redirect_message;
    ICMP_ECHO_MESSAGE                  echo_message;
    ICMP_SOURCE_QUENCH_MESSAGE         source_quench_message;
    ICMP_TIME_EXCEEDED_MESSAGE         time_exceeded_message;
    ICMP_TIMESTAMP_MESSAGE             timestamp_message;
    ICMP_ADDRESS_MASK_MESSAGE          address_mask_message;
    ULONG                              unused;
} _pack UNION_ICMP_PACKET_OPTIONS;

typedef _union    UNION_ICMP_CODES
{
    BYTE_ENUM (ICMP_UNREACHABLE_CODE)       unreachable;
    BYTE_ENUM (ICMP_TIME_EXCEEDED_CODE)     time_to_exceed;
    BYTE_ENUM (ICMP_REDIRECT_CODE)          redirect;
    BYTE                                    generic;
} _pack UNION_ICMP_CODES;

typedef _struct    ICMP_HEADER
{
    BYTE_ENUM (ICMP_MESSAGE_TYPE)           type;
    BYTE                                    code;
    USHORT                                  checksum;
    UNION_ICMP_PACKET_OPTIONS               option;
} _pack ICMP_HEADER;


typedef _struct ICMP_PACKET
{
    UNION_MAC_HEADER             mac_header;
    IP_HEADER                    ip_header;
    ICMP_HEADER                    header;
} _pack ICMP_PACKET;


/* PPTP in GRE */

typedef _struct    PPTP_GRE_HEADER
{
#if !defined (BIG_ENDIAN)
    unsigned char               checksum_present:1;
    unsigned char               routing_present:1;
    unsigned char               key_present:1;
    unsigned char               sequence_present:1;
    unsigned char               strict_source_route_present:1;
    unsigned char               recursion_control:3;
#else
    unsigned char               recursion_control:3;
    unsigned char               strict_source_route_present:1;
    unsigned char               sequence_present:1;
    unsigned char               key_present:1;
    unsigned char               routing_present:1;
    unsigned char               checksum_present:1;
#endif
#if !defined (BIG_ENDIAN)
    unsigned char               ack_sequence_present:1;
    unsigned char               flags:4;
    unsigned char               version:3;
#else
    unsigned char               version:3;
    unsigned char               flags:4;
    unsigned char               ack_sequence_present:1;
#endif
    USHORT                      protocol;
    USHORT                      length;
    USHORT                      call_id;
    ULONG                       sequence_number;
    ULONG                       ack_number;
} _pack PPTP_GRE_HEADER;


typedef _struct PPTP_GRE_PACKET
{
    UNION_MAC_HEADER             mac_header;
    IP_HEADER                    ip_header;
    PPTP_GRE_HEADER              header;
} _pack PPTP_GRE_PACKET;



typedef _struct PPTP_OUTGOING_CALL_REQUEST
{
    USHORT         call_id;
    USHORT         call_serial_number;
    ULONG          minimum_bps;
    ULONG          maximum_bps;
    ULONG          bearer_type;
    ULONG          framing_type;
    USHORT         packet_receive_window_size;
    USHORT         packet_processing_delay;
    USHORT         phone_number_length;
    USHORT         reserved1;
    BYTE           phone_number[64]; 
    BYTE           subaddress[64]; 
} _pack PPTP_OUTGOING_CALL_REQUEST;


typedef _struct PPTP_OUTGOING_CALL_REPLY
{
    USHORT         call_id;
    USHORT         peer_call_id;
    BYTE           result_code;
    BYTE           error_code;
    USHORT         cause_code;
    ULONG          connect_speed;
    USHORT         packet_receive_window_size;
    USHORT         packet_processing_delay;
    ULONG          physical_channel_id;
} _pack PPTP_OUTGOING_CALL_REPLY;

typedef _struct PPTP_CALL_CLEAR_REQUEST
{
    USHORT         call_id;
    USHORT         reserved1;
} _pack PPTP_CALL_CLEAR_REQUEST;

typedef _struct PPTP_CALL_DISCONNECT_NOTIFY
{
    USHORT         call_id;
    BYTE           result_code;
    BYTE           error_code;
    USHORT         cause_code;
    USHORT         reserved1;
    BYTE           call_statistics[128];
} _pack PPTP_CALL_DISCONNECT_NOTIFY;

typedef _struct PPTP_SET_LINK_INFO
{
    USHORT         peer_call_id;
    USHORT         reserved1;
    ULONG          send_accm;
    ULONG          receive_accm;
} _pack PPTP_SET_LINK_INFO;


typedef _union UNION_PPTP_PACKET_OPTIONS
{
    PPTP_OUTGOING_CALL_REQUEST      outgoing_call_request;
    PPTP_OUTGOING_CALL_REPLY        outgoing_call_reply;
    PPTP_CALL_CLEAR_REQUEST         call_clear_request;
    PPTP_CALL_DISCONNECT_NOTIFY     call_disconnect_notify;
    PPTP_SET_LINK_INFO              set_link_info;
    ULONG                           unused;
} _pack UNION_PPTP_PACKET_OPTIONS;

typedef _struct PPTP_HEADER
{
    USHORT                      length;
    USHORT                      message_type;
    ULONG                       magic_cookie;
    USHORT                      control_message_type;
    USHORT                      reserved0;
    UNION_PPTP_PACKET_OPTIONS   option;
} _pack PPTP_HEADER;

typedef _struct PPTP_TCP_PACKET
{
    UNION_MAC_HEADER             mac_header;
    IP_HEADER                    ip_header;
    TCP_HEADER                   tcp_header;
    PPTP_HEADER                  header;
} _pack PPTP_TCP_PACKET;


/* IPSEC ESP */

typedef _struct ESP_HEADER
{
    ULONG                       security_index;    /* security parameter index */
    ULONG                       sequence_number;
} _pack ESP_HEADER;


typedef _struct ESP_PACKET
{
    UNION_MAC_HEADER             mac_header;
    IP_HEADER                    ip_header;
    ESP_HEADER                   header;
} _pack ESP_PACKET;


typedef _struct ISAKMP_HEADER
{
    unsigned long long      icookie;        /* initiator cookie */
    unsigned long long      rcookie;        /* responder cookie */
} _pack ISAKMP_HEADER;

typedef _struct ISAKMP_PACKET
{
    UNION_MAC_HEADER             mac_header;
    IP_HEADER                    ip_header;
    UDP_HEADER                   udp_header;
    ISAKMP_HEADER                header;
} _pack ISAKMP_PACKET;


/* Misc. */

typedef _union        UNION_IP_PACKET
{
/*    ARP_PACKET             arp;
    RARP_PACKET            rarp;*/
    IP_PACKET               ip;
    ICMP_PACKET             icmp;
/*    RIP_PACKET            rip; */ /* not needed for NAT */
    UDP_PACKET              udp;
} _pack UNION_IP_PACKET;

/* others */

#define MAXIMUM_IP_OPTION_LENGTH                                40                /* Largest option field, bytes */

typedef _union UNION_USER_OPTIONS
{
    BYTE             char_options[MAXIMUM_IP_OPTION_LENGTH];                            /* according to rfc791 format in network order */
    ULONG            ulong_options[MAXIMUM_IP_OPTION_LENGTH / sizeof (ULONG)];
} _pack UNION_USER_OPTIONS;

typedef _struct IP_UPPER_LAYER_PARAMETERS
{
    ULONG                                 source_address;
    ULONG                                 destination_address;
    BYTE_ENUM (BOOLEAN)                 do_not_fragment_flag;
#if !defined (BIG_ENDIAN)
    unsigned char         unused:2;
    unsigned char         high_reliability:1;
    unsigned char         high_throughput:1;
    unsigned char         low_delay:1;
    unsigned char         precedence:3;
#else
    unsigned char         precedence:3;
    unsigned char         low_delay:1;
    unsigned char         high_throughput:1;
    unsigned char        high_reliability:1;
    unsigned char        unused:2;
#endif
    USHORT                                 sequence_id;
    BYTE                                     time_to_live;
    BYTE                                     protocol;
    BYTE                                     option_length;
    UNION_USER_OPTIONS                 user_options;
    void                                     *vptr_cached_route;             /* address of cached route stored in user's space */
    USHORT                                virtual_port_number;            /* do not route, send out through this port if not NO_SUCH_PORT */
    ULONG                                 gateway;
} _pack IP_UPPER_LAYER_PARAMETERS;


typedef _struct IP_PARAMETERS
{
    USHORT                                                 header_length;
    USHORT                                                total_length;
    ULONG                                                 source_address;
    ULONG                                                 destination_address;
    USHORT                                                offset;
#if !defined (BIG_ENDIAN)
    unsigned char         unused:2;
    unsigned char         high_reliability:1;
    unsigned char         high_throughput:1;
    unsigned char         low_delay:1;
    unsigned char         precedence:3;
#else
    unsigned char         precedence:3;
    unsigned char         low_delay:1;
    unsigned char         high_throughput:1;
    unsigned char        high_reliability:1;
    unsigned char        unused:2;
#endif
    USHORT                                                 id;
    BYTE                                                     time_to_live;
    BYTE_ENUM (IP_PROTOCOL_VALUE)                    protocol;
    BYTE                                                     options_length;
    BYTE_ENUM (BOOLEAN)                                 do_not_fragment_flag;
    BYTE_ENUM (BOOLEAN)                                 more_fragment_flag;
    BYTE                                                    version;
    USHORT                                                checksum;
    USHORT                                                rx_port_number;
    ULONG                                                 gateway;
    BYTE_ENUM (BOOLEAN)                                 union_ip_packet_is_to_be_freed;
    BYTE_ENUM (BOOLEAN)                                 packet_forwarded_by_upper_layer;
    BYTE_ENUM (BOOLEAN)                                 packet_recognized_by_upper_layer;
#if defined (__IP_MULTICAST_EXTENSIONS__)
    BYTE                                                options [MAXIMUM_IP_OPTION_LENGTH];
#endif /* __IP_MULTICAST_EXTENSIONS__ */
} _pack IP_PARAMETERS;

typedef struct IP_ROUTE_CACHE_ENTRY
{
    UINT        fake_a;
} IP_ROUTE_CACHE_ENTRY;

#endif /* _IPLIB_H_ */

#endif /* NAT_PACKET_STRUCTURES */

