/* dhcpcLib.h - DHCP include file for user interface of runtime client */

/* Copyright 1984 - 1997 Wind River Systems, Inc. */

/*
modification history
____________________
01f,06oct97,spm  added prototypes for user-callable routines
01e,06aug97,spm  added definitions for C++ compilation
01d,30apr97,spm  changed dhcpcOptionGet() prototype to return length
01c,07apr97,spm  added prototypes for new functions
01b,29jan97,spm  added support for little-endian architectures
01a,03oct96,spm  created.
*/

#ifndef __INCdhcpcLibh
#define __INCdhcpcLibh

#ifdef __cplusplus
extern "C" {
#endif

#include "dhcp/dhcpc.h" 	/* DHCP client data structures */

#define S_dhcpcLib_NOT_INITIALIZED           (M_dhcpcLib | 1)
#define S_dhcpcLib_NO_DEVICE                 (M_dhcpcLib | 2)
#define S_dhcpcLib_MAX_LEASES_REACHED        (M_dhcpcLib | 3)
#define S_dhcpcLib_MEM_ERROR                 (M_dhcpcLib | 4)
#define S_dhcpcLib_BAD_COOKIE                (M_dhcpcLib | 5)
#define S_dhcpcLib_NOT_BOUND                 (M_dhcpcLib | 6)
#define S_dhcpcLib_BAD_OPTION                (M_dhcpcLib | 7)
#define S_dhcpcLib_OPTION_NOT_PRESENT        (M_dhcpcLib | 8)
#define S_dhcpcLib_TIMER_ERROR               (M_dhcpcLib | 8)
#define S_dhcpcLib_OPTION_NOT_STORED         (M_dhcpcLib | 9)

IMPORT void * 	pDhcpcBootCookie[]; 	/* User access to boot-time lease. */

/* DHCP data structures for option requests and retrieval. */

/* DHCP client user interface routines */

IMPORT STATUS dhcpcLibInit (int, int, int, int, int, int);
IMPORT void * dhcpcInit (struct ifnet *, BOOL);
IMPORT STATUS dhcpcEventHookAdd (char *, FUNCPTR);
IMPORT STATUS dhcpcEventHookDelete (void *);
IMPORT STATUS dhcpcCacheHookAdd (FUNCPTR);
IMPORT STATUS dhcpcCacheHookDelete (void);
IMPORT STATUS dhcpcOptionSet (void *, int, long, long, char *);
IMPORT STATUS dhcpcBind (void *, BOOL);
IMPORT STATUS dhcpcVerify (void *);
IMPORT STATUS dhcpcOptionGet (void *, int, int *, char *);
IMPORT STATUS dhcpcServerGet (void *, struct in_addr *);
IMPORT STATUS dhcpcTimerGet (void *, int *, int *);
IMPORT STATUS dhcpcParamsGet (void *, struct dhcp_param *);
IMPORT STATUS dhcpcRelease (void *);
IMPORT STATUS dhcpcShutdown (void);

IMPORT void * dhcpc_FindCookieByIfName (char *);
IMPORT STATUS dhcpc_AddCookie (void *);

#ifdef __cplusplus
}
#endif

#endif
