/****************************************************************************
*
*	Name:			RipCfg.h
*
*	Description:	Rip Configuration declarations.
*
*	Copyright:		(c) 2002 Conexant Systems Inc.
*
*	Revision:	Date:		Author: 			Description:
*
*	00.00.0000	07/10/02	George G. Vlasov	Created.
*
*****************************************************************************
*	$Author: shao-gh $
*	$Revision: 1.1.1.1 $
*	$Modtime:   Mar 10 2003 09:43:48  $
****************************************************************************/

#ifndef RIPCFG_H
#define RIPCFG_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"

#include "JxCfgMgr.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef 
enum RIP_CFG_LISTENER_MODE_T
{
	RIP_CFG_LISTENER_MODE_V1,
	RIP_CFG_LISTENER_MODE_V2,
	RIP_CFG_LISTENER_MODE_V1_V2,

	RIP_CFG_LISTENER_MODE_MAX
} RIP_CFG_LISTENER_MODE_T;

typedef 
enum RIP_CFG_SUPPLIER_MODE_T
{
	RIP_CFG_SUPPLIER_MODE_DISABLED,
	RIP_CFG_SUPPLIER_MODE_V1_BROADCAST,
	RIP_CFG_SUPPLIER_MODE_V2_BROADCAST,
	RIP_CFG_SUPPLIER_MODE_V2_MULTICAST,

	RIP_CFG_SUPPLIER_MODE_MAX
} RIP_CFG_SUPPLIER_MODE_T;

typedef
struct RIP_CFG_DATA_T
{
	BOOL	GatewayEnabled;
	BOOL	BorderGatewayEnabled;
	DWORD	TimerRate;
	DWORD	SupplyInterval;
	DWORD	ExpireInterval;
	DWORD	GarbageInterval;
} RIP_CFG_DATA_T;

typedef
struct RIP_CFG_ENTRY_DATA_T
{
	BOOL					Enabled;
	NET_IF_ALIAS_T			NetIfAlias;
	RIP_CFG_LISTENER_MODE_T ListenerMode;
	RIP_CFG_SUPPLIER_MODE_T SupplierMode;
} RIP_CFG_ENTRY_DATA_T;

/****************************************************************************
*  Function prototypes
****************************************************************************/

/****************************************************************************
*
*	Name:			RipCfgCfgSet
*	
*	Description:	Sets RIP parameters.
*	
*	Parameters: 	pData	-	pointer to RIP configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgSet
(
	RIP_CFG_DATA_T* pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgGet
*	
*	Description:	Gets RIP parameters.
*	
*	Parameters: 	pData	-	pointer to RIP configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgGet
(
	RIP_CFG_DATA_T* pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgEntryAdd
*	
*	Description:	Adds/sets RIP interface entry.
*	
*	Parameters: 	pData	-	pointer to RIP entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgEntryAdd
(
	RIP_CFG_ENTRY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgEntryDelete
*	
*	Description:	Deletes RIP interface entry.
*	
*	Parameters: 	pData	-	pointer to RIP entry configuration structure.
*								NetIfAlias value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgEntryDelete
(
	RIP_CFG_ENTRY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgEntryGet
*	
*	Description:	Gets RIP interface entry.
*	
*	Parameters: 	pData	-	pointer to RIP entry configuration structure.
*								NetIfAlias value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgEntryGet
(
	RIP_CFG_ENTRY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgEntryEnumerate
*	
*	Description:	Enumerates RIP interface entry.
*	
*	Parameters: 	Index	-	index of RIP entry.
*	
*					pData	-	pointer to RIP entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgEntryEnumerate
(
	ULONG					Index, 
	RIP_CFG_ENTRY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			RipCfgCfgNetIfRegister
*	
*	Description:	Creates default RIP interface entry for specified 
*					interface.
*	
*	Parameters: 	Index	-	index of RIP entry.
*	
*					pData	-	pointer to RIP entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgCfgNetIfRegister
(
	NET_IF_ALIAS_T	NetIfAlias
);

/****************************************************************************
*
*	Name:			RipCfgCfgGet
*	
*	Description:	Gets RIP parameters from active configuration.
*	
*	Parameters: 	pData	-	pointer to RIP configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgGet
(
	RIP_CFG_DATA_T* pData
);

/****************************************************************************
*
*	Name:			RipCfgEntryGet
*	
*	Description:	Gets RIP interface entry from active configuration.
*					For internal use only.
*	
*	Parameters: 	pData	-	pointer to RIP entry configuration structure.
*								NetIfAlias value must be specified.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgEntryGet
(
	RIP_CFG_ENTRY_DATA_T*	pData
);

/****************************************************************************
*
*	Name:			RipCfgEntryEnumerate
*	
*	Description:	Enumerates RIP interface entry from active configuration.
*					For internal use only.
*	
*	Parameters: 	Index	-	index of RIP entry.
*	
*					pData	-	pointer to RIP entry configuration structure.
*	
*	Returns:		TRUE if success, otherwise FALSE.
*
****************************************************************************/

BOOL
RipCfgEntryEnumerate
(
	ULONG					Index, 
	RIP_CFG_ENTRY_DATA_T*	pData
);

void
RipCfgShow
(
);

#endif /* RIPCFG_H */ 
