/***************************************************************************** 
$Header:   P:/d874/hasbani/archives/snarf/br_backdoor.c_v   

FILE NAME:	br_backdoor.c

            Copyright 2001 Conexant Systems, Inc. 
            ALL RIGHTS RESERVED
            This file is Conexant proprietary, and all Conexant corporate 
            policies regarding source-file distribution must be observed.

DESCRIPTION:This file implements in bridge module the backdoor access to the
            CPE Web Configuration.

$Archive:   P:/d874/hasbani/archives/snarf/br_backdoor.c_v  $
$Revision: 1.1.1.1 $
$Date: 2004/04/01 09:10:04 $

$Log: br_backdoor.c,v $
Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
no message

Revision 1.2  2004/02/25 08:13:34  shao-gh
no message

Revision 1.1.1.1  2004/01/16 09:32:57  SHAO-GH
no message

Revision 1.1.1.1  2003/12/23 10:29:08  SHAO-GH
no message

Revision 1.1.1.1  2003/11/21 08:29:26  SHAO-GH
2003.11.20 Shao Guohua use win cvs first time from sourcesafe 

 * 
 *    Rev 1.1   May 29 2002 13:01:34   liniy
 * Added code for T2.11.
 * 
 *    Rev 1.0   Dec 19 2001 11:54:58   liniy
 *  
********************************************************************************/

#include "netinet/if_ether.h"
#include "end.h"
#include "http/httpLib.h"                
#include "http/httpRpms.h"                

#include "br_control.h"
#include "br_backdoor.h"

#define SRC_IP      0
#define DEST_IP     1

#define MBLK_TO_IP(m,ofs)   \
        ((*(UINT16 * ) ( m->mBlkHdr.mData + ofs + 2 ) << 16 ) +     \
        *( UINT16 * ) ( m ->mBlkHdr.mData + ofs ))


BR_BACKDOOR_STRUCT  br_backdoor;
BR_BACKDOOR_STRUCT  *pBrBackdoor = &br_backdoor;
UINT32				bridge_lanIpAddr_long = 0;


#ifdef BRDG_BACKDOOR
/******************************************************************************
|
|  Function:    br_SetBackdoorAccess
|
|  Description: Set up temporary configuration to route backdoor packets.
|               1. add an entry to route table
|               2. add an HTTP IP entry to backdoor location list.
|               3. start a timer
|               Upon timer expiration, both route table entry and HTTP IP entry
|               will be removed.
|
|  Parameters:  srcIpVal    source IP address
|               srcIpVal1   source IP address masked with backdoor mask
|
|  Returns:     TRUE    New route entry and HTTP IP entry are added and timer
|                       is started.
|               FALSE   New route entry and HTTP IP entry are not added.
|
*******************************************************************************/
BOOL br_SetBackdoorAccess( UINT32 srcIpVal, UINT32 srcIpVal1 )
{
    static char             allowed_ip[16];
    char                    Ip4, Ip3, Ip2, Ip1;
    unsigned short          i = 0;
    HTTP_GEN_LIST_ENTRY_ID  locId = NULL;
    BOOL                    status = TRUE;

    /* Only do this if there is no active backdoor setup. */
    if ( !pBrBackdoor->RunningTimer )
    {
        /* route add */
        inet_ntoa_b (( struct in_addr ){ srcIpVal1 }, pBrBackdoor->AccessRouteIpString );
        routeAdd ( pBrBackdoor->AccessRouteIpString, pBrBackdoor->AccessIpString );

        /* Add HTTP IP Entry */
        Ip4   = srcIpVal >> 24;
        Ip3   = srcIpVal >> 16;
        Ip2   = srcIpVal >> 8;
        Ip1   = srcIpVal;
        
        sprintf( allowed_ip, "%d.%d.%d.*", Ip1, Ip2, Ip3 );
        pBrBackdoor->httpIpEntryId = httpIpConfAdd ("Backdoor" , allowed_ip);
        
        /* Get HTTP location index. 
           This could be done only once during initialization.
           It is done here in case HTTP initialization is done later than
           Backdoor initialization.
        */
        httpIpConfLock();

#if (!T211_BUILD)
        locId = httpIpLocationIterator ( &i );
        while ( locId )
#else        
        while ( httpIpLocationIterator ( &locId ) != NULL )
#endif  /* (!T211_BUILD) */
        {
            if ( strcmp( locId->szId, "Backdoor" ) == 0 )
            {
                pBrBackdoor->httpLocationEntryId = locId;
                break;
            }
#if (!T211_BUILD)
            locId = httpIpLocationIterator ( &i );
#endif  /* (!T211_BUILD) */
        }
        httpIpConfUnlock();
        
        /* Start timer */
        pBrBackdoor->RunningTimer = pBrBackdoor->TimerReload;     // in seconds
    }
    else
    {
        status = FALSE;
    } /* if ( !pBrBackdoor->RunningTimer ) */
    
    return( status );
}

#if 1
/******************************************************************************
|
|  Function:    br_GetIp
|
|  Description: This function gets the IP address from the packet.
|               It observs the ARM 4-byte boundary.
|
|  Parameters:  M_BLK_ID    pNetBuff    Ethernet packet
|               UINT16      etherType   type field of the Ethernet packet
|               UINT16      src_dest    SRC_IP or DEST_IP
|
|  Returns:     the requested IP address from the packet
|
*******************************************************************************/
UINT32  br_GetIp ( M_BLK_ID pNetBuff, UINT16 etherType, UINT16 src_dest )
{
    UINT32  ipOffset;

    if ( etherType == ETHERTYPE_IP )
    {
        if ( src_dest == SRC_IP )
            ipOffset = 26;
        else
            ipOffset = 30;
    }
    else if ( etherType == ETHERTYPE_ARP )
    {
        if ( src_dest == SRC_IP )
            ipOffset = 28;
        else
            ipOffset = 38;
    }
    return MBLK_TO_IP ( pNetBuff, ipOffset );
}

/******************************************************************************
|
|  Function:    br_IsBackdoor
|
|  Description: This is the backdoor web access logic to allow access to CPE
|               config web page access even if the CPE is misconfigured.  This
|               is done by checking every imcoming packet from the designated
|               backdoor port.
|
|  Parameters:  M_BLK_ID    pNetBuff    packet with link info
|
|  Returns:     FALSE   This packet is not a backdoor access
|               TRUE    This packet is a backdoor access
|
*******************************************************************************/
BOOL br_IsBackdoor ( M_BLK_ID pNetBuff, UINT8 *dest_mac )
{
    BOOL                backdoorAccess = FALSE;
    struct ether_header *pEtherHdr = NULL;
    UINT16              etherType;
    UINT32              srcIpVal, desIpVal, d, srcIpVal1;
    char                srcIpStr[INET_ADDR_LEN];
    BR_PORT             *pPort;

    if ( !pBrBackdoor->pBridgePort )
        return( FALSE );

    /*
       Do a routeAdd when all of the following conditions are met:
       - not destined to me (MAC DA is not my MAC)
       - came from the designated backdoor port
       - destined IP subnet is the same as the subnet of designated backdoor port
       - the source IP subnet is not the same as the the subnet of the designated backdoor port
         (this is necessary to avoid routeAdd for non-backdoor ARP request)
    */

    pEtherHdr = mtod ( pNetBuff, struct ether_header * );
    etherType = ntohs ( pEtherHdr->ether_type );

    /* Check all IP packets.  If the dest IP is the designated backdoor port, and the
       source IP's subnet is not the same as the subnet of the designated backdoor port,
       the packet is treated as a backdoor access packet.
    */
    /* Check all ARP packets.  If the dest IP is the designated backdoor port, and the
       source IP's subnet is not the same as the subnet of the designated backdoor port,
       the packet is treated as a backdoor access packet.
    */
    if (( etherType == ETHERTYPE_IP ) || ( etherType == ETHERTYPE_ARP ))
    {
        desIpVal = br_GetIp ( pNetBuff, etherType, DEST_IP );
        if ( desIpVal == pBrBackdoor->AccessIpValue )
        {
            srcIpVal = br_GetIp ( pNetBuff, etherType, SRC_IP );
            srcIpVal1 = srcIpVal & pBrBackdoor->AccessMaskValue;
            if ( srcIpVal1 != ( pBrBackdoor->AccessIpValue & pBrBackdoor->AccessMaskValue ))
            //if (( srcIpVal & pBrBackdoor->AccessMaskValue ) != ( pBrBackdoor->AccessIpValue & pBrBackdoor->AccessMaskValue ))
                backdoorAccess = TRUE;
        }
        else if ( etherType == ETHERTYPE_ARP )
        {
            /* The following code is necessary to properly route the ARP response from the PC
               to the protocol stack for the backdoor access.  The ARP response contains the
               the dest IP and dest MAC of the other port's my_mac.
            */
            for ( pPort = pBrBackdoor->pBridgePort->pBridge->pFirstPort;
                    ( pPort != NULL );
                    pPort = pPort->pNext )
            {
                if ( pPort != pBrBackdoor->pBridgePort )
                {
                    if ( 0 == memcmp ( dest_mac, pPort->myMac, 6 ))
                    {
                        backdoorAccess = TRUE;
                        break;
                    }
                }
            }
        }
    }

    /* If this is a backdoor access packet, pass it up to the protocol stack.
       If the backdoor timer is expired, add the temporary route entry for the backdoor
       access.  The temporary route entry will be automatically deleted after the specified
       periord of time of inactive backdoor access.
    */
    if ( backdoorAccess )
        br_SetBackdoorAccess( srcIpVal, srcIpVal1 );

    return ( backdoorAccess );
}

#else

/******************************************************************************
|
|  Function:    br_IsBackdoor
|
|  Description: This is the backdoor web access logic to allow access to CPE
|               config web page access even if the CPE is misconfigured.  This
|               is done by checking every imcoming packet from the designated
|               backdoor port.
|
|  Parameters:  M_BLK_ID    pNetBuff    packet with link info
|
|  Returns:     FALSE   This packet is not a backdoor access
|               TRUE    This packet is a backdoor access
|
*******************************************************************************/
BOOL br_IsBackdoor ( M_BLK_ID pNetBuff, UINT8 *dest_mac )
{
    BOOL                backdoorAccess = FALSE;
    struct ether_header *pEtherHdr = NULL;
    UINT16              etherType;
    UINT32              srcIpVal, desIpVal, d, srcIpVal1;
    char                srcIpStr[INET_ADDR_LEN];
    int                 adsl;
    BR_PORT             *pPort;

    if ( !pBrBackdoor->pBridgePort )
        return( FALSE );

    /* This is the backdoor web access logic to allow access to CPE config web page access
       even if the CPE is misconfigured.  This is done by checking every imcoming packet from
       the designated backdoor port.

       Do a routeAdd when all of the following conditions are met:
       - not destined to me (MAC DA is not my MAC)
       - came from the designated backdoor port
       - destined IP subnet is the same as the subnet of designated backdoor port
       - the source IP subnet is not the same as the the subnet of the designated backdoor port
         (this is necessary to avoid routeAdd for non-backdoor ARP request)
    */

    /* Check all IP packets.  If the dest IP is the designated backdoor port, and the
       source IP's subnet is not the same as the subnet of the designated backdoor port,
       the packet is treated as a backdoor access packet.
    */
    if ( *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 12 )) == 0x0008 )
    {
        desIpVal = *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 32 ));
        desIpVal = ( desIpVal << 16 ) + *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 30 ));
        if ( desIpVal == pBrBackdoor->AccessIpValue )
        {
            srcIpVal = *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 28 ));
            srcIpVal = ( srcIpVal << 16 ) + *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 26 ));
            srcIpVal1 = srcIpVal & pBrBackdoor->AccessMaskValue;
            if ( srcIpVal1 != ( pBrBackdoor->AccessIpValue & pBrBackdoor->AccessMaskValue ))
                backdoorAccess = TRUE;
        }
    }

    /* Check all ARP packets.  If the dest IP is the designated backdoor port, and the
       source IP's subnet is not the same as the subnet of the designated backdoor port,
       the packet is treated as a backdoor access packet.
    */
    else if ( *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData+12 )) == 0x0608 )
    {
        desIpVal = *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 40 ));
        desIpVal = ( desIpVal << 16 ) + *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 38 ));

        if ( desIpVal == pBrBackdoor->AccessIpValue )
        {
            srcIpVal = *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 30 ));
            srcIpVal = ( srcIpVal << 16 ) + *(( UINT16 * ) ( pNetBuff->mBlkHdr.mData + 28 ));
            srcIpVal1 = srcIpVal & pBrBackdoor->AccessMaskValue;
            if ( srcIpVal1 != ( pBrBackdoor->AccessIpValue & pBrBackdoor->AccessMaskValue ))
                backdoorAccess = TRUE;
        }
        else
        {
            /* The following code is necessary to properly route the ARP response from the PC
               to the protocol stack for the backdoor access.  The ARP response contains the
               the dest IP and dest MAC of the other port's my_mac.
            */
            for ( pPort = pBrBackdoor->pBridgePort->pBridge->pFirstPort;
                    ( pPort != NULL );
                    pPort = pPort->pNext )
            {
                if ( pPort != pBrBackdoor->pBridgePort )
                {
                    if ( 0 == memcmp ( dest_mac, pPort->myMac, 6 ))
                    {
                        backdoorAccess = TRUE;
                        break;
                    }
                }
            }
        }
    }

    /* If this is a backdoor access packet, set up temporary configuration to route
       backdoor packets.
    */
    if ( backdoorAccess )
        br_SetBackdoorAccess( UINT32 srcIpVal, UINT32 srcIpVal1 );

    return ( backdoorAccess );
}
#endif

/******************************************************************************
|
|  Function:    br_CheckBackdoorTimer
|
|  Description: This function is called every second to check and decrement 
|               backdoor running timer.  When timer expires, it removes the
|               temporaty route and HTTP IP entries which enable the backdoor
|               access.
|
|  Parameters:  none
|
|  Returns:     none
|
*******************************************************************************/
void br_CheckBackdoorTimer( void )
{
    if ( pBrBackdoor->RunningTimer )
	{
        pBrBackdoor->RunningTimer--;
		if ( !pBrBackdoor->RunningTimer )
        {            
            routeDelete( pBrBackdoor->AccessRouteIpString, pBrBackdoor->AccessIpString );
            
            if ( pBrBackdoor->httpLocationEntryId != NULL )
            {
                httpIpConfDelete( pBrBackdoor->httpLocationEntryId, pBrBackdoor->httpIpEntryId );
            }
		}
    }
}

/******************************************************************************
|
|  Function:    br_SetBackdoorPort
|
|  Description: This function sets the specified port as the designated backdoor
|               web access port.  Currently we only allow one backdoor web access port.
|
|  Parameters:  pPort   The port to be set to the designated backdoor web access port
|
|  Returns:     OK      This port or its attached virtual port has been set to
|                       the designated backdoor web access port.
|               ERROR   NO
|
*******************************************************************************/
STATUS br_SetBackdoorPort ( BR_PORT *pPort )
{
    char        deviceFullName[MAX_IF_NAME_LEN];

    /* Currently we only allow one backdoor web access port. */
    if ( !pBrBackdoor->pBridgePort )
    {
        if ( pPort->pBVP )
        {
            sprintf ( deviceFullName, "%s%d", ((END_OBJ *)pPort->pBVP)->devObject.name, ((END_OBJ *)pPort->pBVP)->devObject.unit );
        }
        else
        {
            sprintf ( deviceFullName, "%s%d", pPort->ifName, pPort->unit );
        }

        /* Get IP address and IP mask of the backdoor CPE Web access port. */
        if (( ifAddrGet ( deviceFullName, pBrBackdoor->AccessIpString ) == OK ) &&
            ( ifMaskGet ( deviceFullName, (int * )&pBrBackdoor->AccessMaskValue ) == OK ))
        {
            inet_aton ( pBrBackdoor->AccessIpString, (struct in_addr *)&pBrBackdoor->AccessIpValue );
            pBrBackdoor->AccessMaskValue = ntohl( pBrBackdoor->AccessMaskValue );
            pBrBackdoor->TimerReload = BRDG_BACKDOOR_TIMER_SECOND;
            pBrBackdoor->pBridgePort = pPort;
            return OK;
        }
    }
    
    return ERROR;
}


/******************************************************************************
|
|  Function:    BR_BackdoorInit
|
|  Description: This function initializes the backdoor access.  It walks through 
|               all the registered bridge ports.  If the port is configured
|               with backdoor enabled, set the backdoor access.
|
|  Parameters:  none
|
|  Returns:     none
|
*******************************************************************************/
void BR_BackdoorInit( void )
{
    BR_CONTROL  *pBridge;
    BR_PORT     *pPort, *pBridgePort;

    memset(( void * )pBrBackdoor, 0, sizeof( BR_BACKDOOR_STRUCT ));
    
    for ( pBridge = pBrBase->pFirstBridge; pBridge != NULL; pBridge = pBridge->pNext )
    {
        for ( pPort = pBridge->pFirstPort; pPort != NULL; pPort = pPort->pNext )
        {
            if ( pPort->bBackDoor )
            {
                /* Set backdoor access for this port.  If failed, disable this port's
                   backdoor configuration.
                */
                if ( br_SetBackdoorPort ( pPort ) == ERROR )
                    pPort->bBackDoor = FALSE;
            }
        }
    }
}

#endif
