/***************************************************************************** 
$Header:   P:/d874/hasbani/archives/snarf/br_control.h_v   

FILE NAME:	br_control.h

            Copyright 2001 Conexant Systems, Inc. 
            ALL RIGHTS RESERVED
            This file is Conexant proprietary, and all Conexant corporate 
            policies regarding source-file distribution must be observed.

DESCRIPTION:

$Archive:   P:/d874/hasbani/archives/snarf/br_control.h_v  $
$Revision: 1.1.1.1 $
$Date: 2004/04/01 09:10:04 $

$Log: br_control.h,v $
Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
no message

Revision 1.1.1.1  2004/01/16 09:32:57  SHAO-GH
no message

Revision 1.1.1.1  2003/12/23 10:29:08  SHAO-GH
no message

Revision 1.1.1.1  2003/11/21 08:29:26  SHAO-GH
2003.11.20 Shao Guohua use win cvs first time from sourcesafe 

 * 
 *    Rev 1.8   Mar 04 2002 17:32:28   fungcp
 * For DSL downstream short packet throughput 
 * performance via the DSL_DOWNSTREAM_IMPROVE 
 * macro: 
 * 
 * 1. Create the BRDG_VISA_PASS routine that
 * short cut the BR_SnarfRcvRtn call.
 * 
 * 2. Prevent MAC-forward filter out of sync with
 * MAC-table.
 * 
 * 
 *    Rev 1.7   Dec 20 2001 16:05:02   fungcp
 * Resolve 235-NB:
 * Bridge MAC Table not aging out properly.
 * 
 *    Rev 1.6   Dec 19 2001 12:06:36   liniy
 * Moved backdoor fields in BR_BASE structure to 
 * BR_BACKDOOR_STRUCT in br_backdoor.h.
 * 
 *    Rev 1.5   Dec 05 2001 16:49:20   dinhtm
 * Added mac_hash
 * 
 *    Rev 1.4   Dec 03 2001 20:10:32   fungcp
 * For improving short packet performance.
 * Improve the MAC-address learning & forward
 * operation for fast bridging (triggered by the
 * MAC_OPERATION_IMPROVE macro in bspcfg.h):
 * (1) creat a MAC-address learning filter
 * (2) creat a MAC-address forward filter
 * (3) replace semaphore block by an interrupt
 * block when accessing the MAC-address table -
 * to prevent low priority MAC-addr learning & aging 
 * task blocking the higher priority MAC-addr forward
 * operation.
 * Short packet performance improvement: downstream
 * single PVC bridging improves 0.6 Mbps (17.6%).
 * 
 * 
 *    Rev 1.3   Nov 29 2001 13:18:26   fungcp
 *  
 * 
 *    Rev 1.2   Aug 02 2001 17:05:46   liniy
 * Removed references to brdg_end.h
 * 
 *    Rev 1.1   Aug 01 2001 11:42:24   liniy
 * Added "unit" in BR_CONTROL.
 * 
 *    Rev 1.0   Jul 25 2001 10:02:04   liniy
 *  
 * 
********************************************************************************/

#ifndef __BR_CONTROL_H
#define __BR_CONTROL_H

#ifdef __cplusplus
extern "C" {
#endif

#include <inetLib.h>
#include "m2Lib.h"
#include "bspcfg.h"

#define	MAX_IF_NAME_LEN		8

typedef struct br_port_config
{
	UINT32		        portPhysical;
    void				*pBVP;
    struct br_control	*pBridge;
    BOOL                bBackDoor;
	BOOL                bTypeFilterOn;
} BR_PORT_CONFIG;

typedef struct br_mib_struct
{
	UINT32  DelayExceededDiscards;	/* No such discards in Snarfs */
	UINT32  MtuExceededDiscards; 	/* No such discards in Snarfs. Checked by EMAC as */
 									 /* dot3StatsFrameTooLongs 						   */
	UINT32  LearnedEntryDiscards;
	UINT32  InFrames;
	UINT32  OutFrames;
	UINT32  InDiscards;
} BR_MIB;

#ifdef MAC_OPERATION_IMPROVE
typedef	struct _MAC_TMP_INFO
{
	UINT8	MAC[6];
	UINT8	fwd_direction;
	UINT16	pad;
	void	*pPort;
} MAC_TMP_INFO;
#endif

typedef struct br_port
{
    struct br_port  *pNext;
    struct br_port  *pPrev;
    
	char		ifName[MAX_IF_NAME_LEN];
	int			unit;

	void*		pDrvCtrl;
	FUNCPTR		endSend;
	UINT32		portPhysical;
	BR_MIB		brMib;
	UINT8		myMac[6];
	UINT8		pad[2];
    void				*pBVP;
    BOOL                bBackDoor;
	BOOL                bTypeFilterOn;
    struct br_control	*pBridge;

	#ifdef MAC_OPERATION_IMPROVE
	MAC_TMP_INFO		mac_learn;
	MAC_TMP_INFO		mac_fwd;
	#if DSL_DOWNSTREAM_IMPROVE
	UINT32				add_table_cnt;
	#endif
	#endif
} BR_PORT;


typedef struct br_control
{
    struct br_control   *pNext;
    struct br_control   *pPrev;
    UINT32              unit;
    UINT32              totalPort;
    BR_PORT             *pFirstPort;
    BR_PORT             *pLastPort;
} BR_CONTROL;

typedef struct br_base_struct
{
    BR_CONTROL      *pFirstBridge;
    BR_CONTROL      *pLastBridge;
    UINT32          totalBridge;
} BR_BASE;

extern	BR_BASE  	*pBrBase;

#ifdef __cplusplus
}
#endif

#endif   /*  __BR_CONTROL_H */
