/***************************************************************************
 *   MODULE NAME    : brdg_filter.h                                        *
 ***************************************************************************
 *   Copyright 2001 Conexant Systems, Inc. as unpublished work             *
 *   All Rights Reserved                                                   *
 *                                                                         *
 *   The information contained herein is the confidential property         *
 *   of Conexant Systems, Inc..  The use, copying, transfer or             *
 *   disclosure of such information is prohibited except by express        *
 *   written agreement with Conexant Systems, Inc..                        *
 *                                                                         *
 *   Original Written By  :    C W Chen                                    *
 *   Original Date        :    10/10/2001                                  *
 ***************************************************************************/
/***************************************************************************
 * This file implements all the data types, structures and API declaration *
 * of MAC address table provided for MAC Filtering function in EZ-Connect  *
 * project. All the implementaions are in source file "mac_filer.c" file.  *
 ***************************************************************************/

#ifndef _BRDG_FILTER_H_
#define _BRDG_FILTER_H_


#ifndef BRIDGE_FILTERING
#define BRIDGE_FILTERING
#endif

/*-------------------------------------------------------------------------*/
/*                          for bridge filter address table...             */
/*-------------------------------------------------------------------------*/
#define MAX_FILTER_RULE_TBL_SIZE        12
#define RULE_LENGTH                     6
#define GROUP_SIZE                      3

/*-------------------------------------------------------------------------*/
/*                          for bridge filter action...                    */
/*-------------------------------------------------------------------------*/
#define FILTER_BLOCK                    0
#define FILTER_ACCEPT                   1
#define FILTER_NEXT                     2

/*-------------------------------------------------------------------------*/
/*                          bridge filtering enable/disable                */
/*-------------------------------------------------------------------------*/
#ifndef ENABLE
#define ENABLE 1
#endif
#ifndef DISABLE
#define DISABLE 0
#endif

#define BRDG_FILTER_ON   ENABLE
#define BRDG_FILTER_OFF  DISABLE

/*-------------------------------------------------------------------------*/
/*				"func_num" defined in "BRDG_addrTbl_Access()"    	       */
/*-------------------------------------------------------------------------*/
#define FILTER_TBL_INIT				0
#define	FILTER_FUNC_ENABLE			1
#define FILTER_FUNC_DISABLE			2
#define FILTER_TBL_ADD_ENTRY		3
#define FILTER_TBL_DEL_ENTRY		4
//#define FILTER_TBL_MOD_ENTRY        5
#define FILTER_TBL_DATA_CHECK       5
#define FILTER_TBL_GET_ENTRY        6
#define FILTER_TBL_GET_TOTAL        7
#define FILTER_TBL_GET_STATUS       8



/***************************************************************************/
/*                   DATA TYPE AND STRUCTURE DEFINITION                    */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/* Address Table, for bridging function... We maintain only ONE Address    */
/* table for LAN and WAN side altogether... We will be able to tell the    */
/* mac address is from LAN side or which PVC by looking up the             */
/* corresponding "port_num" in address table...                            */
/* The "max_tbl_size" indicates the maximum size of this address table...  */
/* The "currt_tbl_size" indicates the current number of entries in the     */
/* address table...														   */
/*-------------------------------------------------------------------------*/
typedef struct
{
    UINT8   filterActive;         /* Enable/disable */
    UINT8   filterOffset;         /* offset from beginning of packet */
    UINT8   filterLength;         /* length of filter data entry */
    UINT8   filterMask[RULE_LENGTH];  /* Mask for the filter entry */
    UINT8   filterData[RULE_LENGTH];  /* Data of filter entry */
    UINT8   filterNext;           /* daisy-chain? */
    UINT8   filterAction;         /* Block, accept or next */

} STRUCT_BrdgFilterRuleTblEntry;


/* initially, size=0 */
typedef struct
{
    UINT8   filter_function; /* the filter function is enable/disable */
    UINT8   max_tbl_size;           /* max size of rule table */
    UINT8   currt_tbl_size;         /* current number of groups in the table */
    //UINT8   group_size [MAX_FILTER_RULE_TBL_SIZE];    /* Possible Max sets */
    STRUCT_BrdgFilterRuleTblEntry    filterRuleTblEntry[MAX_FILTER_RULE_TBL_SIZE];

} STRUCT_BrdgFilterRuleTbl;


typedef struct
{
    UINT8   offset;                 /* offset from beginning of packet */
    char    mask[13];               /* Mask string for the filter entry */
    char    value[13];              /* Data string of filter entry */
    UINT8   action;                 /* Block, accept or next */

} STRUCT_WebBrdgFilterTbl;



/*------------------------------------------------------------*/
/*          Return status of BRDG_filterTbl_Access()          */
/*------------------------------------------------------------*/
typedef enum
{
	/* the first part of the return status are returned */
	/* directly from internal routines...				*/
	FILTER_OK,					/* general ok */
	FILTER_ERROR,				/* general error */

	FILTER_TBL_FULL,			/* table full error */
	FILTER_TBL_EMPTY,			/* table empty error */
	FILTER_SET_EMPTY,			/* SET empty error */
	FILTER_RULE_EMPTY,			/* Rule empty error */
	FILTER_NOT_IN_TBL,			/* entry not in the table */
    FILTER_DATA_IN_TBL,         /* entry found in the table */

    FILTER_BLOCK_DATA,
    FILTER_FORWARD_DATA,

	/* the following two status mean the function	*/
	/* even haven't been interpreted...				*/
	FILTER_SEM_ERROR,			/* error regarding semaphores				*/
	FILTER_FUNC_ERROR 			/* error regarding func_num interpretation	*/

} FILTER_STATUS;




/***************************************************************************/
/*                          GLOBAL FUNCTION DECLARATION                    */
/***************************************************************************/
FILTER_STATUS   brdgFILTER_CTRL(int func_num, int group_num, int rule_num, void* param);

BOOL
BridgeFilterLoad
(
	char*	pRegPath
);

BOOL
BridgeFilterSave
(
	char*	pRegPath
);

BOOL
BridgeFilterCreateDefault
(
);

/* --------------------------------------------------- */
/*   The following global routines are for debugging   */
/* --------------------------------------------------- */
void d_show_filter_tbl(void);
int BRDGFILTER_Status(void);

//FILTER_STATUS brdgFILTER_enable(void* dummy);
//FILTER_STATUS brdgFILTER_disable(void* dummy);

#endif _BRDG_FILTER_H_



/***************************************************************************/
/* $History$
 */
