/*
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *=========================================================================+
 *
 * Module:      snmpapi_if.h - SNMP API Interfaces Group header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/SnmpApi_if.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This source file contains common definitions used by all
 *              Conexant SNMP Interfaces MIB API modules.
 *
 *=========================================================================+
 */

#ifndef _SNMPAPI_IF_H_
#define _SNMPAPI_IF_H_

#ifdef __cplusplus
extern "C" {
#endif

#define V_ifType_other                  1L
#define V_ifType_regular1822            2L
#define V_ifType_hdh1822                3L
#define V_ifType_ddn_x25                4L
#define V_ifType_rfc877_x25             5L
#define V_ifType_ethernet_csmacd        6L
#define V_ifType_iso88023_csmacd        7L
#define V_ifType_iso88024_tokenBus      8L
#define V_ifType_iso88025_tokenRing     9L
#define V_ifType_iso88026_man           10L
#define V_ifType_starLan                11L
#define V_ifType_proteon_10Mbit         12L
#define V_ifType_proteon_80Mbit         13L
#define V_ifType_hyperchannel           14L
#define V_ifType_fddi                   15L
#define V_ifType_lapb                   16L
#define V_ifType_sdlc                   17L
#define V_ifType_ds1                    18L
#define V_ifType_e1                     19L
#define V_ifType_basicISDN              20L
#define V_ifType_primaryISDN            21L
#define V_ifType_propPointToPointSerial 22L
#define V_ifType_ppp                    23L
#define V_ifType_softwareLoopback       24L
#define V_ifType_eon                    25L
#define V_ifType_ethernet_3Mbit         26L
#define V_ifType_nsip                   27L
#define V_ifType_slip                   28L
#define V_ifType_ultra                  29L
#define V_ifType_ds3                    30L
#define V_ifType_sip                    31L
#define V_ifType_frame_relay            32L
#define V_ifType_atm                    37L
#define V_ifType_aal5                   49L
#define V_ifType_ieee80211              71L
#define V_ifType_adsl                   94L
#define V_ifType_interleave             124L
#define V_ifType_fast                   125L
#define V_ifType_usb                    160L

#define V_ifAdminStatus_up          1L
#define V_ifAdminStatus_down        2L
#define V_ifAdminStatus_testing     3L

#define V_ifOperStatus_up           1L
#define V_ifOperStatus_down         2L
#define V_ifOperStatus_testing      3L


/* Valid field bit definitions */
#define V_ifIndex               0
#define V_ifDescr               1
#define V_ifType                2
#define V_ifMtu                 3
#define V_ifSpeed               4
#define V_ifPhysAddress         5
#define V_ifAdminStatus         6
#define V_ifOperStatus          7
#define V_ifLastChange          8
#define V_ifInOctets            9
#define V_ifInUcastPkts         10
#define V_ifInNUcastPkts        11
#define V_ifInDiscards          12
#define V_ifInErrors            13
#define V_ifInUnknownProtos     14
#define V_ifOutOctets           15
#define V_ifOutUcastPkts        16
#define V_ifOutNUcastPkts       17
#define V_ifOutDiscards         18
#define V_ifOutErrors           19
#define V_ifOutQLen             20
#define V_ifSpecific            21
#define V_ifEntryNumValidFields 22

typedef struct mib_interface_entry
{
    m_UINT32        ifIndex;
    mOctetString    ifDescr;
    m_UINT32        ifType;
    m_UINT32        ifMtu;
    m_UINT32        ifSpeed;
    mOctetString    ifPhysAddress;
    m_UINT32        ifAdminStatus;
    m_UINT32        ifOperStatus;
    m_UINT32        ifLastChange;
    m_UINT32        ifInOctets;
    m_UINT32        ifInUcastPkts;
    m_UINT32        ifInNUcastPkts;
    m_UINT32        ifInDiscards;
    m_UINT32        ifInErrors;
    m_UINT32        ifInUnknownProtos;
    m_UINT32        ifOutOctets;
    m_UINT32        ifOutUcastPkts;
    m_UINT32        ifOutNUcastPkts;
    m_UINT32        ifOutDiscards;
    m_UINT32        ifOutErrors;
    m_UINT32        ifOutQLen;
    mOID            ifSpecific;
    m_UINT32        ifInstance;
    char            valid[MIB_BYTES_FOR_BITS(V_ifEntryNumValidFields)];
    char            pad[MIB_PAD_BYTES(V_ifEntryNumValidFields)];
} MIB_INTERFACE_ENTRY;


#ifdef __cplusplus
}
#endif

#endif /* _SNMPAPI_IF_H_ */

/*
 *=========================================================================+
 * Revision History:
 *
 * $Log: SnmpApi_if.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.2   26 Apr 2002 17:30:40   chen12
 * Add ieee80211 IF type define
 *
 *    Rev 1.1   Nov 09 2001 11:50:04   liniy
 * Cleaned up.
 *
 *    Rev 1.0   Nov 06 2001 16:00:54   liniy
 *
 *
 *=========================================================================+
 */
