/*       
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *=========================================================================+
 *
 * Module:      snmpapi_ifTable.h - SNMP API Interfaces Table header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/SnmpApi_ifTable.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This header file contains definitions and API function
 *              prototypes of Conexant SNMP Interfaces Table.
 * 
 *=========================================================================+
 */

#ifndef _SNMPAPI_IFTABLE_H_
#define _SNMPAPI_IFTABLE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "snmpa/snmpapi_if.h"

//#define SNMP_DEBUG_IFTABLE  1

typedef struct snmp_if_struct
{
    struct 	snmp_if_struct *pIfNext;
    UINT32  ifIndex;
    UINT32  ifInstance;
    UINT32  ifType;
    UINT32  present;
} STRUCT_SNMP_IF;


extern UINT32        	g_ifNumber;
extern UINT32          	g_ifIndex;
extern STRUCT_SNMP_IF  	*pIfFirst, *pIfLast;


extern UINT32           SNMP_GetNumOfIf( UINT32 ifType );
extern void             MIB_IfTableUpdate( void );
extern STRUCT_SNMP_IF*  MIB_IfIndex2IfPtr( UINT32 ifIndex );
extern BOOL             MIB_IfIndexType2Instance ( UINT32 ifIndex, UINT32 ifType, UINT32 *pIfInstance );
extern BOOL             MIB_IsIfPresent ( UINT32 ifIndex );
extern BOOL             MIB_GetFirstIfIndex ( m_UINT32 *pIfIndex, UINT32 ifType );
extern BOOL             MIB_GetNextIfIndex ( m_UINT32 *pIfIndex, UINT32 ifType );
extern UINT32           MIB_GetIfNumber( void );
extern STATUS           MIB_GetIfEntry( MIB_INTERFACE_ENTRY* pData );
extern void             MIB_IfTableInit(void);


#ifdef __cplusplus
}
#endif

#endif /* _SNMPAPI_IFTABLE_H_ */

/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: SnmpApi_ifTable.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.0   Nov 09 2001 11:50:24   liniy
 *  
 * 
 *    Rev 1.0   Nov 06 2001 16:00:54   liniy
 *  
 * 
 *=========================================================================+
 */
