#include <vxWorks.h>

#include "bspcfg.h"
#include "spipeTimer.h"
#include "coretype.h"

#define SNTP_MAIN_TASK_NAME			"tSntpC"

#define SNTP_MAIN_TASK_PRIORITY_INIT		100
#define SNTP_MAIN_TASK_PRIORITY_HIGH		100
#define SNTP_MAIN_TASK_PRIORITY_LOW	    	100

#define SNTP_MAIN_TASK_OPTIONS		    	0x80
#define SNTP_MAIN_TASK_STACKSIZE            5000

#define ONE_SECOND			sysClkRateGet()
#define ONE_MINUTES			(60 * ONE_SECOND)
#define HOUR_OFFSET			3600 /* in seconds */

#define SNTP_QUERY_INTERVAL		ONE_MINUTES
#define SNTP_QUERY_WAIT_TIME        (20 * ONE_SECOND)
#define SNTP_GRP_REALTIME_STR_SIZE		32

/*************************************************************
      data structure
*************************************************************/

typedef struct{
     UINT32		flag;		/* get GMT time or not */
     unsigned long	sntpTimeout;	/* SNTP request interval in Ticks */
     unsigned long	sntpTick;

     unsigned long	secTick;

     time_t		time; 		/* calendar time in seconds  */
     unsigned long      time_diff;	/* in seconds */
#if 0
//   struct tm		timeBuffer;	/* broken-down time */
#endif
     UINT32		NTP_index;	/* index to ntp server ip table */


} SNTP_INFO_T;

void sntpTaskStart(void);

UI32_T sntp_grp_GetTime(time_t* time_P);
