/* adler32.c -- compute the Adler-32 checksum of a data stream
 * Copyright (C) 1995-1998 Mark Adler
 * For conditions of distribution and use, see copyright notice in zlib.h 
 */
/* Copyright 1999 PDS, All Rights Reserved */
/* 
 *    PVCS Information:
 *
 *    $Revision: 1.1.1.1 $
 *    $Date: 2004/04/01 09:10:01 $
 *    $Author: shao-gh $
 *    $Modtime:   23 Nov 1999 15:56:18  $
 *    $Log: adler32.c,v $
 *    Revision 1.1.1.1  2004/04/01 09:10:01  shao-gh
 *    no message
 *
 *    Revision 1.1  2004/02/25 08:22:36  shao-gh
 *    no message
 *
 * 
 *    Rev 1.0   23 Nov 1999 16:01:34   TTY
 * Initial revision.
 * 
 * 
 *
 */

/* @(#) $Id: adler32.c,v 1.1.1.1 2004/04/01 09:10:01 shao-gh Exp $ */

#include "zlib.h"

#define BASE 65521L /* largest prime smaller than 65536 */
#define NMAX 5552
/* NMAX is the largest n such that 255n(n+1)/2 + (n+1)(BASE-1) <= 2^32-1 */

#define DO1(buf,i)  {s1 += buf[i]; s2 += s1;}
#define DO2(buf,i)  DO1(buf,i); DO1(buf,i+1);
#define DO4(buf,i)  DO2(buf,i); DO2(buf,i+2);
#define DO8(buf,i)  DO4(buf,i); DO4(buf,i+4);
#define DO16(buf)   DO8(buf,0); DO8(buf,8);

/* ========================================================================= */
uLong ZEXPORT adler32(adler, buf, len)
    uLong adler;
    const Bytef *buf;
    uInt len;
{
    unsigned long s1 = adler & 0xffff;
    unsigned long s2 = (adler >> 16) & 0xffff;
    int k;

    if (buf == Z_NULL) return 1L;

    while (len > 0) {
        k = len < NMAX ? len : NMAX;
        len -= k;
        while (k >= 16) {
            DO16(buf);
	    buf += 16;
            k -= 16;
        }
        if (k != 0) do {
            s1 += *buf++;
	    s2 += s1;
        } while (--k);
        s1 %= BASE;
        s2 %= BASE;
    }
    return (s2 << 16) | s1;
}
