#ifndef TELNET_H
#define TELNET_H

#define TELNET_MENUS_BUFFER_SIZE    512
#define TELNET_MAX_TERMTYPE_LEN     100

#define TELNET_DAEMON_TCP_SOCKET    23

#ifndef BYTE
typedef  char	BYTE;
#endif

#ifndef pBYTE
typedef BYTE	*pBYTE;
#endif

#ifndef pVOID
typedef VOID	*pVOID;
#endif

#ifndef CHAR
typedef char	CHAR;
#endif

#ifndef pCHAR
typedef CHAR	*pCHAR;
#endif

#ifndef	INT
typedef int	INT;
#endif

#ifndef pINT
typedef INT	*pINT;
#endif

#define TELNET_DEFAULT_MAX_CONN     2  //25

#define TELNET_CONN_STATUS_FREE     0
#define TELNET_CONN_STATUS_USED     1
#define TELNET_OPTION_TERMTYPE      24

#define TELNET_DAEMON_PRIORITY      100
#define TELNET_DAEMON_STACK         10*1024

#define TELNET_SESSION_PRIORITY     100
#define TELNET_SESSION_STACK        20*1024
#define TELNET_CMD_BUFSIZE          256

#define TELNET_OPTION_ECHO          1
#define TELNET_OPTION_SGA           3
#define TELNET_TERMTYPE_SEND        1

#define FTP_SERVER_MAX_CONNECTIONS      1 /* 5 6.7 */
#define MSG_PUSH	            0  /* 0x1234  try */
#define TELNET_HIDE_CHAR            '*'
#define TELNET_TERMTYPE_IS          0


#define TELNET_CMDLINE_PROMPT       "" /*COMM_COMMAND_PROMPT unknown*/
#define TELNET_CMDLINE_PROMPT_LEN   strlen(TELNET_CMDLINE_PROMPT)
 
#define TELNET_EXIT_CMD             "exit"
#define TELNET_EXIT_CMD_LEN         strlen(TELNET_EXIT_CMD)

#define TELNET_LOGOUT_CMD           "logout"
#define TELNET_LOGOUT_CMD_LEN       strlen(TELNET_LOGOUT_CMD)

#define TELNET_QUIT_CMD 			"quit"
#define TELNET_QUIT_CMD_LEN 		strlen(TELNET_QUIT_CMD)


#define MAX_LINE_BUFFER        200    /* size input buffer for incoming command lines */
#define COMM_HIDE_CHAR         '*'
#define MAX_LINE_BUFFER        200    /* size input buffer for incoming command lines */



#define STDIN_BUF_SIZE		512
#define STDOUT_BUF_SIZE		512



/******************************************************************************
 **                       Telnet Constant Definitions                        **	
 ******************************************************************************/
#define TELNET_CMD_IAC          	255
#define TELNET_CMD_DONT         	254
#define TELNET_CMD_DO           	253
#define TELNET_CMD_WONT         	252
#define TELNET_CMD_WILL         	251
#define TELNET_CMD_SB           	250
#define TELNET_CMD_GA           	249
#define TELNET_CMD_EL           	248
#define TELNET_CMD_EC           	247
#define TELNET_CMD_AYT          	246
#define TELNET_CMD_AO           	245
#define TELNET_CMD_IP           	244
#define TELNET_CMD_BRK          	243
#define TELNET_CMD_DATAMARK     	242
#define TELNET_CMD_NOP          	241 
#define TELNET_CMD_SE           	240

#define MAX_LINE_BUFFER        200    /* size input buffer for incoming command lines */
#define COMM_HIDE_CHAR         '*'
#define MAX_LINE_BUFFER        200    /* size input buffer for incoming command lines */




#define	cNULL   '\0'

#define CMDLINE_TYPE_TELNET             1
#define CMDLINE_MODE_HIDE_CHAR          2
#define COMM_COMMAND_PROMPT             "Command>"  /*"# "*/
#define CMDLINE_HISTORY_UP              10
#define CMDLINE_CMD_MAX_TOKENS          20
#define CMDLINE_SKEY_RC_DOWNARROW       40
#define CMDLINE_SKEY_RC_ESC             20
#define CMDLINE_HISTORY_DOWN            20
#define CMDLINE_SKEY_RC_UPARROW         30
#define CMDLINE_SKEY_RC_RIGHTARROW      60
#define CMDLINE_SKEY_RC_LEFTARROW       70
#define CMDLINE_MAX_PASSWORD_LEN        (MAX_CFG_PASSWORD-1)
#define CMDLINE_SKEY_RC_ERROR           0


typedef struct {
	UINT32	    tid;
	BYTE	    status;
	INT	        sock;
	ULONG       remoteIP;
	//pCMDLINEClientEntry	cmdlineClient;
	BYTE	    cmdBuffer[TELNET_CMD_BUFSIZE];
	INT	        cmdPtr;
    INT         cmdNumTabs;
    INT         cmdTabSnap;
	INT	        mode;
	BYTE	    echoOn;
	BYTE	    goAheadOn;
	BYTE	    termType[TELNET_MAX_TERMTYPE_LEN];
	BYTE	    menusOn;
	BYTE	    menusBuffer[TELNET_MENUS_BUFFER_SIZE];
	INT	        menusBufPtr;
	INT	        menusBufCount;
	INT	        menusStartPtr;
	BYTE    	menusOutBuffer[TELNET_MENUS_BUFFER_SIZE];
	INT	        menusOutBufCount;
	
} TELNET_CONN, *pTELNET_CONN;


/*****************************************************************
 *
 *  Prototypes
 *
******************************************************************/
INT TELNETInit( VOID ) ;
void TELNETShowSession (void);
void TELNETDisconnectSession(void);

#endif 
