#ifndef user_init_h
#define user_init_h
/*note, all come from windweb/user_init.c and user_init.h */
#define TEST_OK 					OK
#define TEST_ERROR					ERROR
#define TEST_IN_PROGRESS			3
#define TEST_NA 					4
#define TEST_SKIPPED				5
#define TEST_WARNING				6

#define TEST_INITIAL				0
#define TEST_STARTED				1
#define TEST_ABORTED				2

/* wake up and check the status every 100 ms, thus 10 check per second */
#define numberOfCheckPerSecond 10


#define INET_ADDR_LEN	18
#define MAC_STRLEN		18
#define IP_STRLEN		INET_ADDR_LEN
#define META_BUF_LEN	512
#define URL_LEN 		128
#define SNMP_STRLEN 	128



typedef struct web_rip_struct
{
	short	enable;
	short	supplier_flag;
	short	gateway_flag;
	short	multicast_flag;
	long	interval;
} WEB_RIP_STRUCT;

#ifdef DHCPS_ENABLE
typedef struct web_dhcps_struct
{
	char	start_IP[IP_STRLEN];
	char	end_IP[IP_STRLEN];
	char	preferred_DNS_server[IP_STRLEN];
	char	alt_DNS_server[IP_STRLEN];
	short	server_enable;
	ULONG	lease_time;
	short	reset_address_pool;
	short	dns_option;
	short	dhcp_pool_mode;
} WEB_DHCPS_STRUCT;
#endif


#ifdef PPP_ENABLE
#if (defined(OEM_WEBREDIRECT) && !defined(CNXT_WEBREDIRECT))
enum PPP_ACTION_E
{
	PPP_ACTION_DUAL = 0,
	PPP_ACTION_CONNECT,
	PPP_ACTION_DISCONNECT
};
#else
enum PPP_ACTION_E
{
	PPP_ACTION_CONNECT = 0,
	PPP_ACTION_DISCONNECT,
	PPP_ACTION_DUAL
};
#endif

enum PPP_STATUS_E
{
	PPP_CONNECT = 0,
	PPP_DISCONNECT,
	PPP_WORKING,
	PPP_IDLE,
	PPP_OK,
	PPP_ERROR,
	PPP_NA,
	CONNECTED,
	NOT_CONNECTED,
	PPP_INITIAL,
	PPP_VC_DISABLED
};

#endif // PPP_ENABLE

typedef enum DIAG_HELP_INDEX_E
{
	DIAG_HELP_INDEX_ETHERNETLAN = 0,
	DIAG_HELP_INDEX_DSL,
	DIAG_HELP_INDEX_F5SEGMENT,
	DIAG_HELP_INDEX_F5ENDTOEND,
	DIAG_HELP_INDEX_ETHERNETAAL5,
	DIAG_HELP_INDEX_PPPOECONNECTION,
	DIAG_HELP_INDEX_PPPOE,
	DIAG_HELP_INDEX_PPP,
	DIAG_HELP_INDEX_IPOVERPPP,
	DIAG_HELP_INDEX_IPOVERETHERNET,
	DIAG_HELP_INDEX_PINGGATEWAY,
	DIAG_HELP_INDEX_PINGPRIMARYDNS,
	DIAG_HELP_INDEX_QUERYDNS,
	DIAG_HELO_INDEX_PINGHOST
} DIAG_HELP_INDEX_T;

typedef struct WAN_test_result
{
	UINT32	ATMF5SegmentLoopBack;
	UINT32	ATMF5EndToEndLoopBack;
	UINT32	ATMAAL5;
	UINT32	PPPOE;
	UINT32	PPPOE_PADOReceived;
	UINT32	PPPOE_PADSReceived;
	UINT32	PPP;
	UINT32	IP;
	UINT32	Gateway;//ping gateway result;
} WAN_TEST_RESULT;

typedef struct default_gateway_test_result
{
#ifdef T2_PRMSET_GUI
	char defaultGateway[T2_MAX_VC_PER_LINK][16];
#else
	char defaultGateway[MAX_VC_PER_LINK][16];
#endif
	UINT32 getDefaultGateway; // status of geting default gateway
	UINT32 numberOfDefaultGateway;
#ifdef T2_PRMSET_GUI
	UINT32 pingDefaultGateway[T2_MAX_VC_PER_LINK];
#else
	UINT32 pingDefaultGateway[MAX_VC_PER_LINK];
#endif
} DEFAULT_GATEWAY_TEST_RESULT;

typedef struct DNS_test_result
{
	UINT32 pingPrimaryDNS;
	UINT32 queryHost; /* ok or error */
	UINT32 pingHost; /*the result of ping IPAddressOfHost*/

	char host[256+1]; /* the host name used to test DNS resolver*/
	char pingHostName[256+1]; /* the host name used to test DNS resolver*/
	char primaryDNS[16]; /* ip address of Primary DNS server */
	char IPAddressOfHost[16]; /* the result from DNS server if queryResult == OK */
	char IPAddressOfPingHost[16];
} DNS_TEST_RESULT;

typedef struct diagnose_test_result
{
	UINT32	Ethernet;
	UINT32	DSL;
#ifdef T2_PRMSET_GUI
	WAN_TEST_RESULT WAN[T2_MAX_VC_PER_LINK];
#else
	WAN_TEST_RESULT WAN[MAX_VC_PER_LINK];
#endif
	DEFAULT_GATEWAY_TEST_RESULT defaultGateway;
	DNS_TEST_RESULT  DNS;
} DIAGNOSE_TEST_RESULT;

#endif
