#ifndef _MUXLIB_H_
#define _MUXLIB_H_

#include "netBufLib.h"
#include "netinet/if_ether.h"
#include <net/mbuf.h>
#include <netinet/in.h>
#include <endlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/*note, muxBindEx amd muxUnbindEx use same paramter with muxBind amd muxUnbind */
void * muxBindEx
	(
	char * pName,		/* interface name, for example, ln, ei,... */
	int    unit,				/* unit number */
	BOOL   (*stackRcvRtn) (void*, long, M_BLK_ID, LL_HDR_INFO *, void*),
								/* receive function to be called. */
	STATUS (*stackShutdownRtn) (void*, void*),
								/* routine to call to shutdown the stack */
	STATUS (*stackTxRestartRtn) (void*, void*),
								/* routine to tell the stack it can transmit */
	void   (*stackErrorRtn) (END_OBJ*, END_ERR*, void*),
								/* routine to call on an error. */
	long   type,		/* protocol type from RFC1700 and many */
					/* other sources (for example, 0x800 is IP) */
	char * pProtoName,		/* string name for protocol  */
	void * pSpare				/* per protocol spare pointer  */
	);

STATUS muxUnbindEx
	(
	void *	pCookie,	/* binding cookie from muxBind() or muxTkBind() */
	long	type,	/* type passed to muxBind() or muxTkBind() call */
	FUNCPTR stackRcvRtn /* pointer to stack receive routine */
	);


#ifdef __cplusplus
}
#endif


#endif
