/****************************************************************************
*
*   Name:           NatCfg.h
*
*   Description:    Nat Configuration implementation.
*
*   Copyright:      (c) 2001 Conexant Systems Inc.
*
*   Revision:   Date:       Author:             Description:
*
*   00.00.0000  04/12/02    George G. Vlasov    Created.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Apr 22 2002 08:04:44  $
****************************************************************************/

#ifndef NATCFG_H
#define NATCFG_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"

#include "JxCfgMgr.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

#define NAT_CFG_SESSION_NAME_SIZE_MAX			(32)

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef 
char	NAT_CFG_SESSION_NAME_T[NAT_CFG_SESSION_NAME_SIZE_MAX];

/****************************************************************************
*  Function prototypes
****************************************************************************/

/****************************************************************************
*  CfgMgr interface functions.
****************************************************************************/

BOOL
NatCfgCreateDefault
(
);

BOOL
NatCfgLoad
(
	char*	pRegPath
);

BOOL
NatCfgSave
(
	char*	pRegPath
);

/****************************************************************************
*  WebSrv interface functions.
****************************************************************************/

BOOL 
NatCfgAddSession
(
	char*	pName
);

BOOL 
NatCfgDeleteSession
(
	char*	pName
);

BOOL 
NatCfgEnumerateSession
(
	ULONG					Index, 
	NAT_CFG_SESSION_NAME_T*	pName, 
	NET_IF_ALIAS_T*			pNetIfAlias
);

BOOL 
NatCfgSessionSetNetIfAlias
(
	char*	pName, 
	char*	pNetIfAlias
);

BOOL 
NatCfgSessionAddIpAddress
(
	char*			pName, 
	IP_ADDRESS_T	IpAddress
);

BOOL 
NatCfgSessionEnumerateIpAddress
(
	char*			pName, 
	ULONG			Index, 
	IP_ADDRESS_T*	pIpAddress
);

#endif /* NATCFG_H */ 
