/****************************************************************************
****	Copyright (c) 2001
****	Conexant Systems Inc. (formerly Rockwell Semiconductor Systems)
****	Personal Computing Division
****	All Rights Reserved
****
****	CONFIDENTIAL and PROPRIETARY --
****		No Dissemination or use without prior written permission.
****
*****************************************************************************
MODULE NAME:
		Network Address Port Translation

FILE NAME:
		nat_session_cfg.h

ABSTRACT:

DETAILS:

KEYWORDS:
        $Archive:   P:/d874/hasbani/archives/NAT_freebsd-header/nat_session_cfg.h_v  $
        $Revision: 1.1.1.1 $
        $Date: 2004/04/01 09:10:01 $
****************************************************************************/
#ifndef _NAT_SESSION_CFG_H
#define _NAT_SESSION_CFG_H

/***************************************************************************/
/*                    INCLUDE SECTION                                      */
/***************************************************************************/

/***************************************************************************/
/*                LOCAL CONSTANT DEFINITION SECTION                        */
/***************************************************************************/

/* Disable default session (obsolete) */
#undef NAT_DEFAULT_SESSION_ENABLE

#define NAT_MAX_IF_NAME_OLEN        32
#define NAT_MAX_IF_ALIAS_OLEN		32
#define NAT_MAX_SESSION_NAME_OLEN   32

#define NAT_MAX_IF                  32  //wan:8+8+6, lan:emac,usb,wlan,br
#define NAT_MAX_SESSION             64
#define NAT_MAX_ENTRY               253
/***************************************************************************
 *                      LOCAL TYPEDEF                                      *
 ***************************************************************************/
typedef struct nat_default_session
{
    char    default_session[NAT_MAX_SESSION_NAME_OLEN + 1];
} NAT_DEFAULT_SESSION_T;

typedef struct nat_session_info
{
    char    session_name[NAT_MAX_SESSION_NAME_OLEN + 1];
    char    if_name[NAT_MAX_IF_NAME_OLEN + 1];
    char    alias_name[NAT_MAX_IF_ALIAS_OLEN + 1];
    UINT32  wan_index;
} NAT_SESSION_INFO_T;


typedef struct nat_session_entry
{
    char    session_name[NAT_MAX_SESSION_NAME_OLEN + 1];
    UINT32  ip_addr;
} NAT_SESSION_ENTRY_T;


/***************************************************************************/
/*              LOCAL MACRO SECTION                                        */
/***************************************************************************/

/***************************************************************************/
/*              LOCAL VARIABLES DECLARATION                                */
/***************************************************************************/

/***************************************************************************/
/*              EXTERMAL VARIABLES DECLARATION                             */
/***************************************************************************/

/***************************************************************************/
/*              GLOBAL FUNCTION PROTOTYPE SECTION                          */
/***************************************************************************/

BOOL NatLoad(char *);
BOOL NatSrvGetDefault(void);
BOOL NatSrvSave(char* pRegPath);
void Nat_Start(void);
BOOL NatModuleInit(void);
BOOL NatNetIfRegister(char* pAlias, char* pIfName, UINT32 Type);
BOOL NatNetIfUnregister(char* pAlias);
BOOL NAT_IF_Add(char* NetIfAlias, UINT32 NetIfAliasType);
int NAT_WanIfCount(void);
STATUS NAT_WanIndex_Get_ByIp(UINT32 ip_addr, UINT32 *index);
STATUS NAT_SESSION_FindIndex_ByInterface(char *pEndName, int unit, UINT32 *index);
BOOL NatCheckIf(char *pIfName, UINT32 unit, UINT32 type);
BOOL NAT_SESSION_Add(char* SessionName, char* AliasName);
NAT_SESSION_INFO_T* NAT_SESSION_Get_BySessionName(char* SessionName);
STATUS NAT_SESSION_Show(void);
BOOL NAT_SESSION_IP_Add(char* SessionName, UINT32 IpAddress);
STATUS NAT_SESSION_IP_Show(void);
STATUS NAT_SESSION_Init(void);
STATUS NAT_SESSION_ReInit(void);
BOOL NAT_SESSION_Active(UINT32 index, BOOL defaultSession);
STATUS NAT_ActivateDefaultSession(void);
STATUS NAT_ActivateSession(UINT32 index);

#endif  /* _NAT_SESSION_CFG_H */
