#ifndef _ICE_H
#define _ICE_H

/*
 * Copyright (C) 2005 by egnite Software GmbH
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/*!
 * \file ice.h
 *
 * \verbatim
 *
 * $Log: ice.h,v $
 * Revision 1.3  2006/03/20 14:16:40  haraldkipp
 * Release 1.2.4.
 *
 * Revision 1.2  2006/01/09 09:03:39  haraldkipp
 * Programming adapter firmware update added.
 *
 * Revision 1.1.1.1  2005/09/14 09:01:09  haraldkipp
 * Initial import.
 *
 *
 * \endverbatim
 */

#include <stdio.h>

extern void IceInit(void);
extern void IceExit(void);
extern void IceReset(void);

extern int IceEnterDebug(void);
extern int IceExitDebug(void);
extern unsigned long IceIdCode(void);

extern int IceMemoryRead(unsigned long addr, unsigned long *data);
extern int IceMemoryWrite(unsigned long addr, unsigned long data);
extern int IceMultiWrite(unsigned long addr, unsigned long *data);

extern int IceCpuRegRead(char *name, unsigned long *data);
extern int IceCpuRegWrite(char *name, unsigned long data);

extern int IceComRead(unsigned long *data);
extern int IceComWrite(unsigned long data);

extern void IcePrintStatus(FILE * fp);

extern int IceUpdate(unsigned char *image, unsigned long len);

#endif
